/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ChangelogMergeTreeRewriter;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.FullChangelogMergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.utils.Preconditions;

public class FullChangelogMergeTreeCompactRewriter
extends ChangelogMergeTreeRewriter {
    private final int maxLevel;

    public FullChangelogMergeTreeCompactRewriter(int maxLevel, KeyValueFileReaderFactory readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<InternalRow> keyComparator, MergeFunctionFactory<KeyValue> mfFactory, MergeSorter mergeSorter, RecordEqualiser valueComparator, boolean changelogRowDeduplicate) {
        super(readerFactory, writerFactory, keyComparator, mfFactory, mergeSorter, valueComparator, changelogRowDeduplicate);
        this.maxLevel = maxLevel;
    }

    @Override
    protected boolean rewriteChangelog(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) {
        boolean changelog;
        boolean bl = changelog = outputLevel == this.maxLevel;
        if (changelog) {
            Preconditions.checkArgument((boolean)dropDelete, (Object)"Delete records should be dropped from result of full compaction. This is unexpected.");
        }
        return changelog;
    }

    @Override
    protected boolean upgradeChangelog(int outputLevel, DataFileMeta file) {
        return outputLevel == this.maxLevel;
    }

    @Override
    protected MergeFunctionWrapper<ChangelogResult> createMergeWrapper(int outputLevel) {
        return new FullChangelogMergeFunctionWrapper(this.mfFactory.create(), this.maxLevel, this.valueEqualiser, this.changelogRowDeduplicate);
    }

    @Override
    public void close() throws IOException {
    }
}

