/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.ValueCountMergeFunction;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.Preconditions;

public class FullChangelogMergeFunctionWrapper
implements MergeFunctionWrapper<ChangelogResult> {
    private final MergeFunction<KeyValue> mergeFunction;
    private final int maxLevel;
    private final RecordEqualiser valueEqualiser;
    private final boolean changelogRowDeduplicate;
    private KeyValue topLevelKv;
    private KeyValue initialKv;
    private boolean isInitialized;
    private final ChangelogResult reusedResult = new ChangelogResult();
    private final KeyValue reusedBefore = new KeyValue();
    private final KeyValue reusedAfter = new KeyValue();

    public FullChangelogMergeFunctionWrapper(MergeFunction<KeyValue> mergeFunction, int maxLevel, RecordEqualiser valueEqualiser, boolean changelogRowDeduplicate) {
        Preconditions.checkArgument((!(mergeFunction instanceof ValueCountMergeFunction) ? 1 : 0) != 0, (Object)"Value count merge function does not need to produce changelog from full compaction. Please set changelog producer to 'input'.");
        this.mergeFunction = mergeFunction;
        this.maxLevel = maxLevel;
        this.valueEqualiser = valueEqualiser;
        this.changelogRowDeduplicate = changelogRowDeduplicate;
    }

    @Override
    public void reset() {
        this.mergeFunction.reset();
        this.topLevelKv = null;
        this.initialKv = null;
        this.isInitialized = false;
    }

    @Override
    public void add(KeyValue kv) {
        if (this.maxLevel == kv.level()) {
            Preconditions.checkState((this.topLevelKv == null ? 1 : 0) != 0, (Object)"Top level key-value already exists! This is unexpected.");
            this.topLevelKv = kv;
        }
        if (this.initialKv == null) {
            this.initialKv = kv;
        } else {
            if (!this.isInitialized) {
                this.merge(this.initialKv);
                this.isInitialized = true;
            }
            this.merge(kv);
        }
    }

    private void merge(KeyValue kv) {
        this.mergeFunction.add(kv);
    }

    @Override
    public ChangelogResult getResult() {
        this.reusedResult.reset();
        if (this.isInitialized) {
            KeyValue merged = this.mergeFunction.getResult();
            if (this.topLevelKv == null) {
                if (merged != null && this.isAdd(merged)) {
                    this.reusedResult.addChangelog(this.replace(this.reusedAfter, RowKind.INSERT, merged));
                }
            } else if (merged == null || !this.isAdd(merged)) {
                this.reusedResult.addChangelog(this.replace(this.reusedBefore, RowKind.DELETE, this.topLevelKv));
            } else if (!this.changelogRowDeduplicate || !this.valueEqualiser.equals(this.topLevelKv.value(), merged.value())) {
                this.reusedResult.addChangelog(this.replace(this.reusedBefore, RowKind.UPDATE_BEFORE, this.topLevelKv)).addChangelog(this.replace(this.reusedAfter, RowKind.UPDATE_AFTER, merged));
            }
            return this.reusedResult.setResultIfNotRetract(merged);
        }
        if (this.topLevelKv == null && this.isAdd(this.initialKv)) {
            this.reusedResult.addChangelog(this.replace(this.reusedAfter, RowKind.INSERT, this.initialKv));
        }
        return this.reusedResult.setResultIfNotRetract(this.initialKv);
    }

    private KeyValue replace(KeyValue reused, RowKind valueKind, KeyValue from) {
        return reused.replace(from.key(), from.sequenceNumber(), valueKind, from.value());
    }

    private boolean isAdd(KeyValue kv) {
        return kv.valueKind() == RowKind.INSERT || kv.valueKind() == RowKind.UPDATE_AFTER;
    }
}

