/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.AbstractFileRecordIterator;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.FileUtils;

public class RowDataFileRecordReader
implements RecordReader<InternalRow> {
    private final RecordReader<InternalRow> reader;
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final CastFieldGetter[] castMapping;

    public RowDataFileRecordReader(FileIO fileIO, Path path, FormatReaderFactory readerFactory, @Nullable int[] indexMapping, @Nullable CastFieldGetter[] castMapping) throws IOException {
        this.reader = FileUtils.createFormatReader(fileIO, readerFactory, path);
        this.indexMapping = indexMapping;
        this.castMapping = castMapping;
    }

    @Nullable
    public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
        RecordReader.RecordIterator iterator = this.reader.readBatch();
        return iterator == null ? null : new RowDataFileRecordIterator(iterator, this.indexMapping, this.castMapping);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private static class RowDataFileRecordIterator
    extends AbstractFileRecordIterator<InternalRow> {
        private final RecordReader.RecordIterator<InternalRow> iterator;

        private RowDataFileRecordIterator(RecordReader.RecordIterator<InternalRow> iterator, @Nullable int[] indexMapping, @Nullable CastFieldGetter[] castMapping) {
            super(indexMapping, castMapping);
            this.iterator = iterator;
        }

        public InternalRow next() throws IOException {
            InternalRow result = (InternalRow)this.iterator.next();
            return result == null ? null : this.mappingRowData(result);
        }

        public void releaseBatch() {
            this.iterator.releaseBatch();
        }
    }
}

