/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueSerializer;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.AbstractFileRecordIterator;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileUtils;

public class KeyValueDataFileRecordReader
implements RecordReader<KeyValue> {
    private final RecordReader<InternalRow> reader;
    private final KeyValueSerializer serializer;
    private final int level;
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final CastFieldGetter[] castMapping;

    public KeyValueDataFileRecordReader(FileIO fileIO, FormatReaderFactory readerFactory, Path path, RowType keyType, RowType valueType, int level, @Nullable int[] indexMapping, @Nullable CastFieldGetter[] castMapping) throws IOException {
        this.reader = FileUtils.createFormatReader(fileIO, readerFactory, path);
        this.serializer = new KeyValueSerializer(keyType, valueType);
        this.level = level;
        this.indexMapping = indexMapping;
        this.castMapping = castMapping;
    }

    @Nullable
    public RecordReader.RecordIterator<KeyValue> readBatch() throws IOException {
        RecordReader.RecordIterator iterator = this.reader.readBatch();
        return iterator == null ? null : new KeyValueDataFileRecordIterator(iterator, this.indexMapping, this.castMapping);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private class KeyValueDataFileRecordIterator
    extends AbstractFileRecordIterator<KeyValue> {
        private final RecordReader.RecordIterator<InternalRow> iterator;

        private KeyValueDataFileRecordIterator(@Nullable RecordReader.RecordIterator<InternalRow> iterator, @Nullable int[] indexMapping, CastFieldGetter[] castMapping) {
            super(indexMapping, castMapping);
            this.iterator = iterator;
        }

        public KeyValue next() throws IOException {
            InternalRow result = (InternalRow)this.iterator.next();
            if (result == null) {
                return null;
            }
            return KeyValueDataFileRecordReader.this.serializer.fromRow(this.mappingRowData(result)).setLevel(KeyValueDataFileRecordReader.this.level);
        }

        public void releaseBatch() {
            this.iterator.releaseBatch();
        }
    }
}

