/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SerializationUtils;

public class IndexFileMeta {
    private final String indexType;
    private final String fileName;
    private final long fileSize;
    private final long rowCount;

    public IndexFileMeta(String indexType, String fileName, long fileSize, long rowCount) {
        this.indexType = indexType;
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.rowCount = rowCount;
    }

    public String indexType() {
        return this.indexType;
    }

    public String fileName() {
        return this.fileName;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public long rowCount() {
        return this.rowCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexFileMeta that = (IndexFileMeta)o;
        return Objects.equals(this.indexType, that.indexType) && Objects.equals(this.fileName, that.fileName) && this.fileSize == that.fileSize && this.rowCount == that.rowCount;
    }

    public int hashCode() {
        return Objects.hash(this.indexType, this.fileName, this.fileSize, this.rowCount);
    }

    public String toString() {
        return "IndexManifestEntry{indexType=" + this.indexType + ", fileName='" + this.fileName + '\'' + ", fileSize=" + this.fileSize + ", rowCount=" + this.rowCount + '}';
    }

    public static RowType schema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_INDEX_TYPE", (DataType)SerializationUtils.newStringType(false)));
        fields.add(new DataField(1, "_FILE_NAME", (DataType)SerializationUtils.newStringType(false)));
        fields.add(new DataField(2, "_FILE_SIZE", (DataType)new BigIntType(false)));
        fields.add(new DataField(3, "_ROW_COUNT", (DataType)new BigIntType(false)));
        return new RowType(fields);
    }
}

