/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.index.HashIndexFile;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.IndexManifestFile;
import org.apache.paimon.utils.IntIterator;
import org.apache.paimon.utils.SnapshotManager;

public class IndexFileHandler {
    private final SnapshotManager snapshotManager;
    private final IndexManifestFile indexManifestFile;
    private final HashIndexFile hashIndex;

    public IndexFileHandler(SnapshotManager snapshotManager, IndexManifestFile indexManifestFile, HashIndexFile hashIndex) {
        this.snapshotManager = snapshotManager;
        this.indexManifestFile = indexManifestFile;
        this.hashIndex = hashIndex;
    }

    public Optional<IndexFileMeta> scan(long snapshotId, String indexType, BinaryRow partition, int bucket) {
        List<IndexManifestEntry> entries = this.scan(snapshotId, indexType, partition);
        ArrayList<IndexManifestEntry> result = new ArrayList<IndexManifestEntry>();
        for (IndexManifestEntry file : entries) {
            if (file.bucket() != bucket) continue;
            result.add(file);
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException("Find multiple index files for one bucket: " + result);
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(((IndexManifestEntry)result.get(0)).indexFile());
    }

    public List<IndexManifestEntry> scan(String indexType, BinaryRow partition) {
        Long snapshot = this.snapshotManager.latestSnapshotId();
        if (snapshot == null) {
            return Collections.emptyList();
        }
        return this.scan(snapshot, indexType, partition);
    }

    public List<IndexManifestEntry> scan(long snapshotId, String indexType, BinaryRow partition) {
        Snapshot snapshot = this.snapshotManager.snapshot(snapshotId);
        String indexManifest = snapshot.indexManifest();
        if (indexManifest == null) {
            return Collections.emptyList();
        }
        List allFiles = this.indexManifestFile.read(indexManifest);
        ArrayList<IndexManifestEntry> result = new ArrayList<IndexManifestEntry>();
        for (IndexManifestEntry file : allFiles) {
            if (!file.indexFile().indexType().equals(indexType) || !file.partition().equals((Object)partition)) continue;
            result.add(file);
        }
        return result;
    }

    public List<Integer> readHashIndexList(IndexFileMeta file) {
        return IntIterator.toIntList((IntIterator)this.readHashIndex(file));
    }

    public IntIterator readHashIndex(IndexFileMeta file) {
        if (!file.indexType().equals("HASH")) {
            throw new IllegalArgumentException("Input file is not hash index: " + file.indexType());
        }
        try {
            return this.hashIndex.read(file.fileName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public IndexFileMeta writeHashIndex(int[] ints) {
        return this.writeHashIndex(ints.length, IntIterator.create((int[])ints));
    }

    public IndexFileMeta writeHashIndex(int size, IntIterator iterator) {
        String file;
        try {
            file = this.hashIndex.write(iterator);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new IndexFileMeta("HASH", file, this.hashIndex.fileSize(file), size);
    }

    public boolean existsManifest(String indexManifest) {
        return this.indexManifestFile.exists(indexManifest);
    }

    public List<IndexManifestEntry> readManifest(String indexManifest) {
        return this.indexManifestFile.read(indexManifest);
    }

    public boolean existsIndexFile(IndexManifestEntry file) {
        return this.hashIndex.exists(file.indexFile().fileName());
    }

    public void deleteIndexFile(IndexManifestEntry file) {
        this.hashIndex.delete(file.indexFile().fileName());
    }

    public void deleteManifest(String indexManifest) {
        this.indexManifestFile.delete(indexManifest);
    }
}

