/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.index.IndexMaintainer;
import org.apache.paimon.utils.IntHashSet;
import org.apache.paimon.utils.IntIterator;

public class HashIndexMaintainer
implements IndexMaintainer<KeyValue> {
    private final IndexFileHandler fileHandler;
    private final IntHashSet hashcode;
    private boolean modified;

    private HashIndexMaintainer(IndexFileHandler fileHandler, Long snapshotId, BinaryRow partition, int bucket) {
        Optional<IndexFileMeta> indexFile;
        this.fileHandler = fileHandler;
        IntHashSet hashcode = new IntHashSet();
        if (snapshotId != null && (indexFile = fileHandler.scan(snapshotId, "HASH", partition, bucket)).isPresent()) {
            IndexFileMeta file = indexFile.get();
            hashcode = new IntHashSet((int)file.rowCount());
            this.restore(fileHandler, hashcode, file);
        }
        this.hashcode = hashcode;
        this.modified = false;
    }

    private void restore(IndexFileHandler fileHandler, IntHashSet hashcode, IndexFileMeta file) {
        try {
            IntIterator iterator = fileHandler.readHashIndex(file);
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        hashcode.add(iterator.next());
                    }
                }
                catch (EOFException ignored) {
                    if (iterator != null) {
                        if (throwable != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            iterator.close();
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (iterator != null) {
                        if (throwable != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            iterator.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void notifyNewRecord(KeyValue record) {
        InternalRow key = record.key();
        if (!(key instanceof BinaryRow)) {
            throw new IllegalArgumentException("Unsupported key type: " + key.getClass());
        }
        boolean changed = this.hashcode.add(key.hashCode());
        if (changed) {
            this.modified = true;
        }
    }

    @Override
    public List<IndexFileMeta> prepareCommit() {
        if (this.modified) {
            IndexFileMeta entry = this.fileHandler.writeHashIndex(this.hashcode.size(), this.hashcode.toIntIterator());
            this.modified = false;
            return Collections.singletonList(entry);
        }
        return Collections.emptyList();
    }

    public static class Factory
    implements IndexMaintainer.Factory<KeyValue> {
        private final IndexFileHandler handler;

        public Factory(IndexFileHandler handler) {
            this.handler = handler;
        }

        @Override
        public IndexMaintainer<KeyValue> createOrRestore(Long snapshotId, BinaryRow partition, int bucket) {
            return new HashIndexMaintainer(this.handler, snapshotId, partition, bucket);
        }
    }
}

