/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLock;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;

public class FileSystemCatalog
extends AbstractCatalog {
    private final Path warehouse;

    public FileSystemCatalog(FileIO fileIO, Path warehouse) {
        super(fileIO);
        this.warehouse = warehouse;
    }

    public FileSystemCatalog(FileIO fileIO, Path warehouse, Map<String, String> options) {
        super(fileIO, options);
        this.warehouse = warehouse;
    }

    @Override
    public Optional<CatalogLock.Factory> lockFactory() {
        return Optional.empty();
    }

    @Override
    public List<String> listDatabases() {
        ArrayList<String> databases = new ArrayList<String>();
        for (FileStatus status : FileSystemCatalog.uncheck(() -> this.fileIO.listStatus(this.warehouse))) {
            Path path = status.getPath();
            if (!status.isDir() || !FileSystemCatalog.isDatabase(path)) continue;
            databases.add(FileSystemCatalog.database(path));
        }
        return databases;
    }

    @Override
    public boolean databaseExists(String databaseName) {
        if (this.isSystemDatabase(databaseName)) {
            return true;
        }
        return FileSystemCatalog.uncheck(() -> this.fileIO.exists(this.databasePath(databaseName)));
    }

    @Override
    public void createDatabase(String name, boolean ignoreIfExists) throws Catalog.DatabaseAlreadyExistException {
        if (this.isSystemDatabase(name)) {
            throw new Catalog.ProcessSystemDatabaseException();
        }
        if (this.databaseExists(name)) {
            if (ignoreIfExists) {
                return;
            }
            throw new Catalog.DatabaseAlreadyExistException(name);
        }
        FileSystemCatalog.uncheck(() -> this.fileIO.mkdirs(this.databasePath(name)));
    }

    @Override
    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws Catalog.DatabaseNotExistException, Catalog.DatabaseNotEmptyException {
        if (this.isSystemDatabase(name)) {
            throw new Catalog.ProcessSystemDatabaseException();
        }
        if (!this.databaseExists(name)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.DatabaseNotExistException(name);
        }
        if (!cascade && this.listTables(name).size() > 0) {
            throw new Catalog.DatabaseNotEmptyException(name);
        }
        FileSystemCatalog.uncheck(() -> this.fileIO.delete(this.databasePath(name), true));
    }

    @Override
    public List<String> listTables(String databaseName) throws Catalog.DatabaseNotExistException {
        if (this.isSystemDatabase(databaseName)) {
            return GLOBAL_TABLES;
        }
        if (!this.databaseExists(databaseName)) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
        ArrayList<String> tables = new ArrayList<String>();
        for (FileStatus status : FileSystemCatalog.uncheck(() -> this.fileIO.listStatus(this.databasePath(databaseName)))) {
            if (!status.isDir() || !this.tableExists(status.getPath())) continue;
            tables.add(status.getPath().getName());
        }
        return tables;
    }

    @Override
    public TableSchema getDataTableSchema(Identifier identifier) throws Catalog.TableNotExistException {
        Path path = this.getDataTableLocation(identifier);
        return new SchemaManager(this.fileIO, path).latest().orElseThrow(() -> new Catalog.TableNotExistException(identifier));
    }

    private boolean tableExists(Path tablePath) {
        return new SchemaManager(this.fileIO, tablePath).listAllIds().size() > 0;
    }

    @Override
    public void dropTable(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        this.checkNotSystemTable(identifier, "dropTable");
        Path path = this.getDataTableLocation(identifier);
        if (!this.tableExists(path)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.TableNotExistException(identifier);
        }
        FileSystemCatalog.uncheck(() -> this.fileIO.delete(path, true));
    }

    @Override
    public void createTable(Identifier identifier, Schema schema, boolean ignoreIfExists) throws Catalog.TableAlreadyExistException, Catalog.DatabaseNotExistException {
        this.checkNotSystemTable(identifier, "createTable");
        if (!this.databaseExists(identifier.getDatabaseName())) {
            throw new Catalog.DatabaseNotExistException(identifier.getDatabaseName());
        }
        Path path = this.getDataTableLocation(identifier);
        if (this.tableExists(path)) {
            if (ignoreIfExists) {
                return;
            }
            throw new Catalog.TableAlreadyExistException(identifier);
        }
        this.copyTableDefaultOptions(schema.options());
        FileSystemCatalog.uncheck(() -> new SchemaManager(this.fileIO, path).createTable(schema));
    }

    @Override
    public void renameTable(Identifier fromTable, Identifier toTable, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.TableAlreadyExistException {
        this.checkNotSystemTable(fromTable, "renameTable");
        this.checkNotSystemTable(toTable, "renameTable");
        Path fromPath = this.getDataTableLocation(fromTable);
        if (!this.tableExists(fromPath)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.TableNotExistException(fromTable);
        }
        Path toPath = this.getDataTableLocation(toTable);
        if (this.tableExists(toPath)) {
            throw new Catalog.TableAlreadyExistException(toTable);
        }
        FileSystemCatalog.uncheck(() -> this.fileIO.rename(fromPath, toPath));
    }

    @Override
    public void alterTable(Identifier identifier, List<SchemaChange> changes, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        this.checkNotSystemTable(identifier, "alterTable");
        if (!this.tableExists(this.getDataTableLocation(identifier))) {
            throw new Catalog.TableNotExistException(identifier);
        }
        new SchemaManager(this.fileIO, this.getDataTableLocation(identifier)).commitChanges(changes);
    }

    private static <T> T uncheck(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isDatabase(Path path) {
        return path.getName().endsWith(".db");
    }

    private static String database(Path path) {
        String name = path.getName();
        return name.substring(0, name.length() - ".db".length());
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    protected String warehouse() {
        return this.warehouse.toString();
    }
}

