/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.lineage.LineageMeta;
import org.apache.paimon.lineage.LineageMetaFactory;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.system.SystemTableLoader;
import org.apache.paimon.utils.StringUtils;

public abstract class AbstractCatalog
implements Catalog {
    public static final String DB_SUFFIX = ".db";
    protected static final String TABLE_DEFAULT_OPTION_PREFIX = "table-default.";
    protected static final List<String> GLOBAL_TABLES = Arrays.asList("all_table_options");
    protected final FileIO fileIO;
    protected final Map<String, String> tableDefaultOptions;
    @Nullable
    protected final LineageMeta lineageMeta;

    protected AbstractCatalog(FileIO fileIO) {
        this.fileIO = fileIO;
        this.lineageMeta = null;
        this.tableDefaultOptions = new HashMap<String, String>();
    }

    protected AbstractCatalog(FileIO fileIO, Map<String, String> options) {
        this.fileIO = fileIO;
        this.lineageMeta = this.findAndCreateLineageMeta(Options.fromMap(options), AbstractCatalog.class.getClassLoader());
        this.tableDefaultOptions = new HashMap<String, String>();
        options.keySet().stream().filter(key -> key.startsWith(TABLE_DEFAULT_OPTION_PREFIX)).forEach(key -> this.tableDefaultOptions.put(key.substring(TABLE_DEFAULT_OPTION_PREFIX.length()), (String)options.get(key)));
    }

    @Nullable
    private LineageMeta findAndCreateLineageMeta(Options options, ClassLoader classLoader) {
        return options.getOptional(CatalogOptions.LINEAGE_META).map(meta -> ((LineageMetaFactory)FactoryUtil.discoverFactory((ClassLoader)classLoader, LineageMetaFactory.class, (String)meta)).create(() -> options)).orElse(null);
    }

    @Override
    public Table getTable(Identifier identifier) throws Catalog.TableNotExistException {
        if (this.isSystemDatabase(identifier.getDatabaseName())) {
            String tableName = identifier.getObjectName();
            Table table = SystemTableLoader.loadGlobal(tableName, this.fileIO, this.allTablePaths());
            if (table == null) {
                throw new Catalog.TableNotExistException(identifier);
            }
            return table;
        }
        if (AbstractCatalog.isSpecifiedSystemTable(identifier)) {
            String[] splits = this.tableAndSystemName(identifier);
            String tableName = splits[0];
            String type = splits[1];
            FileStoreTable originTable = this.getDataTable(new Identifier(identifier.getDatabaseName(), tableName));
            Table table = SystemTableLoader.load(type, this.fileIO, originTable);
            if (table == null) {
                throw new Catalog.TableNotExistException(identifier);
            }
            return table;
        }
        return this.getDataTable(identifier);
    }

    private FileStoreTable getDataTable(Identifier identifier) throws Catalog.TableNotExistException {
        TableSchema tableSchema = this.getDataTableSchema(identifier);
        return FileStoreTableFactory.create(this.fileIO, this.getDataTableLocation(identifier), tableSchema, new CatalogEnvironment(Lock.factory(this.lockFactory().orElse(null), identifier), this.metastoreClientFactory(identifier).orElse(null), this.lineageMeta));
    }

    @VisibleForTesting
    public Path databasePath(String database) {
        return AbstractCatalog.databasePath(this.warehouse(), database);
    }

    Map<String, Map<String, Path>> allTablePaths() {
        try {
            HashMap<String, Map<String, Path>> allPaths = new HashMap<String, Map<String, Path>>();
            for (String database : this.listDatabases()) {
                Map tableMap = allPaths.computeIfAbsent(database, d -> new HashMap());
                for (String table : this.listTables(database)) {
                    tableMap.put(table, AbstractCatalog.dataTableLocation(this.warehouse(), Identifier.create(database, table)));
                }
            }
            return allPaths;
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new RuntimeException("Database is deleted while listing", e);
        }
    }

    protected abstract String warehouse();

    protected abstract TableSchema getDataTableSchema(Identifier var1) throws Catalog.TableNotExistException;

    @VisibleForTesting
    public Path getDataTableLocation(Identifier identifier) {
        return AbstractCatalog.dataTableLocation(this.warehouse(), identifier);
    }

    private static boolean isSpecifiedSystemTable(Identifier identifier) {
        return identifier.getObjectName().contains("$");
    }

    protected void checkNotSystemTable(Identifier identifier, String method) {
        if (this.isSystemDatabase(identifier.getDatabaseName()) || AbstractCatalog.isSpecifiedSystemTable(identifier)) {
            throw new IllegalArgumentException(String.format("Cannot '%s' for system table '%s', please use data table.", method, identifier));
        }
    }

    public void copyTableDefaultOptions(Map<String, String> options) {
        this.tableDefaultOptions.forEach(options::putIfAbsent);
    }

    private String[] tableAndSystemName(Identifier identifier) {
        String[] splits = StringUtils.split((String)identifier.getObjectName(), (String)"$");
        if (splits.length != 2) {
            throw new IllegalArgumentException("System table can only contain one '$' separator, but this is: " + identifier.getObjectName());
        }
        return splits;
    }

    public static Path dataTableLocation(String warehouse, Identifier identifier) {
        if (AbstractCatalog.isSpecifiedSystemTable(identifier)) {
            throw new IllegalArgumentException(String.format("Table name[%s] cannot contain '%s' separator", identifier.getObjectName(), "$"));
        }
        return new Path(AbstractCatalog.databasePath(warehouse, identifier.getDatabaseName()), identifier.getObjectName());
    }

    public static Path databasePath(String warehouse, String database) {
        return new Path(warehouse, database + DB_SUFFIX);
    }

    protected boolean isSystemDatabase(String database) {
        return "sys".equals(database);
    }
}

