/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.append;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.NewFilesIncrement;
import org.apache.paimon.io.RowDataRollingFileWriter;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.LongCounter;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RecordWriter;

public class AppendOnlyWriter
implements RecordWriter<InternalRow> {
    private final FileIO fileIO;
    private final long schemaId;
    private final FileFormat fileFormat;
    private final long targetFileSize;
    private final RowType writeSchema;
    private final DataFilePathFactory pathFactory;
    private final CompactManager compactManager;
    private final boolean forceCompact;
    private final List<DataFileMeta> newFiles;
    private final List<DataFileMeta> compactBefore;
    private final List<DataFileMeta> compactAfter;
    private final LongCounter seqNumCounter;
    private final String fileCompression;
    private final FieldStatsCollector.Factory[] statsCollectors;
    private RowDataRollingFileWriter writer;

    public AppendOnlyWriter(FileIO fileIO, long schemaId, FileFormat fileFormat, long targetFileSize, RowType writeSchema, long maxSequenceNumber, CompactManager compactManager, boolean forceCompact, DataFilePathFactory pathFactory, @Nullable CommitIncrement increment, String fileCompression, FieldStatsCollector.Factory[] statsCollectors) {
        this.fileIO = fileIO;
        this.schemaId = schemaId;
        this.fileFormat = fileFormat;
        this.targetFileSize = targetFileSize;
        this.writeSchema = writeSchema;
        this.pathFactory = pathFactory;
        this.compactManager = compactManager;
        this.forceCompact = forceCompact;
        this.newFiles = new ArrayList<DataFileMeta>();
        this.compactBefore = new ArrayList<DataFileMeta>();
        this.compactAfter = new ArrayList<DataFileMeta>();
        this.seqNumCounter = new LongCounter(maxSequenceNumber + 1L);
        this.fileCompression = fileCompression;
        this.statsCollectors = statsCollectors;
        this.writer = this.createRollingRowWriter();
        if (increment != null) {
            this.newFiles.addAll(increment.newFilesIncrement().newFiles());
            this.compactBefore.addAll(increment.compactIncrement().compactBefore());
            this.compactAfter.addAll(increment.compactIncrement().compactAfter());
        }
    }

    @Override
    public void write(InternalRow rowData) throws Exception {
        Preconditions.checkArgument((rowData.getRowKind() == RowKind.INSERT ? 1 : 0) != 0, (String)"Append-only writer can only accept insert row kind, but current row kind is: %s", (Object[])new Object[]{rowData.getRowKind()});
        this.writer.write(rowData);
    }

    @Override
    public void compact(boolean fullCompaction) throws Exception {
        this.flushWriter(true, fullCompaction);
    }

    @Override
    public void addNewFiles(List<DataFileMeta> files) {
        files.forEach(this.compactManager::addNewFile);
    }

    @Override
    public Collection<DataFileMeta> dataFiles() {
        return this.compactManager.allFiles();
    }

    @Override
    public CommitIncrement prepareCommit(boolean waitCompaction) throws Exception {
        this.flushWriter(false, false);
        this.trySyncLatestCompaction(waitCompaction || this.forceCompact);
        return this.drainIncrement();
    }

    private void flushWriter(boolean waitForLatestCompaction, boolean forcedFullCompaction) throws Exception {
        ArrayList flushedFiles = new ArrayList();
        if (this.writer != null) {
            this.writer.close();
            flushedFiles.addAll(this.writer.result());
            this.writer = this.createRollingRowWriter();
        }
        flushedFiles.forEach(this.compactManager::addNewFile);
        this.trySyncLatestCompaction(waitForLatestCompaction);
        this.compactManager.triggerCompaction(forcedFullCompaction);
        this.newFiles.addAll(flushedFiles);
    }

    @Override
    public void sync() throws Exception {
        this.trySyncLatestCompaction(true);
    }

    @Override
    public void close() throws Exception {
        this.compactManager.cancelCompaction();
        this.sync();
        if (this.writer != null) {
            this.writer.abort();
            this.writer = null;
        }
    }

    private RowDataRollingFileWriter createRollingRowWriter() {
        return new RowDataRollingFileWriter(this.fileIO, this.schemaId, this.fileFormat, this.targetFileSize, this.writeSchema, this.pathFactory, this.seqNumCounter, this.fileCompression, this.statsCollectors);
    }

    private void trySyncLatestCompaction(boolean blocking) throws ExecutionException, InterruptedException {
        this.compactManager.getCompactionResult(blocking).ifPresent(result -> {
            this.compactBefore.addAll(result.before());
            this.compactAfter.addAll(result.after());
        });
    }

    private CommitIncrement drainIncrement() {
        NewFilesIncrement newFilesIncrement = new NewFilesIncrement(new ArrayList<DataFileMeta>(this.newFiles), Collections.emptyList());
        CompactIncrement compactIncrement = new CompactIncrement(new ArrayList<DataFileMeta>(this.compactBefore), new ArrayList<DataFileMeta>(this.compactAfter), Collections.emptyList());
        this.newFiles.clear();
        this.compactBefore.clear();
        this.compactAfter.clear();
        return new CommitIncrement(newFilesIncrement, compactIncrement);
    }
}

