/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.predicate;

import java.util.List;
import org.apache.paimon.predicate.CompoundPredicate;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateVisitor;

public class PartitionPredicateVisitor
implements PredicateVisitor<Boolean> {
    private final List<String> partitionKeys;

    public PartitionPredicateVisitor(List<String> partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    @Override
    public Boolean visit(LeafPredicate predicate) {
        return this.partitionKeys.contains(predicate.fieldName());
    }

    @Override
    public Boolean visit(CompoundPredicate predicate) {
        for (Predicate child : predicate.children()) {
            Boolean matched = child.visit(this);
            if (matched.booleanValue()) continue;
            return false;
        }
        return true;
    }
}

