/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class VarLengthIntUtils {
    public static int encodeLong(DataOutput os, long value) throws IOException {
        if (value < 0L) {
            throw new IllegalArgumentException("negative value: v=" + value);
        }
        int i = 1;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            os.write((int)value & 0x7F | 0x80);
            value >>>= 7;
            ++i;
        }
        os.write((byte)value);
        return i;
    }

    public static int encodeLong(byte[] bytes, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("negative value: v=" + value);
        }
        int i = 1;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            bytes[i - 1] = (byte)((int)value & 0x7F | 0x80);
            value >>>= 7;
            ++i;
        }
        bytes[i - 1] = (byte)value;
        return i;
    }

    public static long decodeLong(DataInput is) throws IOException {
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            long b = is.readUnsignedByte();
            result |= (b & 0x7FL) << offset;
            if ((b & 0x80L) != 0L) continue;
            return result;
        }
        throw new Error("Malformed long.");
    }

    public static long decodeLong(byte[] ba, int index) {
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            long b = ba[index++];
            result |= (b & 0x7FL) << offset;
            if ((b & 0x80L) != 0L) continue;
            return result;
        }
        throw new Error("Malformed long.");
    }

    public static int encodeInt(byte[] bytes, int offset, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("negative value: v=" + value);
        }
        int i = 1;
        while ((value & 0xFFFFFF80) != 0) {
            bytes[i + offset - 1] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
            ++i;
        }
        bytes[i + offset - 1] = (byte)value;
        return i;
    }

    public static int encodeInt(DataOutput os, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException("negative value: v=" + value);
        }
        int i = 1;
        while ((value & 0xFFFFFF80) != 0) {
            os.write(value & 0x7F | 0x80);
            value >>>= 7;
            ++i;
        }
        os.write((byte)value);
        return i;
    }

    public static int decodeInt(DataInput is) throws IOException {
        int result = 0;
        for (int offset = 0; offset < 32; offset += 7) {
            int b = is.readUnsignedByte();
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new Error("Malformed integer.");
    }
}

