/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.ozone.erasurecode.rawcoder.ByteArrayDecodingState;
import org.apache.ozone.erasurecode.rawcoder.CoderUtil;
import org.apache.ozone.erasurecode.rawcoder.DecodingState;
import org.apache.ozone.erasurecode.rawcoder.RawErasureDecoder;

class ByteBufferDecodingState
extends DecodingState {
    ByteBuffer[] inputs;
    ByteBuffer[] outputs;
    int[] erasedIndexes;
    boolean usingDirectBuffer;

    ByteBufferDecodingState(RawErasureDecoder decoder, ByteBuffer[] inputs, int[] erasedIndexes, ByteBuffer[] outputs) {
        this.decoder = decoder;
        this.inputs = inputs;
        this.outputs = outputs;
        this.erasedIndexes = erasedIndexes;
        ByteBuffer validInput = CoderUtil.findFirstValidInput(inputs);
        this.decodeLength = validInput.remaining();
        this.usingDirectBuffer = validInput.isDirect();
        this.checkParameters(inputs, erasedIndexes, outputs);
        this.checkInputBuffers(inputs);
        this.checkOutputBuffers(outputs);
    }

    ByteBufferDecodingState(RawErasureDecoder decoder, int decodeLength, int[] erasedIndexes, ByteBuffer[] inputs, ByteBuffer[] outputs) {
        this.decoder = decoder;
        this.decodeLength = decodeLength;
        this.erasedIndexes = erasedIndexes;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    ByteArrayDecodingState convertToByteArrayState() {
        ByteBuffer buffer;
        int i;
        int[] inputOffsets = new int[this.inputs.length];
        int[] outputOffsets = new int[this.outputs.length];
        byte[][] newInputs = new byte[this.inputs.length][];
        byte[][] newOutputs = new byte[this.outputs.length][];
        for (i = 0; i < this.inputs.length; ++i) {
            buffer = this.inputs[i];
            if (buffer == null) continue;
            inputOffsets[i] = buffer.arrayOffset() + buffer.position();
            newInputs[i] = buffer.array();
        }
        for (i = 0; i < this.outputs.length; ++i) {
            buffer = this.outputs[i];
            outputOffsets[i] = buffer.arrayOffset() + buffer.position();
            newOutputs[i] = buffer.array();
        }
        ByteArrayDecodingState baeState = new ByteArrayDecodingState(this.decoder, this.decodeLength, this.erasedIndexes, newInputs, inputOffsets, newOutputs, outputOffsets);
        return baeState;
    }

    void checkInputBuffers(ByteBuffer[] buffers) {
        int validInputs = 0;
        for (int i = 0; i < buffers.length; ++i) {
            ByteBuffer buffer = buffers[i];
            if (buffer == null) continue;
            if (buffer.remaining() != this.decodeLength) {
                throw new IllegalArgumentException("Invalid buffer [" + i + "], not of length " + this.decodeLength);
            }
            if (buffer.isDirect() != this.usingDirectBuffer) {
                throw new IllegalArgumentException("Invalid buffer [" + i + "], isDirect should be " + this.usingDirectBuffer);
            }
            ++validInputs;
        }
        if (validInputs < this.decoder.getNumDataUnits()) {
            throw new IllegalArgumentException("No enough valid inputs are provided (" + validInputs + " vs. " + this.decoder.getNumDataUnits() + "), not recoverable");
        }
    }

    void checkOutputBuffers(ByteBuffer[] buffers) {
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) {
                throw new IllegalArgumentException("Invalid buffer found, not allowing null");
            }
            if (buffer.remaining() != this.decodeLength) {
                throw new IllegalArgumentException("Invalid buffer, not of length " + this.decodeLength);
            }
            if (buffer.isDirect() == this.usingDirectBuffer) continue;
            throw new IllegalArgumentException("Invalid buffer, isDirect should be " + this.usingDirectBuffer);
        }
    }
}

