/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.erasurecode.rawcoder.NativeRSRawErasureCoderFactory;
import org.apache.ozone.erasurecode.rawcoder.NativeXORRawErasureCoderFactory;
import org.apache.ozone.erasurecode.rawcoder.RawErasureCoderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class CodecRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CodecRegistry.class);
    private static CodecRegistry instance = new CodecRegistry();
    private Map<String, List<RawErasureCoderFactory>> coderMap = new HashMap<String, List<RawErasureCoderFactory>>();
    private Map<String, String[]> coderNameMap = new HashMap<String, String[]>();

    private CodecRegistry() {
        ServiceLoader<RawErasureCoderFactory> coderFactories = ServiceLoader.load(RawErasureCoderFactory.class);
        this.updateCoders(coderFactories);
    }

    public static CodecRegistry getInstance() {
        return instance;
    }

    @VisibleForTesting
    void updateCoders(Iterable<RawErasureCoderFactory> coderFactories) {
        List coders;
        String codecName;
        for (RawErasureCoderFactory rawErasureCoderFactory : coderFactories) {
            codecName = rawErasureCoderFactory.getCodecName();
            coders = this.coderMap.get(codecName);
            if (coders == null) {
                coders = new ArrayList<RawErasureCoderFactory>();
                coders.add((RawErasureCoderFactory)rawErasureCoderFactory);
                this.coderMap.put(codecName, coders);
                LOG.debug("Codec registered: codec = {}, coder = {}", (Object)rawErasureCoderFactory.getCodecName(), (Object)rawErasureCoderFactory.getCoderName());
                continue;
            }
            Boolean hasConflit = false;
            for (RawErasureCoderFactory coder : coders) {
                if (!coder.getCoderName().equals(rawErasureCoderFactory.getCoderName())) continue;
                hasConflit = true;
                LOG.error("Coder {} cannot be registered because its coder name {} has conflict with {}", new Object[]{rawErasureCoderFactory.getClass().getName(), rawErasureCoderFactory.getCoderName(), coder.getClass().getName()});
                break;
            }
            if (hasConflit.booleanValue()) continue;
            if (rawErasureCoderFactory instanceof NativeRSRawErasureCoderFactory || rawErasureCoderFactory instanceof NativeXORRawErasureCoderFactory) {
                coders.add(0, rawErasureCoderFactory);
            } else {
                coders.add(rawErasureCoderFactory);
            }
            LOG.debug("Codec registered: codec = {}, coder = {}", (Object)rawErasureCoderFactory.getCodecName(), (Object)rawErasureCoderFactory.getCoderName());
        }
        this.coderNameMap.clear();
        for (Map.Entry entry : this.coderMap.entrySet()) {
            codecName = (String)entry.getKey();
            coders = (List)entry.getValue();
            this.coderNameMap.put(codecName, coders.stream().map(RawErasureCoderFactory::getCoderName).collect(Collectors.toList()).toArray(new String[0]));
        }
    }

    public String[] getCoderNames(String codecName) {
        String[] coderNames = this.coderNameMap.get(codecName);
        return coderNames;
    }

    public List<RawErasureCoderFactory> getCoders(String codecName) {
        List<RawErasureCoderFactory> coders = this.coderMap.get(codecName);
        return coders;
    }

    public Set<String> getCodecNames() {
        return this.coderMap.keySet();
    }

    public RawErasureCoderFactory getCoderByName(String codecName, String coderName) {
        List<RawErasureCoderFactory> coders = this.getCoders(codecName);
        for (RawErasureCoderFactory coder : coders) {
            if (!coder.getCoderName().equals(coderName)) continue;
            return coder;
        }
        return null;
    }

    public RawErasureCoderFactory getCodecFactory(String codecName) {
        Iterator<RawErasureCoderFactory> iterator2 = this.getCoders(codecName).iterator();
        if (iterator2.hasNext()) {
            RawErasureCoderFactory factory2 = iterator2.next();
            return factory2;
        }
        throw new IllegalArgumentException("There is no registered codec factory for codec " + codecName);
    }
}

