/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.DefaultUpgradeFinalizationExecutor;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.UpgradeException;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizationExecutor;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.ratis.protocol.exceptions.NotLeaderException;

public abstract class BasicUpgradeFinalizer<T, V extends AbstractLayoutVersionManager>
implements UpgradeFinalizer<T> {
    private final V versionManager;
    private String clientID;
    private T component;
    private UpgradeFinalizationExecutor<T> finalizationExecutor;
    private final Lock finalizationLock;
    private final Queue<String> msgs = new ConcurrentLinkedQueue<String>();
    private boolean isDone = false;

    public BasicUpgradeFinalizer(V versionManager) {
        this(versionManager, new DefaultUpgradeFinalizationExecutor());
    }

    public BasicUpgradeFinalizer(V versionManager, UpgradeFinalizationExecutor<T> executor) {
        this.versionManager = versionManager;
        this.finalizationExecutor = executor;
        this.finalizationLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeFinalizer.StatusAndMessages finalize(String upgradeClientID, T service) throws IOException {
        if (BasicUpgradeFinalizer.isFinalized(((AbstractLayoutVersionManager)this.versionManager).getUpgradeState())) {
            return FINALIZED_MSG;
        }
        if (this.finalizationLock.tryLock()) {
            try {
                UpgradeFinalizer.StatusAndMessages response = this.initFinalize(upgradeClientID, service);
                if (response.status() == UpgradeFinalizer.Status.FINALIZATION_REQUIRED || response.status() == UpgradeFinalizer.Status.FINALIZATION_IN_PROGRESS) {
                    this.finalizationExecutor.execute(service, this);
                    UpgradeFinalizer.StatusAndMessages statusAndMessages = STARTING_MSG;
                    return statusAndMessages;
                }
                UpgradeFinalizer.StatusAndMessages statusAndMessages = response;
                return statusAndMessages;
            }
            catch (NotLeaderException e) {
                LOG.info("Leader change encountered during finalization. This component will continue finalization as directed by the new leader.", (Throwable)e);
                UpgradeFinalizer.StatusAndMessages statusAndMessages = FINALIZATION_IN_PROGRESS_MSG;
                return statusAndMessages;
            }
            finally {
                this.finalizationLock.unlock();
            }
        }
        return FINALIZATION_IN_PROGRESS_MSG;
    }

    @Override
    public synchronized UpgradeFinalizer.StatusAndMessages reportStatus(String upgradeClientID, boolean takeover) throws UpgradeException {
        if (takeover) {
            this.clientID = upgradeClientID;
        }
        this.assertClientId(upgradeClientID);
        ArrayList<String> returningMsgs = new ArrayList<String>(this.msgs.size() + 10);
        UpgradeFinalizer.Status status = ((AbstractLayoutVersionManager)this.versionManager).getUpgradeState();
        while (this.msgs.size() > 0) {
            returningMsgs.add(this.msgs.poll());
        }
        return new UpgradeFinalizer.StatusAndMessages(status, returningMsgs);
    }

    @Override
    public synchronized UpgradeFinalizer.Status getStatus() {
        return ((AbstractLayoutVersionManager)this.versionManager).getUpgradeState();
    }

    protected void preFinalizeUpgrade(T service) throws IOException {
        ((AbstractLayoutVersionManager)this.versionManager).setUpgradeState(UpgradeFinalizer.Status.FINALIZATION_IN_PROGRESS);
    }

    protected void postFinalizeUpgrade(T service) throws IOException {
        ((AbstractLayoutVersionManager)this.versionManager).setUpgradeState(UpgradeFinalizer.Status.FINALIZATION_DONE);
    }

    @Override
    public void finalizeAndWaitForCompletion(String upgradeClientID, T service, long maxTimeToWaitInSeconds) throws IOException {
        UpgradeFinalizer.StatusAndMessages response = this.finalize(upgradeClientID, service);
        LOG.info("Finalization Messages : {} ", response.msgs());
        if (BasicUpgradeFinalizer.isFinalized(response.status())) {
            return;
        }
        boolean success = false;
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxTimeToWaitInSeconds);
        while (System.currentTimeMillis() < endTime) {
            try {
                response = this.reportStatus(upgradeClientID, false);
                LOG.info("Finalization Messages : {} ", response.msgs());
                if (BasicUpgradeFinalizer.isFinalized(response.status())) {
                    success = true;
                    break;
                }
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Finalization Wait thread interrupted!");
            }
        }
        if (!success) {
            throw new IOException(String.format("Unable to finalize after waiting for %d seconds", maxTimeToWaitInSeconds));
        }
    }

    @VisibleForTesting
    public boolean isFinalizationDone() {
        return this.isDone;
    }

    @VisibleForTesting
    public void markFinalizationDone() {
        this.isDone = true;
    }

    public V getVersionManager() {
        return this.versionManager;
    }

    private synchronized UpgradeFinalizer.StatusAndMessages initFinalize(String upgradeClientID, T id) throws UpgradeException {
        switch (((AbstractLayoutVersionManager)this.versionManager).getUpgradeState()) {
            case STARTING_FINALIZATION: {
                return STARTING_MSG;
            }
            case FINALIZATION_IN_PROGRESS: {
                return FINALIZATION_IN_PROGRESS_MSG;
            }
            case FINALIZATION_DONE: 
            case ALREADY_FINALIZED: {
                if (((AbstractLayoutVersionManager)this.versionManager).needsFinalization()) {
                    throw new UpgradeException("Upgrade found in inconsistent state. Upgrade state is FINALIZATION Complete while MLV has not been upgraded to SLV.", UpgradeException.ResultCodes.INVALID_REQUEST);
                }
                return FINALIZED_MSG;
            }
        }
        if (!((AbstractLayoutVersionManager)this.versionManager).needsFinalization()) {
            throw new UpgradeException("Upgrade found in inconsistent state. Upgrade state is FINALIZATION_REQUIRED while MLV has been upgraded to SLV.", UpgradeException.ResultCodes.INVALID_REQUEST);
        }
        ((AbstractLayoutVersionManager)this.versionManager).setUpgradeState(UpgradeFinalizer.Status.STARTING_FINALIZATION);
        this.clientID = upgradeClientID;
        this.component = id;
        return FINALIZATION_REQUIRED_MSG;
    }

    private void assertClientId(String id) throws UpgradeException {
        if (this.clientID == null || !this.clientID.equals(id)) {
            throw new UpgradeException("Unknown client tries to get finalization status.\n The requestor is not the initiating client of the finalization, if you want to take over, and get unsent status messages, check -takeover option.", UpgradeException.ResultCodes.INVALID_REQUEST);
        }
    }

    private static boolean isFinalized(UpgradeFinalizer.Status status) {
        return status.equals((Object)UpgradeFinalizer.Status.ALREADY_FINALIZED) || status.equals((Object)UpgradeFinalizer.Status.FINALIZATION_DONE);
    }

    public abstract void finalizeLayoutFeature(LayoutFeature var1, T var2) throws UpgradeException;

    protected void finalizeLayoutFeature(LayoutFeature lf, Optional<? extends LayoutFeature.UpgradeAction> action, Storage storage) throws UpgradeException {
        this.runFinalizationAction(lf, action);
        this.updateLayoutVersionInVersionFile(lf, storage);
        ((AbstractLayoutVersionManager)this.versionManager).finalized((LayoutFeature)lf);
    }

    protected void runFinalizationAction(LayoutFeature feature, Optional<? extends LayoutFeature.UpgradeAction> action) throws UpgradeException {
        if (!action.isPresent()) {
            this.emitNOOPMsg(feature.name());
        } else {
            LOG.info("Running finalization actions for layout feature: {}", (Object)feature);
            try {
                action.get().execute(this.component);
            }
            catch (Exception e) {
                this.logFinalizationFailureAndThrow(e, feature.name());
            }
        }
    }

    @VisibleForTesting
    protected void runPrefinalizeStateActions(Function<LayoutFeature, Function<LayoutFeature.UpgradeActionType, Optional<? extends LayoutFeature.UpgradeAction>>> aFunction, Storage storage, T service) throws IOException {
        Optional<? extends LayoutFeature.UpgradeAction> action;
        Function<LayoutFeature.UpgradeActionType, Optional<? extends LayoutFeature.UpgradeAction>> function;
        LayoutFeature lf;
        if (!((AbstractLayoutVersionManager)this.versionManager).needsFinalization()) {
            return;
        }
        this.component = service;
        LOG.info("Running pre-finalized state validations for unfinalized layout features.");
        for (LayoutFeature obj : ((AbstractLayoutVersionManager)this.versionManager).unfinalizedFeatures()) {
            lf = obj;
            function = aFunction.apply(lf);
            action = function.apply(LayoutFeature.UpgradeActionType.VALIDATE_IN_PREFINALIZE);
            if (!action.isPresent()) continue;
            this.runValidationAction(lf, action.get());
        }
        LOG.info("Running first upgrade commands for unfinalized layout features.");
        for (LayoutFeature obj : ((AbstractLayoutVersionManager)this.versionManager).unfinalizedFeatures()) {
            lf = obj;
            function = aFunction.apply(lf);
            action = function.apply(LayoutFeature.UpgradeActionType.ON_FIRST_UPGRADE_START);
            if (!action.isPresent()) continue;
            this.runFirstUpgradeAction(lf, action.get(), storage);
        }
    }

    private void runValidationAction(LayoutFeature f, LayoutFeature.UpgradeAction action) throws UpgradeException {
        try {
            LOG.info("Executing pre finalize state validation {}", (Object)action.name());
            action.execute(this.component);
        }
        catch (Exception ex) {
            String msg = "Exception while running pre finalize state validation for feature %s";
            LOG.error(String.format(msg, f.name()));
            throw new UpgradeException(String.format(msg, f.name()), ex, UpgradeException.ResultCodes.PREFINALIZE_ACTION_VALIDATION_FAILED);
        }
    }

    private void runFirstUpgradeAction(LayoutFeature f, LayoutFeature.UpgradeAction action, Storage storage) throws IOException {
        try {
            int versionOnDisk = storage.getFirstUpgradeActionLayoutVersion();
            if (f.layoutVersion() > versionOnDisk) {
                LOG.info("Executing first upgrade start action {}", (Object)action.name());
                action.execute(this.component);
                storage.setFirstUpgradeActionLayoutVersion(f.layoutVersion());
                this.persistStorage(storage);
            } else {
                LOG.info("Skipping action {} since it has already been run.", (Object)action.name());
            }
        }
        catch (Exception ex) {
            String msg = "Exception while running first upgrade run actions for feature %s";
            LOG.error(String.format(msg, f.name()));
            throw new UpgradeException(String.format(msg, f.name()), ex, UpgradeException.ResultCodes.FIRST_UPGRADE_START_ACTION_FAILED);
        }
    }

    protected void updateLayoutVersionInVersionFile(LayoutFeature feature, Storage config) throws UpgradeException {
        int prevLayoutVersion = this.currentStoredLayoutVersion(config);
        this.updateStorageLayoutVersion(feature.layoutVersion(), config);
        try {
            this.persistStorage(config);
        }
        catch (IOException e) {
            this.updateStorageLayoutVersion(prevLayoutVersion, config);
            this.logLayoutVersionUpdateFailureAndThrow(e);
        }
    }

    private int currentStoredLayoutVersion(Storage config) {
        return config.getLayoutVersion();
    }

    private void updateStorageLayoutVersion(int version, Storage config) {
        config.setLayoutVersion(version);
    }

    private void persistStorage(Storage config) throws IOException {
        config.persistCurrentState();
    }

    protected void emitNOOPMsg(String feature) {
        String msg = "No onFinalize work defined for feature: " + feature + ".";
        this.logAndEmit(msg);
    }

    protected void emitStartingMsg() {
        String msg = "Finalization started.";
        this.logAndEmit(msg);
    }

    protected void emitFinishedMsg() {
        String msg = "Finalization is done.";
        this.logAndEmit(msg);
    }

    protected void logAndEmit(String msg) {
        LOG.info(msg);
        this.msgs.offer(msg);
    }

    protected void logFinalizationFailureAndThrow(Exception e, String feature) throws UpgradeException {
        String msg = "Error during finalization of " + feature + ".";
        this.logAndThrow(e, msg, UpgradeException.ResultCodes.LAYOUT_FEATURE_FINALIZATION_FAILED);
    }

    private void logLayoutVersionUpdateFailureAndThrow(IOException e) throws UpgradeException {
        String msg = "Updating the LayoutVersion in the VERSION file failed.";
        this.logAndThrow(e, msg, UpgradeException.ResultCodes.UPDATE_LAYOUT_VERSION_FAILED);
    }

    private void logAndThrow(Exception e, String msg, UpgradeException.ResultCodes resultCode) throws UpgradeException {
        LOG.error(msg, (Throwable)e);
        throw new UpgradeException(msg, e, resultCode);
    }

    @VisibleForTesting
    public void setFinalizationExecutor(DefaultUpgradeFinalizationExecutor<T> executor) {
        this.finalizationExecutor = executor;
    }
}

