/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Set;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.DERBitString;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.DERSet;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.pkcs.Attribute;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x500.X500Name;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.Extension;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.ContentSigner;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class PKCS10CertificationRequestBuilder {
    private SubjectPublicKeyInfo publicKeyInfo;
    private X500Name subject;
    private List attributes = new ArrayList();
    private boolean leaveOffEmpty = false;

    public PKCS10CertificationRequestBuilder(PKCS10CertificationRequestBuilder pKCS10CertificationRequestBuilder) {
        this.publicKeyInfo = pKCS10CertificationRequestBuilder.publicKeyInfo;
        this.subject = pKCS10CertificationRequestBuilder.subject;
        this.leaveOffEmpty = pKCS10CertificationRequestBuilder.leaveOffEmpty;
        this.attributes = new ArrayList(pKCS10CertificationRequestBuilder.attributes);
    }

    public PKCS10CertificationRequestBuilder(X500Name x500Name, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.subject = x500Name;
        this.publicKeyInfo = subjectPublicKeyInfo;
    }

    public PKCS10CertificationRequestBuilder setAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        Iterator iterator2 = this.attributes.iterator();
        while (iterator2.hasNext()) {
            if (!((Attribute)iterator2.next()).getAttrType().equals(aSN1ObjectIdentifier)) continue;
            throw new IllegalStateException("Attribute " + aSN1ObjectIdentifier.toString() + " is already set");
        }
        this.addAttribute(aSN1ObjectIdentifier, aSN1Encodable);
        return this;
    }

    public PKCS10CertificationRequestBuilder setAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable[] aSN1EncodableArray) {
        Iterator iterator2 = this.attributes.iterator();
        while (iterator2.hasNext()) {
            if (!((Attribute)iterator2.next()).getAttrType().equals(aSN1ObjectIdentifier)) continue;
            throw new IllegalStateException("Attribute " + aSN1ObjectIdentifier.toString() + " is already set");
        }
        this.addAttribute(aSN1ObjectIdentifier, aSN1EncodableArray);
        return this;
    }

    public PKCS10CertificationRequestBuilder addAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attributes.add(new Attribute(aSN1ObjectIdentifier, new DERSet(aSN1Encodable)));
        return this;
    }

    public PKCS10CertificationRequestBuilder addAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable[] aSN1EncodableArray) {
        this.attributes.add(new Attribute(aSN1ObjectIdentifier, new DERSet(aSN1EncodableArray)));
        return this;
    }

    public PKCS10CertificationRequestBuilder setLeaveOffEmptyAttributes(boolean bl) {
        this.leaveOffEmpty = bl;
        return this;
    }

    public PKCS10CertificationRequest build(ContentSigner contentSigner) {
        Object object;
        CertificationRequestInfo certificationRequestInfo;
        if (this.attributes.isEmpty()) {
            certificationRequestInfo = this.leaveOffEmpty ? new CertificationRequestInfo(this.subject, this.publicKeyInfo, null) : new CertificationRequestInfo(this.subject, this.publicKeyInfo, (ASN1Set)new DERSet());
        } else {
            object = new ASN1EncodableVector();
            Iterator iterator2 = this.attributes.iterator();
            while (iterator2.hasNext()) {
                ((ASN1EncodableVector)object).add(Attribute.getInstance(iterator2.next()));
            }
            certificationRequestInfo = new CertificationRequestInfo(this.subject, this.publicKeyInfo, (ASN1Set)new DERSet((ASN1EncodableVector)object));
        }
        try {
            object = contentSigner.getOutputStream();
            ((OutputStream)object).write(certificationRequestInfo.getEncoded("DER"));
            ((OutputStream)object).close();
            return new PKCS10CertificationRequest(new CertificationRequest(certificationRequestInfo, contentSigner.getAlgorithmIdentifier(), new DERBitString(contentSigner.getSignature())));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certification request signature");
        }
    }

    public PKCS10CertificationRequest build(ContentSigner contentSigner, SubjectPublicKeyInfo subjectPublicKeyInfo, ContentSigner contentSigner2) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Object object = this.attributes.iterator();
        while (object.hasNext()) {
            aSN1EncodableVector.add(Attribute.getInstance(object.next()));
        }
        aSN1EncodableVector.add(new Attribute(Extension.subjectAltPublicKeyInfo, new DERSet(subjectPublicKeyInfo)));
        aSN1EncodableVector.add(new Attribute(Extension.altSignatureAlgorithm, new DERSet(contentSigner2.getAlgorithmIdentifier())));
        CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(this.subject, this.publicKeyInfo, (ASN1Set)new DERSet(aSN1EncodableVector));
        try {
            object = contentSigner2.getOutputStream();
            ((OutputStream)object).write(certificationRequestInfo.getEncoded("DER"));
            ((OutputStream)object).close();
            aSN1EncodableVector.add(new Attribute(Extension.altSignatureValue, new DERSet(new DERBitString(contentSigner2.getSignature()))));
            certificationRequestInfo = new CertificationRequestInfo(this.subject, this.publicKeyInfo, (ASN1Set)new DERSet(aSN1EncodableVector));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certification request signature");
        }
        try {
            object = contentSigner.getOutputStream();
            ((OutputStream)object).write(certificationRequestInfo.getEncoded("DER"));
            ((OutputStream)object).close();
            return new PKCS10CertificationRequest(new CertificationRequest(certificationRequestInfo, contentSigner.getAlgorithmIdentifier(), new DERBitString(contentSigner.getSignature())));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certification request signature");
        }
    }
}

