/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.dvcs;

import java.io.OutputStream;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.DigestInfo;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.dvcs.DVCSException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.dvcs.MessageImprint;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.DigestCalculator;

public class MessageImprintBuilder {
    private final DigestCalculator digestCalculator;

    public MessageImprintBuilder(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public MessageImprint build(byte[] byArray) throws DVCSException {
        try {
            OutputStream outputStream2 = this.digestCalculator.getOutputStream();
            outputStream2.write(byArray);
            outputStream2.close();
            return new MessageImprint(new DigestInfo(this.digestCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
        }
        catch (Exception exception) {
            throw new DVCSException("unable to build MessageImprint: " + exception.getMessage(), exception);
        }
    }
}

