/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.cms;

import java.io.IOException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.cms.KEKIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSSecureReadable;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.KEKRecipient;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.KEKRecipientId;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.Recipient;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.RecipientInformation;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

