/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.cert.ocsp;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ocsp.CertStatus;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ocsp.RevokedInfo;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ocsp.SingleResponse;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.Extension;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.Extensions;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cert.ocsp.CertificateID;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cert.ocsp.CertificateStatus;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cert.ocsp.OCSPUtils;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cert.ocsp.RevokedStatus;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cert.ocsp.UnknownStatus;

public class SingleResp {
    private SingleResponse resp;
    private Extensions extensions;

    public SingleResp(SingleResponse singleResponse) {
        this.resp = singleResponse;
        this.extensions = singleResponse.getSingleExtensions();
    }

    public CertificateID getCertID() {
        return new CertificateID(this.resp.getCertID());
    }

    public CertificateStatus getCertStatus() {
        CertStatus certStatus = this.resp.getCertStatus();
        if (certStatus.getTagNo() == 0) {
            return null;
        }
        if (certStatus.getTagNo() == 1) {
            return new RevokedStatus(RevokedInfo.getInstance(certStatus.getStatus()));
        }
        return new UnknownStatus();
    }

    public Date getThisUpdate() {
        return OCSPUtils.extractDate(this.resp.getThisUpdate());
    }

    public Date getNextUpdate() {
        if (this.resp.getNextUpdate() == null) {
            return null;
        }
        return OCSPUtils.extractDate(this.resp.getNextUpdate());
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.extensions != null) {
            return this.extensions.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return OCSPUtils.getExtensionOIDs(this.extensions);
    }

    public Set getCriticalExtensionOIDs() {
        return OCSPUtils.getCriticalExtensionOIDs(this.extensions);
    }

    public Set getNonCriticalExtensionOIDs() {
        return OCSPUtils.getNonCriticalExtensionOIDs(this.extensions);
    }
}

