/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.apache.thrift.transport.sasl;

import java.nio.ByteBuffer;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.transport.TTransport;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.transport.TTransportException;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.transport.sasl.FrameHeaderReader;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.transport.sasl.FrameReader;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.utils.StringUtils;

public abstract class FixedSizeHeaderReader
implements FrameHeaderReader {
    protected final ByteBuffer byteBuffer = ByteBuffer.allocate(this.headerSize());

    @Override
    public boolean isComplete() {
        return !this.byteBuffer.hasRemaining();
    }

    @Override
    public void clear() {
        this.byteBuffer.clear();
    }

    @Override
    public byte[] toBytes() {
        if (!this.isComplete()) {
            throw new IllegalStateException("Header is not yet complete " + StringUtils.bytesToHexString(this.byteBuffer.array(), 0, this.byteBuffer.position()));
        }
        return this.byteBuffer.array();
    }

    @Override
    public boolean read(TTransport transport) throws TTransportException {
        FrameReader.readAvailable(transport, this.byteBuffer);
        if (this.byteBuffer.hasRemaining()) {
            return false;
        }
        this.onComplete();
        return true;
    }

    protected abstract int headerSize();

    protected abstract void onComplete() throws TTransportException;
}

