/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.apache.thrift.transport;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.transport.TSaslTransport;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.transport.TTransport;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.transport.TTransportException;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.transport.sasl.NegotiationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSaslClientTransport
extends TSaslTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSaslClientTransport.class);
    private final String mechanism;

    public TSaslClientTransport(SaslClient saslClient, TTransport transport) throws TTransportException {
        super(saslClient, transport);
        this.mechanism = saslClient.getMechanismName();
    }

    public TSaslClientTransport(String mechanism, String authorizationId, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh, TTransport transport) throws SaslException, TTransportException {
        super(Sasl.createSaslClient(new String[]{mechanism}, authorizationId, protocol, serverName, props, cbh), transport);
        this.mechanism = mechanism;
    }

    @Override
    protected TSaslTransport.SaslRole getRole() {
        return TSaslTransport.SaslRole.CLIENT;
    }

    @Override
    protected void handleSaslStartMessage() throws TTransportException, SaslException {
        SaslClient saslClient = this.getSaslClient();
        byte[] initialResponse = new byte[]{};
        if (saslClient.hasInitialResponse()) {
            initialResponse = saslClient.evaluateChallenge(initialResponse);
        }
        LOGGER.debug("Sending mechanism name {} and initial response of length {}", (Object)this.mechanism, (Object)initialResponse.length);
        byte[] mechanismBytes = this.mechanism.getBytes(StandardCharsets.UTF_8);
        this.sendSaslMessage(NegotiationStatus.START, mechanismBytes);
        this.sendSaslMessage(saslClient.isComplete() ? NegotiationStatus.COMPLETE : NegotiationStatus.OK, initialResponse);
        this.underlyingTransport.flush();
    }
}

