/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.samplers;

import java.io.IOException;
import java.net.URLEncoder;
import org.apache.hadoop.ozone.shaded.com.google.gson.Gson;
import org.apache.hadoop.ozone.shaded.com.google.gson.JsonSyntaxException;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.exceptions.SamplingStrategyErrorException;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.samplers.http.SamplingStrategyResponse;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.utils.Http;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.spi.SamplingManager;

public class HttpSamplingManager
implements SamplingManager {
    public static final String DEFAULT_HOST_PORT = "localhost:5778";
    private final String hostPort;
    private final Gson gson = new Gson();

    public HttpSamplingManager() {
        this(DEFAULT_HOST_PORT);
    }

    public HttpSamplingManager(String hostPort) {
        this.hostPort = hostPort != null ? hostPort : DEFAULT_HOST_PORT;
    }

    SamplingStrategyResponse parseJson(String json) {
        try {
            return this.gson.fromJson(json, SamplingStrategyResponse.class);
        }
        catch (JsonSyntaxException e) {
            throw new SamplingStrategyErrorException("Cannot deserialize json", e);
        }
    }

    @Override
    public SamplingStrategyResponse getSamplingStrategy(String serviceName) throws SamplingStrategyErrorException {
        String jsonString;
        try {
            jsonString = Http.makeGetRequest("http://" + this.hostPort + "/?service=" + URLEncoder.encode(serviceName, "UTF-8"));
        }
        catch (IOException e) {
            throw new SamplingStrategyErrorException("http call to get sampling strategy from local agent failed.", e);
        }
        return this.parseJson(jsonString);
    }

    public String toString() {
        return "HttpSamplingManager(hostPort=" + this.hostPort + ")";
    }
}

