/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;

@ConfigGroup(prefix="ozone.om")
public class OzoneAclConfig {
    @Config(key="user.rights", defaultValue="ALL", type=ConfigType.STRING, tags={ConfigTag.OM, ConfigTag.SECURITY}, description="Default user permissions set for an object in OzoneManager.")
    private String userDefaultRights;
    @Config(key="group.rights", defaultValue="READ, LIST", type=ConfigType.STRING, tags={ConfigTag.OM, ConfigTag.SECURITY}, description="Default group permissions set for an object in OzoneManager.")
    private String groupDefaultRights;

    public IAccessAuthorizer.ACLType[] getUserDefaultRights() {
        ArrayList<IAccessAuthorizer.ACLType> types = new ArrayList<IAccessAuthorizer.ACLType>();
        if (this.userDefaultRights == null) {
            types.add(IAccessAuthorizer.ACLType.ALL);
        } else {
            String[] array = this.userDefaultRights.trim().split(",");
            Arrays.stream(array).forEach(t2 -> types.add(IAccessAuthorizer.ACLType.valueOf(t2.trim())));
        }
        return types.toArray(new IAccessAuthorizer.ACLType[0]);
    }

    public IAccessAuthorizer.ACLType[] getGroupDefaultRights() {
        ArrayList<IAccessAuthorizer.ACLType> types = new ArrayList<IAccessAuthorizer.ACLType>();
        if (this.groupDefaultRights == null) {
            types.add(IAccessAuthorizer.ACLType.READ);
            types.add(IAccessAuthorizer.ACLType.LIST);
        } else {
            String[] array = this.groupDefaultRights.trim().split(",");
            Arrays.stream(array).forEach(t2 -> types.add(IAccessAuthorizer.ACLType.valueOf(t2.trim())));
        }
        return types.toArray(new IAccessAuthorizer.ACLType[0]);
    }
}

