/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.ha.HadoopRpcOMFailoverProxyProvider;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.ozone.om.protocol.OMInterServiceProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OMInterServiceProtocolPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerInterServiceProtocolProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMInterServiceProtocolClientSideImpl
implements OMInterServiceProtocol {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private static final Logger LOG = LoggerFactory.getLogger(OMInterServiceProtocolClientSideImpl.class);
    private final HadoopRpcOMFailoverProxyProvider omFailoverProxyProvider;
    private final OMInterServiceProtocolPB rpcProxy;

    public OMInterServiceProtocolClientSideImpl(ConfigurationSource conf, UserGroupInformation ugi, String omServiceId) throws IOException {
        RPC.setProtocolEngine((Configuration)OzoneConfiguration.of(conf), OMInterServiceProtocolPB.class, ProtobufRpcEngine.class);
        this.omFailoverProxyProvider = new HadoopRpcOMFailoverProxyProvider<OMInterServiceProtocolPB>(conf, ugi, omServiceId, OMInterServiceProtocolPB.class);
        int maxFailovers = conf.getInt("ozone.client.failover.max.attempts", 500);
        this.rpcProxy = (OMInterServiceProtocolPB)RetryProxy.create(OMInterServiceProtocolPB.class, (FailoverProxyProvider)this.omFailoverProxyProvider, (RetryPolicy)this.omFailoverProxyProvider.getRetryPolicy(maxFailovers));
    }

    @Override
    public void bootstrap(OMNodeDetails newOMNode) throws IOException {
        OzoneManagerInterServiceProtocolProtos.BootstrapOMResponse response;
        OzoneManagerInterServiceProtocolProtos.BootstrapOMRequest bootstrapOMRequest = OzoneManagerInterServiceProtocolProtos.BootstrapOMRequest.newBuilder().setNodeId(newOMNode.getNodeId()).setHostAddress(newOMNode.getHostAddress()).setRatisPort(newOMNode.getRatisPort()).build();
        try {
            response = this.rpcProxy.bootstrap(NULL_RPC_CONTROLLER, bootstrapOMRequest);
        }
        catch (ServiceException e) {
            OMLeaderNotReadyException leaderNotReadyException;
            OMNotLeaderException notLeaderException = HadoopRpcOMFailoverProxyProvider.getNotLeaderException((Exception)((Object)e));
            if (notLeaderException != null) {
                this.throwException(OzoneManagerInterServiceProtocolProtos.ErrorCode.LEADER_UNDETERMINED, notLeaderException.getMessage());
            }
            if ((leaderNotReadyException = HadoopRpcOMFailoverProxyProvider.getLeaderNotReadyException((Exception)((Object)e))) != null) {
                this.throwException(OzoneManagerInterServiceProtocolProtos.ErrorCode.LEADER_NOT_READY, leaderNotReadyException.getMessage());
            }
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (!response.getSuccess()) {
            this.throwException(response.getErrorCode(), response.getErrorMsg());
        }
    }

    private void throwException(OzoneManagerInterServiceProtocolProtos.ErrorCode errorCode, String errorMsg) throws IOException {
        throw new IOException("Failed to Bootstrap OM. Error Code: " + (Object)((Object)errorCode) + ", Error Message: " + errorMsg);
    }

    @Override
    public void close() throws IOException {
        this.omFailoverProxyProvider.close();
    }
}

