/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;

public abstract class WithMetadata {
    private Map<String, String> metadata;

    protected WithMetadata() {
        this.metadata = new ConcurrentHashMap<String, String>();
    }

    protected WithMetadata(Builder b) {
        this.metadata = b.metadata;
    }

    public final Map<String, String> getMetadata() {
        return this.metadata;
    }

    public final void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public static class Builder {
        private final Map<String, String> metadata;

        protected Builder() {
            this.metadata = new ConcurrentHashMap<String, String>();
        }

        protected Builder(WithObjectID obj) {
            this.metadata = new ConcurrentHashMap<String, String>(obj.getMetadata());
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> additionalMetadata) {
            if (additionalMetadata != null) {
                this.metadata.putAll(additionalMetadata);
            }
            return this;
        }

        public Builder setMetadata(Map<String, String> map) {
            this.metadata.clear();
            this.addAllMetadata(map);
            return this;
        }

        protected Map<String, String> getMetadata() {
            return this.metadata;
        }
    }
}

