/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.Objects;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.IdentityProvider;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ozone.shaded.io.netty.util.internal.StringUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneIdentityProvider
implements IdentityProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneIdentityProvider.class);

    public String makeIdentity(Schedulable schedulable) {
        UserGroupInformation ugi = schedulable.getUserGroupInformation();
        try {
            CallerContext callerContext = schedulable.getCallerContext();
            if (Objects.nonNull(callerContext) && !StringUtil.isNullOrEmpty(callerContext.getContext()) && callerContext.getContext().startsWith("S3Auth:S3G|")) {
                return callerContext.getContext().substring("S3Auth:S3G|".length());
            }
        }
        catch (UnsupportedOperationException ex) {
            LOG.error("Trying to access CallerContext from a Schedulable implementation that's not instance of Server.Call");
        }
        return ugi.getShortUserName() == null ? null : ugi.getShortUserName();
    }
}

