/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.grpc.metrics;

import com.google.protobuf.AbstractMessage;
import org.apache.hadoop.ozone.grpc.metrics.GrpcMetrics;
import org.apache.hadoop.ozone.shaded.io.grpc.ForwardingServerCallListener;
import org.apache.hadoop.ozone.shaded.io.grpc.Metadata;
import org.apache.hadoop.ozone.shaded.io.grpc.ServerCall;
import org.apache.hadoop.ozone.shaded.io.grpc.ServerCallHandler;
import org.apache.hadoop.ozone.shaded.io.grpc.ServerInterceptor;

public class GrpcMetricsServerRequestInterceptor
implements ServerInterceptor {
    private final GrpcMetrics grpcMetrics;
    private long receivedTime;
    private long startTime;
    private long endTime;

    public GrpcMetricsServerRequestInterceptor(GrpcMetrics grpcMetrics) {
        this.grpcMetrics = grpcMetrics;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata headers, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        this.receivedTime = System.nanoTime();
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(serverCallHandler.startCall(serverCall, headers)){

            @Override
            public void onMessage(ReqT message) {
                GrpcMetricsServerRequestInterceptor.this.startTime = System.nanoTime();
                long messageSize = 0L;
                if (message instanceof AbstractMessage) {
                    AbstractMessage parsedMessage = (AbstractMessage)message;
                    messageSize += (long)parsedMessage.getSerializedSize();
                } else {
                    GrpcMetricsServerRequestInterceptor.this.grpcMetrics.incrUnknownMessagesReceived();
                }
                GrpcMetricsServerRequestInterceptor.this.grpcMetrics.incrReceivedBytes(messageSize);
                String[] messageFields = message.toString().split(System.lineSeparator());
                String[] cmdTypeLine = messageFields[0].split(":");
                GrpcMetricsServerRequestInterceptor.this.grpcMetrics.setRequestType(cmdTypeLine[1].trim());
                super.onMessage(message);
            }

            @Override
            public void onComplete() {
                super.onComplete();
                GrpcMetricsServerRequestInterceptor.this.endTime = System.nanoTime();
                int queueTime = (int)(GrpcMetricsServerRequestInterceptor.this.startTime - GrpcMetricsServerRequestInterceptor.this.receivedTime);
                int processingTime = (int)(GrpcMetricsServerRequestInterceptor.this.endTime - GrpcMetricsServerRequestInterceptor.this.startTime);
                GrpcMetricsServerRequestInterceptor.this.grpcMetrics.addGrpcQueueTime(queueTime);
                GrpcMetricsServerRequestInterceptor.this.grpcMetrics.addGrpcProcessingTime(processingTime);
            }
        };
    }
}

