/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.UncheckedAutoCloseable;

final class ChunkBufferImplWithByteBuffer
implements ChunkBuffer {
    private final ByteBuffer buffer;
    private final UncheckedAutoCloseable underlying;
    private final UUID identity = UUID.randomUUID();

    ChunkBufferImplWithByteBuffer(ByteBuffer buffer) {
        this(buffer, null);
    }

    ChunkBufferImplWithByteBuffer(ByteBuffer buffer, UncheckedAutoCloseable underlying) {
        this.buffer = Objects.requireNonNull(buffer, "buffer == null");
        this.underlying = underlying;
    }

    @Override
    public void close() {
        if (this.underlying != null) {
            this.underlying.close();
        }
    }

    @Override
    public int position() {
        return this.buffer.position();
    }

    @Override
    public int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public int limit() {
        return this.buffer.limit();
    }

    @Override
    public ChunkBuffer rewind() {
        this.buffer.rewind();
        return this;
    }

    @Override
    public Iterable<ByteBuffer> iterate(final int bufferSize) {
        return () -> new Iterator<ByteBuffer>(){

            @Override
            public boolean hasNext() {
                return ChunkBufferImplWithByteBuffer.this.buffer.hasRemaining();
            }

            @Override
            public ByteBuffer next() {
                if (!ChunkBufferImplWithByteBuffer.this.buffer.hasRemaining()) {
                    throw new NoSuchElementException();
                }
                ByteBuffer duplicated = ChunkBufferImplWithByteBuffer.this.buffer.duplicate();
                int min2 = Math.min(ChunkBufferImplWithByteBuffer.this.buffer.position() + bufferSize, ChunkBufferImplWithByteBuffer.this.buffer.limit());
                duplicated.limit(min2);
                ChunkBufferImplWithByteBuffer.this.buffer.position(min2);
                return duplicated;
            }
        };
    }

    @Override
    public List<ByteBuffer> asByteBufferList() {
        return Collections.singletonList(this.buffer);
    }

    @Override
    public long writeTo(GatheringByteChannel channel) throws IOException {
        return channel.write(this.buffer);
    }

    @Override
    public ChunkBuffer duplicate(int newPosition, int newLimit) {
        ByteBuffer duplicated = this.buffer.duplicate();
        duplicated.position(newPosition).limit(newLimit);
        return new ChunkBufferImplWithByteBuffer(duplicated);
    }

    @Override
    public ChunkBuffer put(ByteBuffer b) {
        this.buffer.put(b);
        return this;
    }

    @Override
    public ChunkBuffer put(byte b) {
        this.buffer.put(b);
        return this;
    }

    @Override
    public ChunkBuffer clear() {
        this.buffer.clear();
        return this;
    }

    @Override
    public ByteString toByteStringImpl(Function<ByteBuffer, ByteString> f) {
        return f.apply(this.buffer);
    }

    @Override
    public List<ByteString> toByteStringListImpl(Function<ByteBuffer, ByteString> f) {
        return Collections.singletonList(f.apply(this.buffer));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChunkBufferImplWithByteBuffer)) {
            return false;
        }
        ChunkBufferImplWithByteBuffer that = (ChunkBufferImplWithByteBuffer)obj;
        return this.buffer.equals(that.buffer);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":limit=" + this.buffer.limit() + "@" + this.identity;
    }
}

