/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.ozone.client.io.ByteArrayStreamOutput;
import org.apache.hadoop.ozone.client.io.CipherOutputStreamOzone;
import org.apache.hadoop.ozone.client.io.KeyMetadataAware;
import org.apache.hadoop.ozone.client.io.KeyOutputStream;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;

public class OzoneOutputStream
extends ByteArrayStreamOutput
implements KeyMetadataAware {
    private final OutputStream outputStream;
    private final Syncable syncable;
    private boolean enableHsync;

    public OzoneOutputStream(Syncable outputStream2, boolean enableHsync) {
        this(Optional.of(Objects.requireNonNull(outputStream2, "outputStream == null")).filter(s2 -> s2 instanceof OutputStream).map(s2 -> (OutputStream)s2).orElseThrow(() -> new IllegalArgumentException("The parameter syncable is not an OutputStream")), outputStream2, enableHsync);
    }

    public OzoneOutputStream(OutputStream outputStream2, Syncable syncable) {
        this(outputStream2, syncable, false);
    }

    public OzoneOutputStream(OutputStream outputStream2, Syncable syncable, boolean enableHsync) {
        this.outputStream = Objects.requireNonNull(outputStream2, "outputStream == null");
        this.syncable = syncable != null ? syncable : (outputStream2 instanceof Syncable ? (Syncable)outputStream2 : null);
        this.enableHsync = enableHsync;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.outputStream.close();
    }

    public void hsync() throws IOException {
        if (!this.enableHsync) {
            this.outputStream.flush();
            return;
        }
        if (this.syncable != null) {
            if (this.outputStream != this.syncable) {
                this.outputStream.flush();
            }
        } else {
            throw new UnsupportedOperationException(this.outputStream.getClass() + " is not " + Syncable.class.getSimpleName());
        }
        this.syncable.hsync();
    }

    public OmMultipartCommitUploadPartInfo getCommitUploadPartInfo() {
        KeyOutputStream keyOutputStream = this.getKeyOutputStream();
        if (keyOutputStream != null) {
            return keyOutputStream.getCommitUploadPartInfo();
        }
        return null;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public KeyOutputStream getKeyOutputStream() {
        OutputStream wrappedStream;
        if (this.outputStream instanceof KeyOutputStream) {
            return (KeyOutputStream)this.outputStream;
        }
        if (this.outputStream instanceof CryptoOutputStream) {
            OutputStream wrappedStream2 = ((CryptoOutputStream)this.outputStream).getWrappedStream();
            if (wrappedStream2 instanceof KeyOutputStream) {
                return (KeyOutputStream)wrappedStream2;
            }
        } else if (this.outputStream instanceof CipherOutputStreamOzone && (wrappedStream = ((CipherOutputStreamOzone)this.outputStream).getWrappedStream()) instanceof KeyOutputStream) {
            return (KeyOutputStream)wrappedStream;
        }
        return null;
    }

    @Override
    public Map<String, String> getMetadata() {
        if (this.outputStream instanceof CryptoOutputStream) {
            return ((KeyMetadataAware)((Object)((CryptoOutputStream)this.outputStream).getWrappedStream())).getMetadata();
        }
        if (this.outputStream instanceof CipherOutputStreamOzone) {
            return ((KeyMetadataAware)((Object)((CipherOutputStreamOzone)this.outputStream).getWrappedStream())).getMetadata();
        }
        return ((KeyMetadataAware)((Object)this.outputStream)).getMetadata();
    }
}

