/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoStreamUtils;
import org.apache.hadoop.hdds.scm.storage.PartInputStream;
import org.apache.hadoop.ozone.client.io.LengthInputStream;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneCryptoInputStream
extends CryptoInputStream
implements PartInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneCryptoInputStream.class);
    private final long length;
    private final int bufferSize;
    private final String keyName;
    private final int partIndex;
    private int readPositionAdjustedBy = 0;
    private int readLengthAdjustedBy = 0;

    public OzoneCryptoInputStream(LengthInputStream in, CryptoCodec codec, byte[] key, byte[] iv, String keyName, int partIndex) throws IOException {
        super(in.getWrappedStream(), codec, key, iv);
        this.length = in.getLength();
        this.bufferSize = CryptoStreamUtils.getBufferSize((Configuration)codec.getConf());
        this.keyName = keyName;
        this.partIndex = partIndex;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int numBytesRead;
        int numBytesToRead = this.getNumBytesToRead(len, (int)this.getRemaining(), this.getBufferSize());
        if (this.readPositionAdjustedBy != 0 || this.readLengthAdjustedBy != 0) {
            byte[] tempBuffer = new byte[numBytesToRead];
            int actualNumBytesRead = super.read(tempBuffer, 0, numBytesToRead);
            numBytesRead = actualNumBytesRead - this.readPositionAdjustedBy - this.readLengthAdjustedBy;
            if (actualNumBytesRead != numBytesToRead) {
                throw new IOException(String.format("Inconsistent read for key=%s part=%d length=%d numBytesToRead(accounting for Crypto boundaries)=%d numBytesRead(actual)=%d numBytesToBeRead(into client buffer discarding crypto boundary adjustments)=%d", this.keyName, this.partIndex, this.getLength(), numBytesToRead, actualNumBytesRead, numBytesRead));
            }
            System.arraycopy(tempBuffer, this.readPositionAdjustedBy, b, off, numBytesRead);
            LOG.debug("OzoneCryptoInputStream for key: {} part: {} read {} bytes instead of {} bytes to account for Crypto buffer boundary. Client buffer will be copied with read data from position {}upto position {}, discarding the extra bytes read to maintain Crypto buffer boundary limits", new Object[]{this.keyName, this.partIndex, actualNumBytesRead, numBytesRead, this.readPositionAdjustedBy, actualNumBytesRead - this.readPositionAdjustedBy});
            if (this.readLengthAdjustedBy > 0) {
                this.seek(this.getPos() - (long)this.readLengthAdjustedBy);
            }
            this.readPositionAdjustedBy = 0;
            this.readLengthAdjustedBy = 0;
        } else {
            numBytesRead = super.read(b, off, numBytesToRead);
            if (numBytesRead != numBytesToRead) {
                throw new IOException(String.format("Inconsistent read for key=%s part=%d length=%d numBytesToRead=%d numBytesRead=%d", this.keyName, this.partIndex, this.getLength(), numBytesToRead, numBytesRead));
            }
        }
        return numBytesRead;
    }

    private int getNumBytesToRead(int lenToRead, int remaining, int cryptoBufferSize) throws IOException {
        Preconditions.checkArgument(this.readPositionAdjustedBy == 0);
        Preconditions.checkArgument(this.readLengthAdjustedBy == 0);
        this.adjustReadPosition(cryptoBufferSize);
        return this.adjustNumBytesToRead(lenToRead += this.readPositionAdjustedBy, remaining += this.readPositionAdjustedBy, cryptoBufferSize);
    }

    private void adjustReadPosition(long cryptoBufferSize) throws IOException {
        long currentPosOfStream = this.getPos();
        int modulus = (int)(currentPosOfStream % cryptoBufferSize);
        if (modulus != 0) {
            this.readPositionAdjustedBy = modulus;
            this.seek(currentPosOfStream - (long)this.readPositionAdjustedBy);
            LOG.debug("OzoneCryptoInputStream for key: {} part: {} adjusted position {} by -{} to account for Crypto buffer boundary", new Object[]{this.keyName, this.partIndex, currentPosOfStream, this.readPositionAdjustedBy});
        }
    }

    private int adjustNumBytesToRead(int lenToRead, int remaining, int cryptoBufferSize) {
        int numBytesToRead = Math.min(cryptoBufferSize, remaining);
        if (lenToRead < numBytesToRead) {
            this.readLengthAdjustedBy = numBytesToRead - lenToRead;
            LOG.debug("OzoneCryptoInputStream for key: {} part: {} adjusted length by +{} to account for Crypto buffer boundary", new Object[]{this.keyName, this.partIndex, this.readLengthAdjustedBy});
        }
        return numBytesToRead;
    }
}

