/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.checksum;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.checksum.AbstractBlockChecksumComputer;
import org.apache.hadoop.ozone.client.checksum.BaseFileChecksumHelper;
import org.apache.hadoop.ozone.client.checksum.CrcUtil;
import org.apache.hadoop.ozone.client.checksum.ECBlockChecksumComputer;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.security.token.Token;

public class ECFileChecksumHelper
extends BaseFileChecksumHelper {
    private int blockIdx;

    public ECFileChecksumHelper(OzoneVolume volume, OzoneBucket bucket, String keyName, long length, OzoneClientConfig.ChecksumCombineMode checksumCombineMode, ClientProtocol rpcClient, OmKeyInfo keyInfo) throws IOException {
        super(volume, bucket, keyName, length, checksumCombineMode, rpcClient, keyInfo);
    }

    @Override
    protected void checksumBlocks() throws IOException {
        long currentLength = 0L;
        this.blockIdx = 0;
        while (this.blockIdx < this.getKeyLocationInfoList().size() && this.getRemaining() >= 0L) {
            OmKeyLocationInfo keyLocationInfo = this.getKeyLocationInfoList().get(this.blockIdx);
            if (currentLength > this.getLength()) {
                return;
            }
            if (!this.checksumBlock(keyLocationInfo)) {
                throw new PathIOException(this.getSrc(), "Fail to get block checksum for " + keyLocationInfo + ", checksum combine mode: " + (Object)((Object)this.getCombineMode()));
            }
            currentLength += keyLocationInfo.getLength();
            ++this.blockIdx;
        }
    }

    private boolean checksumBlock(OmKeyLocationInfo keyLocationInfo) throws IOException {
        List<ContainerProtos.ChunkInfo> chunkInfos = this.getChunkInfos(keyLocationInfo);
        if (chunkInfos.size() == 0) {
            return false;
        }
        long blockNumBytes = keyLocationInfo.getLength();
        if (this.getRemaining() < blockNumBytes) {
            blockNumBytes = this.getRemaining();
        }
        this.setRemaining(this.getRemaining() - blockNumBytes);
        ContainerProtos.ChecksumData checksumData = chunkInfos.get(0).getChecksumData();
        this.setChecksumType(checksumData.getType());
        int bytesPerChecksum = checksumData.getBytesPerChecksum();
        this.setBytesPerCRC(bytesPerChecksum);
        ByteBuffer blockChecksumByteBuffer = this.getBlockChecksumFromChunkChecksums(chunkInfos, keyLocationInfo.getLength());
        String blockChecksumForDebug = this.populateBlockChecksumBuf(blockChecksumByteBuffer);
        LOG.debug("Got reply from EC pipeline {} for block {}: blockChecksum={}, blockChecksumType={}", new Object[]{keyLocationInfo.getPipeline(), keyLocationInfo.getBlockID(), blockChecksumForDebug, checksumData.getType()});
        return true;
    }

    private String populateBlockChecksumBuf(ByteBuffer blockChecksumByteBuffer) throws IOException {
        String blockChecksumForDebug = null;
        switch (this.getCombineMode()) {
            case MD5MD5CRC: {
                MD5Hash md5 = new MD5Hash(blockChecksumByteBuffer.array());
                md5.write((DataOutput)this.getBlockChecksumBuf());
                if (!LOG.isDebugEnabled()) break;
                blockChecksumForDebug = md5.toString();
                break;
            }
            case COMPOSITE_CRC: {
                byte[] crcBytes = blockChecksumByteBuffer.array();
                if (LOG.isDebugEnabled()) {
                    blockChecksumForDebug = CrcUtil.toSingleCrcString(crcBytes);
                }
                this.getBlockChecksumBuf().write(crcBytes);
                break;
            }
            default: {
                throw new IOException("Unknown combine mode: " + (Object)((Object)this.getCombineMode()));
            }
        }
        return blockChecksumForDebug;
    }

    private ByteBuffer getBlockChecksumFromChunkChecksums(List<ContainerProtos.ChunkInfo> chunkInfos, long blockLength) throws IOException {
        ECBlockChecksumComputer blockChecksumComputer = new ECBlockChecksumComputer(chunkInfos, this.getKeyInfo(), blockLength);
        ((AbstractBlockChecksumComputer)blockChecksumComputer).compute(this.getCombineMode());
        return blockChecksumComputer.getOutByteBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ContainerProtos.ChunkInfo> getChunkInfos(OmKeyLocationInfo keyLocationInfo) throws IOException {
        List<ContainerProtos.ChunkInfo> chunks;
        Token<OzoneBlockTokenIdentifier> token = keyLocationInfo.getToken();
        BlockID blockID = keyLocationInfo.getBlockID();
        Pipeline pipeline = keyLocationInfo.getPipeline();
        ArrayList<DatanodeDetails> nodes = new ArrayList<DatanodeDetails>();
        ECReplicationConfig repConfig = (ECReplicationConfig)pipeline.getReplicationConfig();
        for (DatanodeDetails dn : pipeline.getNodes()) {
            int replicaIndex = pipeline.getReplicaIndex(dn);
            if (replicaIndex != 1 && replicaIndex <= repConfig.getData()) continue;
            nodes.add(dn);
        }
        pipeline = Pipeline.newBuilder(pipeline).setReplicationConfig(StandaloneReplicationConfig.getInstance(HddsProtos.ReplicationFactor.THREE)).setNodes(nodes).build();
        XceiverClientSpi xceiverClientSpi = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initializing BlockInputStream for get key to access {}", (Object)blockID.getContainerID());
            }
            xceiverClientSpi = this.getXceiverClientFactory().acquireClientForReadData(pipeline);
            ContainerProtos.GetBlockResponseProto response = ContainerProtocolCalls.getBlock(xceiverClientSpi, blockID, token, pipeline.getReplicaIndexes());
            chunks = response.getBlockData().getChunksList();
        }
        finally {
            if (xceiverClientSpi != null) {
                this.getXceiverClientFactory().releaseClientForReadData(xceiverClientSpi, false);
            }
        }
        return chunks;
    }
}

