/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.checksum;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.checksum.CompositeCrcFileChecksum;
import org.apache.hadoop.ozone.client.checksum.CrcComposer;
import org.apache.hadoop.ozone.client.checksum.CrcUtil;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.client.rpc.RpcClient;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFileChecksumHelper {
    static final Logger LOG = LoggerFactory.getLogger(BaseFileChecksumHelper.class);
    private OmKeyInfo keyInfo;
    private OzoneVolume volume;
    private OzoneBucket bucket;
    private String keyName;
    private final long length;
    private ClientProtocol rpcClient;
    private OzoneClientConfig.ChecksumCombineMode combineMode;
    private ContainerProtos.ChecksumType checksumType;
    private final DataOutputBuffer blockChecksumBuf = new DataOutputBuffer();
    private XceiverClientFactory xceiverClientFactory;
    private FileChecksum fileChecksum;
    private List<OmKeyLocationInfo> keyLocationInfos;
    private long remaining = 0L;
    private int bytesPerCRC = -1;
    private long crcPerBlock = 0L;

    BaseFileChecksumHelper(OzoneVolume volume, OzoneBucket bucket, String keyName, long length, OzoneClientConfig.ChecksumCombineMode checksumCombineMode, ClientProtocol rpcClient) throws IOException {
        this.volume = volume;
        this.bucket = bucket;
        this.keyName = keyName;
        this.length = length;
        this.combineMode = checksumCombineMode;
        this.rpcClient = rpcClient;
        this.xceiverClientFactory = ((RpcClient)rpcClient).getXceiverClientManager();
        if (this.length > 0L) {
            this.fetchBlocks();
        }
    }

    public BaseFileChecksumHelper(OzoneVolume volume, OzoneBucket bucket, String keyName, long length, OzoneClientConfig.ChecksumCombineMode checksumCombineMode, ClientProtocol rpcClient, OmKeyInfo keyInfo) throws IOException {
        this(volume, bucket, keyName, length, checksumCombineMode, rpcClient);
        this.keyInfo = keyInfo;
    }

    protected String getSrc() {
        return "Volume: " + this.volume.getName() + " Bucket: " + this.bucket.getName() + " " + this.keyName;
    }

    protected long getLength() {
        return this.length;
    }

    protected ClientProtocol getRpcClient() {
        return this.rpcClient;
    }

    protected OzoneClientConfig.ChecksumCombineMode getCombineMode() {
        return this.combineMode;
    }

    protected ContainerProtos.ChecksumType getChecksumType() {
        return this.checksumType;
    }

    protected XceiverClientFactory getXceiverClientFactory() {
        return this.xceiverClientFactory;
    }

    protected DataOutputBuffer getBlockChecksumBuf() {
        return this.blockChecksumBuf;
    }

    protected List<OmKeyLocationInfo> getKeyLocationInfoList() {
        return this.keyLocationInfos;
    }

    protected long getRemaining() {
        return this.remaining;
    }

    protected void setRemaining(long remaining) {
        this.remaining = remaining;
    }

    protected OmKeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    int getBytesPerCRC() {
        return this.bytesPerCRC;
    }

    protected void setBytesPerCRC(int bytesPerCRC) {
        this.bytesPerCRC = bytesPerCRC;
    }

    protected void setChecksumType(ContainerProtos.ChecksumType type) {
        this.checksumType = type;
    }

    private void fetchBlocks() throws IOException {
        if (this.keyInfo == null) {
            OzoneManagerProtocol ozoneManagerClient = this.getRpcClient().getOzoneManagerClient();
            OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(this.volume.getName()).setBucketName(this.bucket.getName()).setKeyName(this.keyName).setSortDatanodesInPipeline(true).setLatestVersionLocation(true).build();
            this.keyInfo = ozoneManagerClient.lookupKey(keyArgs);
        }
        if (this.keyInfo.getFileChecksum() != null && this.isFullLength(this.keyInfo.getDataSize())) {
            this.fileChecksum = this.keyInfo.getFileChecksum();
        }
        this.keyLocationInfos = this.keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
    }

    private boolean isFullLength(long dataSize) {
        return this.length >= dataSize;
    }

    public void compute() throws IOException {
        if (this.fileChecksum != null) {
            LOG.debug("Checksum is available. Skip computing it.");
            return;
        }
        if (this.keyLocationInfos == null || this.keyLocationInfos.isEmpty()) {
            int lenOfZeroBytes = 32;
            byte[] emptyBlockMd5 = new byte[32];
            MD5Hash fileMD5 = MD5Hash.digest((byte[])emptyBlockMd5);
            this.fileChecksum = new MD5MD5CRC32GzipFileChecksum(0, 0L, fileMD5);
        } else {
            this.checksumBlocks();
            this.fileChecksum = this.makeFinalResult();
        }
    }

    protected abstract void checksumBlocks() throws IOException;

    private FileChecksum makeFinalResult() throws IOException {
        switch (this.getCombineMode()) {
            case MD5MD5CRC: {
                return this.makeMd5CrcResult();
            }
            case COMPOSITE_CRC: {
                return this.makeCompositeCrcResult();
            }
        }
        throw new IOException("Unknown ChecksumCombineMode: " + (Object)((Object)this.getCombineMode()));
    }

    private FileChecksum makeMd5CrcResult() {
        MD5Hash fileMD5 = MD5Hash.digest((byte[])this.getBlockChecksumBuf().getData());
        switch (this.getChecksumType()) {
            case CRC32: {
                return new MD5MD5CRC32GzipFileChecksum(this.getBytesPerCRC(), this.crcPerBlock, fileMD5);
            }
            case CRC32C: {
                return new MD5MD5CRC32CastagnoliFileChecksum(this.getBytesPerCRC(), this.crcPerBlock, fileMD5);
            }
        }
        throw new IllegalArgumentException("unexpected checksum type " + this.getChecksumType());
    }

    DataChecksum.Type toHadoopChecksumType() {
        switch (this.checksumType) {
            case CRC32: {
                return DataChecksum.Type.CRC32;
            }
            case CRC32C: {
                return DataChecksum.Type.CRC32C;
            }
        }
        throw new IllegalArgumentException("unsupported checksum type");
    }

    FileChecksum makeCompositeCrcResult() throws IOException {
        long blockSizeHint = 0L;
        if (this.keyLocationInfos.size() > 0) {
            blockSizeHint = this.keyLocationInfos.get(0).getLength();
        }
        CrcComposer crcComposer = CrcComposer.newCrcComposer(this.toHadoopChecksumType(), blockSizeHint);
        byte[] blockChecksumBytes = this.blockChecksumBuf.getData();
        for (int i = 0; i < this.keyLocationInfos.size(); ++i) {
            OmKeyLocationInfo block = this.keyLocationInfos.get(i);
            int blockCrc = CrcUtil.readInt(blockChecksumBytes, i * 4);
            crcComposer.update(blockCrc, block.getLength());
            LOG.debug("Added blockCrc 0x{} for block index {} of size {}", new Object[]{Integer.toString(blockCrc, 16), i, block.getLength()});
        }
        int compositeCrc = CrcUtil.readInt(crcComposer.digest(), 0);
        return new CompositeCrcFileChecksum(compositeCrc, this.toHadoopChecksumType(), this.bytesPerCRC);
    }

    public FileChecksum getFileChecksum() {
        return this.fileChecksum;
    }
}

