/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public final class TenantArgs {
    private final String volumeName;
    private final boolean forceCreationWhenVolumeExists;

    private TenantArgs(String volumeName, boolean forceCreationWhenVolumeExists) {
        this.volumeName = volumeName;
        this.forceCreationWhenVolumeExists = forceCreationWhenVolumeExists;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public boolean getForceCreationWhenVolumeExists() {
        return this.forceCreationWhenVolumeExists;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String volumeName;
        private boolean forceCreationWhenVolumeExists;

        public Builder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public Builder setForceCreationWhenVolumeExists(boolean forceCreationWhenVolumeExists) {
            this.forceCreationWhenVolumeExists = forceCreationWhenVolumeExists;
            return this;
        }

        public TenantArgs build() {
            Preconditions.checkNotNull(this.volumeName);
            return new TenantArgs(this.volumeName, this.forceCreationWhenVolumeExists);
        }
    }
}

