/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadList;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadPartListParts;
import org.apache.hadoop.ozone.client.io.OzoneDataStreamOutput;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BasicOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.ErrorInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatusLight;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.tuple.Pair;

public class OzoneBucket
extends WithMetadata {
    private final ClientProtocol proxy;
    private final String volumeName;
    private final String name;
    private ReplicationConfig defaultReplication;
    private StorageType storageType;
    private Boolean versioning;
    private int listCacheSize;
    private long usedBytes;
    private long usedNamespace;
    private Instant creationTime;
    private Instant modificationTime;
    private String encryptionKeyName;
    private OzoneObj ozoneObj;
    private String sourceVolume;
    private String sourceBucket;
    private boolean sourcePathExist = true;
    private long quotaInBytes;
    private long quotaInNamespace;
    private BucketLayout bucketLayout = BucketLayout.DEFAULT;
    private String owner;

    protected OzoneBucket(Builder builder) {
        super(builder);
        this.proxy = builder.proxy;
        this.volumeName = builder.volumeName;
        this.name = builder.name;
        this.defaultReplication = builder.defaultReplicationConfig != null ? builder.defaultReplicationConfig.getReplicationConfig() : null;
        this.storageType = builder.storageType;
        this.versioning = builder.versioning;
        if (builder.conf != null) {
            this.listCacheSize = HddsClientUtils.getListCacheSize(builder.conf);
        }
        this.usedBytes = builder.usedBytes;
        this.usedNamespace = builder.usedNamespace;
        this.creationTime = Instant.ofEpochMilli(builder.creationTime);
        if (builder.modificationTime != 0L) {
            this.modificationTime = Instant.ofEpochMilli(builder.modificationTime);
        } else {
            this.modificationTime = Instant.now();
            if (this.modificationTime.isBefore(this.creationTime)) {
                this.modificationTime = Instant.ofEpochSecond(this.creationTime.getEpochSecond(), this.creationTime.getNano());
            }
        }
        this.encryptionKeyName = builder.encryptionKeyName;
        this.ozoneObj = OzoneObjInfo.Builder.newBuilder().setBucketName(this.name).setVolumeName(this.volumeName).setResType(OzoneObj.ResourceType.BUCKET).setStoreType(OzoneObj.StoreType.OZONE).build();
        this.sourceVolume = builder.sourceVolume;
        this.sourceBucket = builder.sourceBucket;
        this.quotaInBytes = builder.quotaInBytes;
        this.quotaInNamespace = builder.quotaInNamespace;
        if (builder.bucketLayout != null) {
            this.bucketLayout = builder.bucketLayout;
        }
        this.owner = builder.owner;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public List<OzoneAcl> getAcls() throws IOException {
        return this.proxy.getAcl(this.ozoneObj);
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public Boolean getVersioning() {
        return this.versioning;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public String getEncryptionKeyName() {
        return this.encryptionKeyName;
    }

    public String getSourceVolume() {
        return this.sourceVolume;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public String getOwner() {
        return this.owner;
    }

    public int getListCacheSize() {
        return this.listCacheSize;
    }

    public boolean addAcl(OzoneAcl addAcl) throws IOException {
        return this.proxy.addAcl(this.ozoneObj, addAcl);
    }

    public boolean removeAcl(OzoneAcl removeAcl) throws IOException {
        return this.proxy.removeAcl(this.ozoneObj, removeAcl);
    }

    public boolean setAcl(List<OzoneAcl> acls) throws IOException {
        return this.proxy.setAcl(this.ozoneObj, acls);
    }

    public void setStorageType(StorageType newStorageType) throws IOException {
        this.proxy.setBucketStorageType(this.volumeName, this.name, newStorageType);
        this.storageType = newStorageType;
    }

    public void setVersioning(Boolean newVersioning) throws IOException {
        this.proxy.setBucketVersioning(this.volumeName, this.name, newVersioning);
        this.versioning = newVersioning;
    }

    public void clearSpaceQuota() throws IOException {
        OzoneBucket ozoneBucket = this.proxy.getBucketDetails(this.volumeName, this.name);
        this.proxy.setBucketQuota(this.volumeName, this.name, ozoneBucket.getQuotaInNamespace(), -1L);
        this.quotaInBytes = -1L;
        this.quotaInNamespace = ozoneBucket.getQuotaInNamespace();
    }

    public void clearNamespaceQuota() throws IOException {
        OzoneBucket ozoneBucket = this.proxy.getBucketDetails(this.volumeName, this.name);
        this.proxy.setBucketQuota(this.volumeName, this.name, -1L, ozoneBucket.getQuotaInBytes());
        this.quotaInBytes = ozoneBucket.getQuotaInBytes();
        this.quotaInNamespace = -1L;
    }

    public void setQuota(OzoneQuota quota) throws IOException {
        this.proxy.setBucketQuota(this.volumeName, this.name, quota.getQuotaInNamespace(), quota.getQuotaInBytes());
        this.quotaInBytes = quota.getQuotaInBytes();
        this.quotaInNamespace = quota.getQuotaInNamespace();
    }

    public void setReplicationConfig(ReplicationConfig replicationConfig) throws IOException {
        this.proxy.setReplicationConfig(this.volumeName, this.name, replicationConfig);
    }

    public void setListCacheSize(int listCacheSize) {
        this.listCacheSize = listCacheSize;
    }

    @Deprecated
    public void setEncryptionKey(String bekName) throws IOException {
        this.proxy.setEncryptionKey(this.volumeName, this.name, bekName);
        this.encryptionKeyName = bekName;
    }

    public OzoneOutputStream createKey(String key, long size) throws IOException {
        return this.createKey(key, size, this.defaultReplication, Collections.emptyMap());
    }

    @Deprecated
    public OzoneOutputStream createKey(String key, long size, ReplicationType type, ReplicationFactor factor, Map<String, String> keyMetadata) throws IOException {
        return this.proxy.createKey(this.volumeName, this.name, key, size, type, factor, keyMetadata);
    }

    public OzoneOutputStream createKey(String key, long size, ReplicationConfig replicationConfig, Map<String, String> keyMetadata) throws IOException {
        return this.createKey(key, size, replicationConfig, keyMetadata, Collections.emptyMap());
    }

    public OzoneOutputStream createKey(String key, long size, ReplicationConfig replicationConfig, Map<String, String> keyMetadata, Map<String, String> tags) throws IOException {
        return this.proxy.createKey(this.volumeName, this.name, key, size, replicationConfig, keyMetadata, tags);
    }

    public OzoneOutputStream rewriteKey(String keyName, long size, long existingKeyGeneration, ReplicationConfig replicationConfig, Map<String, String> metadata) throws IOException {
        return this.proxy.rewriteKey(this.volumeName, this.name, keyName, size, existingKeyGeneration, replicationConfig, metadata);
    }

    public OzoneDataStreamOutput createStreamKey(String key, long size) throws IOException {
        return this.createStreamKey(key, size, this.defaultReplication, Collections.emptyMap());
    }

    public OzoneDataStreamOutput createStreamKey(String key, long size, ReplicationConfig replicationConfig, Map<String, String> keyMetadata) throws IOException {
        if (replicationConfig == null) {
            replicationConfig = this.defaultReplication;
        }
        return this.createStreamKey(key, size, replicationConfig, keyMetadata, Collections.emptyMap());
    }

    public OzoneDataStreamOutput createStreamKey(String key, long size, ReplicationConfig replicationConfig, Map<String, String> keyMetadata, Map<String, String> tags) throws IOException {
        if (replicationConfig == null) {
            replicationConfig = this.defaultReplication;
        }
        return this.proxy.createStreamKey(this.volumeName, this.name, key, size, replicationConfig, keyMetadata, tags);
    }

    public OzoneInputStream readKey(String key) throws IOException {
        return this.proxy.getKey(this.volumeName, this.name, key);
    }

    public OzoneKeyDetails getKey(String key) throws IOException {
        return this.proxy.getKeyDetails(this.volumeName, this.name, key);
    }

    public OzoneKey headObject(String key) throws IOException {
        return this.proxy.headObject(this.volumeName, this.name, key);
    }

    public long getUsedBytes() {
        return this.usedBytes;
    }

    public long getUsedNamespace() {
        return this.usedNamespace;
    }

    public Iterator<? extends OzoneKey> listKeys(String keyPrefix) throws IOException {
        return this.listKeys(keyPrefix, null);
    }

    public Iterator<? extends OzoneKey> listKeys(String keyPrefix, String prevKey) throws IOException {
        return this.listKeys(keyPrefix, prevKey, false);
    }

    public Iterator<? extends OzoneKey> listKeys(String keyPrefix, String prevKey, boolean shallow) throws IOException {
        return new KeyIteratorFactory().getKeyIterator(keyPrefix, prevKey, this.bucketLayout, shallow);
    }

    public boolean isLink() {
        return this.sourceVolume != null && this.sourceBucket != null;
    }

    public void deleteKey(String key) throws IOException {
        this.proxy.deleteKey(this.volumeName, this.name, key, false);
    }

    public void deleteDirectory(String key, boolean recursive) throws IOException {
        this.proxy.deleteKey(this.volumeName, this.name, key, recursive);
    }

    public void deleteKeys(List<String> keyList) throws IOException {
        this.proxy.deleteKeys(this.volumeName, this.name, keyList);
    }

    public Map<String, ErrorInfo> deleteKeys(List<String> keyList, boolean quiet) throws IOException {
        return this.proxy.deleteKeys(this.volumeName, this.name, keyList, quiet);
    }

    public void renameKey(String fromKeyName, String toKeyName) throws IOException {
        this.proxy.renameKey(this.volumeName, this.name, fromKeyName, toKeyName);
    }

    @Deprecated
    public void renameKeys(Map<String, String> keyMap) throws IOException {
        this.proxy.renameKeys(this.volumeName, this.name, keyMap);
    }

    @Deprecated
    public OmMultipartInfo initiateMultipartUpload(String keyName, ReplicationType type, ReplicationFactor factor) throws IOException {
        return this.proxy.initiateMultipartUpload(this.volumeName, this.name, keyName, type, factor);
    }

    public OmMultipartInfo initiateMultipartUpload(String keyName, ReplicationConfig config) throws IOException {
        return this.initiateMultipartUpload(keyName, config, Collections.emptyMap());
    }

    public OmMultipartInfo initiateMultipartUpload(String keyName, ReplicationConfig config, Map<String, String> metadata) throws IOException {
        return this.initiateMultipartUpload(keyName, config, metadata, Collections.emptyMap());
    }

    public OmMultipartInfo initiateMultipartUpload(String keyName, ReplicationConfig config, Map<String, String> metadata, Map<String, String> tags) throws IOException {
        return this.proxy.initiateMultipartUpload(this.volumeName, this.name, keyName, config, metadata, tags);
    }

    public OmMultipartInfo initiateMultipartUpload(String key) throws IOException {
        return this.initiateMultipartUpload(key, this.defaultReplication);
    }

    public OzoneOutputStream createMultipartKey(String key, long size, int partNumber, String uploadID) throws IOException {
        return this.proxy.createMultipartKey(this.volumeName, this.name, key, size, partNumber, uploadID);
    }

    public OzoneDataStreamOutput createMultipartStreamKey(String key, long size, int partNumber, String uploadID) throws IOException {
        return this.proxy.createMultipartStreamKey(this.volumeName, this.name, key, size, partNumber, uploadID);
    }

    public OmMultipartUploadCompleteInfo completeMultipartUpload(String key, String uploadID, Map<Integer, String> partsMap) throws IOException {
        return this.proxy.completeMultipartUpload(this.volumeName, this.name, key, uploadID, partsMap);
    }

    public void abortMultipartUpload(String keyName, String uploadID) throws IOException {
        this.proxy.abortMultipartUpload(this.volumeName, this.name, keyName, uploadID);
    }

    public OzoneMultipartUploadPartListParts listParts(String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        return this.proxy.listParts(this.volumeName, this.name, keyName, uploadID, partNumberMarker, maxParts);
    }

    public OzoneFileStatus getFileStatus(String keyName) throws IOException {
        return this.proxy.getOzoneFileStatus(this.volumeName, this.name, keyName);
    }

    public void createDirectory(String keyName) throws IOException {
        this.proxy.createDirectory(this.volumeName, this.name, keyName);
    }

    public OzoneInputStream readFile(String keyName) throws IOException {
        return this.proxy.readFile(this.volumeName, this.name, keyName);
    }

    @Deprecated
    public OzoneOutputStream createFile(String keyName, long size, ReplicationType type, ReplicationFactor factor, boolean overWrite, boolean recursive) throws IOException {
        return this.proxy.createFile(this.volumeName, this.name, keyName, size, type, factor, overWrite, recursive);
    }

    public OzoneOutputStream createFile(String keyName, long size, ReplicationConfig replicationConfig, boolean overWrite, boolean recursive) throws IOException {
        return this.proxy.createFile(this.volumeName, this.name, keyName, size, replicationConfig, overWrite, recursive);
    }

    public OzoneDataStreamOutput createStreamFile(String keyName, long size, ReplicationConfig replicationConfig, boolean overWrite, boolean recursive) throws IOException {
        return this.proxy.createStreamFile(this.volumeName, this.name, keyName, size, replicationConfig, overWrite, recursive);
    }

    public List<OzoneFileStatus> listStatus(String keyName, boolean recursive, String startKey, long numEntries) throws IOException {
        return this.proxy.listStatus(this.volumeName, this.name, keyName, recursive, startKey, numEntries);
    }

    public List<OzoneFileStatusLight> listStatusLight(String keyName, boolean recursive, String startKey, long numEntries) throws IOException {
        return this.proxy.listStatusLight(this.volumeName, this.name, keyName, recursive, startKey, numEntries, false);
    }

    public List<OzoneFileStatus> listStatus(String keyName, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefix) throws IOException {
        return this.proxy.listStatus(this.volumeName, this.name, keyName, recursive, startKey, numEntries, allowPartialPrefix);
    }

    public OzoneMultipartUploadList listMultipartUploads(String prefix) throws IOException {
        return this.proxy.listMultipartUploads(this.volumeName, this.getName(), prefix);
    }

    public boolean setOwner(String userName) throws IOException {
        boolean result = this.proxy.setBucketOwner(this.volumeName, this.name, userName);
        this.owner = userName;
        return result;
    }

    public void setTimes(String keyName, long mtime, long atime) throws IOException {
        this.proxy.setTimes(this.ozoneObj, keyName, mtime, atime);
    }

    public void setSourcePathExist(boolean b) {
        this.sourcePathExist = b;
    }

    public boolean isSourcePathExist() {
        return this.sourcePathExist;
    }

    public static Builder newBuilder(ConfigurationSource conf, ClientProtocol proxy) {
        Preconditions.checkNotNull(proxy, "Client proxy is not set.");
        return new Builder(conf, proxy);
    }

    private static OzoneKey toOzoneKey(OzoneFileStatusLight status) {
        Map<String, String> metadata;
        BasicOmKeyInfo keyInfo = status.getKeyInfo();
        String keyName = keyInfo.getKeyName();
        if (status.isDirectory()) {
            keyName = OzoneFSUtils.addTrailingSlashIfNeeded(keyName);
            metadata = Collections.emptyMap();
        } else {
            metadata = Collections.singletonMap("ETag", keyInfo.getETag());
        }
        return new OzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyName, keyInfo.getDataSize(), keyInfo.getCreationTime(), keyInfo.getModificationTime(), keyInfo.getReplicationConfig(), metadata, keyInfo.isFile(), keyInfo.getOwnerName(), Collections.emptyMap());
    }

    public BucketLayout getBucketLayout() {
        return this.bucketLayout;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.defaultReplication;
    }

    private class KeyIteratorFactory {
        private KeyIteratorFactory() {
        }

        KeyIterator getKeyIterator(String keyPrefix, String prevKey, BucketLayout bType, boolean shallow) throws IOException {
            if (bType.isFileSystemOptimized()) {
                return new KeyIteratorWithFSO(keyPrefix, prevKey, shallow);
            }
            return new KeyIterator(keyPrefix, prevKey, shallow);
        }
    }

    private class KeyIteratorWithFSO
    extends KeyIterator {
        private Stack<Pair<String, String>> stack;
        private String removeStartKey;

        KeyIteratorWithFSO(String keyPrefix, String prevKey, boolean shallow) throws IOException {
            super(keyPrefix, prevKey, shallow);
            this.removeStartKey = "";
        }

        private void getSeekPathsBetweenKeyPrefixAndStartKey(String keyPrefix, String startKey, List<Pair<String, String>> seekPaths) {
            String parentStartKeyPath = OzoneFSUtils.getParentDir(startKey);
            if (StringUtils.isNotBlank(startKey)) {
                if (StringUtils.compare(parentStartKeyPath, keyPrefix) >= 0) {
                    seekPaths.add(new ImmutablePair<String, String>(parentStartKeyPath, startKey));
                    this.getSeekPathsBetweenKeyPrefixAndStartKey(keyPrefix, parentStartKeyPath, seekPaths);
                } else if (StringUtils.compare(startKey, keyPrefix) >= 0) {
                    seekPaths.add(new ImmutablePair<String, String>(keyPrefix, startKey));
                }
            }
        }

        @Override
        List<OzoneKey> getNextListOfKeys(String prevKey) throws IOException {
            Pair<String, String> keyPrefixPath;
            if (this.stack == null) {
                this.stack = new Stack();
            }
            if (this.shallow()) {
                return this.getNextShallowListOfKeys(prevKey);
            }
            if (!this.addedKeyPrefix() && !this.prepareStack(prevKey)) {
                return new ArrayList<OzoneKey>();
            }
            ArrayList<OzoneKey> keysResultList = new ArrayList<OzoneKey>();
            if (this.stack.isEmpty() && this.getChildrenKeys(this.getKeyPrefix(), prevKey, keysResultList)) {
                return keysResultList;
            }
            while (!this.stack.isEmpty() && !this.getChildrenKeys((keyPrefixPath = this.stack.pop()).getLeft(), keyPrefixPath.getRight(), keysResultList)) {
            }
            return keysResultList;
        }

        @Override
        List<OzoneKey> getNextShallowListOfKeys(String prevKey) throws IOException {
            List<OzoneFileStatusLight> statuses;
            ArrayList<OzoneKey> resultList = new ArrayList<OzoneKey>();
            String startKey = prevKey;
            boolean findFirstStartKey = false;
            if (!this.addedKeyPrefix()) {
                this.initDelimiterKeyPrefix();
                if (!this.prepareStack(prevKey)) {
                    return new ArrayList<OzoneKey>();
                }
                ArrayList<OzoneKey> firstKeyResult = new ArrayList<OzoneKey>();
                if (this.stack.isEmpty()) {
                    this.getChildrenKeys(this.getKeyPrefix(), prevKey, firstKeyResult);
                } else {
                    while (!this.stack.isEmpty()) {
                        Pair<String, String> keyPrefixPath = this.stack.pop();
                        this.getChildrenKeys(keyPrefixPath.getLeft(), keyPrefixPath.getRight(), firstKeyResult);
                        if (firstKeyResult.isEmpty()) continue;
                        break;
                    }
                }
                if (!firstKeyResult.isEmpty()) {
                    startKey = ((OzoneKey)firstKeyResult.get(0)).getName();
                    findFirstStartKey = true;
                }
                if (!(findFirstStartKey || !StringUtils.isBlank(prevKey) && this.keyPrefixExist() && StringUtils.startsWith(prevKey, this.getKeyPrefix()))) {
                    return new ArrayList<OzoneKey>();
                }
                if (this.getKeyPrefix().equals(startKey) && findFirstStartKey && !((OzoneKey)firstKeyResult.get(0)).isFile()) {
                    resultList.add((OzoneKey)firstKeyResult.get(0));
                }
                String string = startKey = (startKey = this.adjustStartKey(startKey)) == null ? "" : startKey;
            }
            if (!(statuses = OzoneBucket.this.proxy.listStatusLight(OzoneBucket.this.volumeName, OzoneBucket.this.name, this.getDelimiterKeyPrefix(), false, startKey, OzoneBucket.this.listCacheSize, false)).isEmpty()) {
                if (!findFirstStartKey && this.addedKeyPrefix()) {
                    statuses.remove(0);
                }
                List<OzoneKey> ozoneKeys = this.buildKeysWithKeyPrefix(statuses);
                resultList.addAll(ozoneKeys);
            }
            return resultList;
        }

        private boolean prepareStack(String prevKey) throws IOException {
            prevKey = OmUtils.normalizeKey(prevKey, true);
            String keyPrefixName = "";
            if (StringUtils.isNotBlank(this.getKeyPrefix())) {
                keyPrefixName = OmUtils.normalizeKey(this.getKeyPrefix(), true);
            }
            this.setKeyPrefix(keyPrefixName);
            if (StringUtils.isNotBlank(prevKey)) {
                if (StringUtils.startsWith(prevKey, this.getKeyPrefix())) {
                    ArrayList<Pair<String, String>> seekPaths = new ArrayList<Pair<String, String>>();
                    if (StringUtils.isNotBlank(this.getKeyPrefix())) {
                        this.addPrevDirectoryToSeekPath(prevKey, seekPaths);
                    }
                    this.removeStartKey = prevKey;
                    this.getSeekPathsBetweenKeyPrefixAndStartKey(this.getKeyPrefix(), prevKey, seekPaths);
                    for (int index = seekPaths.size() - 1; index >= 0; --index) {
                        Pair seekDirPath = (Pair)seekPaths.get(index);
                        this.stack.push(seekDirPath);
                    }
                } else if (StringUtils.isNotBlank(this.getKeyPrefix())) {
                    if (!OzoneFSUtils.isAncestorPath(this.getKeyPrefix(), prevKey)) {
                        return false;
                    }
                    if (StringUtils.compare(prevKey, this.getKeyPrefix()) < 0) {
                        this.stack.push(new ImmutablePair<String, String>(this.getKeyPrefix(), ""));
                    }
                }
            }
            return true;
        }

        private String adjustStartKey(String startKey) {
            if (this.getKeyPrefix().endsWith("/") && this.getKeyPrefix().equals(startKey)) {
                return "";
            }
            return OzoneFSUtils.getImmediateChild(startKey, this.getDelimiterKeyPrefix());
        }

        private boolean keyPrefixExist() throws IOException {
            OzoneFileStatus keyPrefixStatus = null;
            try {
                keyPrefixStatus = OzoneBucket.this.proxy.getOzoneFileStatus(OzoneBucket.this.volumeName, OzoneBucket.this.name, this.getKeyPrefix());
            }
            catch (OMException oMException) {
                // empty catch block
            }
            return keyPrefixStatus != null;
        }

        private void addPrevDirectoryToSeekPath(String prevKey, List<Pair<String, String>> seekPaths) throws IOException {
            try {
                OzoneFileStatus prevStatus = OzoneBucket.this.proxy.getOzoneFileStatus(OzoneBucket.this.volumeName, OzoneBucket.this.name, prevKey);
                if (prevStatus != null && prevStatus.isDirectory()) {
                    seekPaths.add(new ImmutablePair<String, String>(prevKey, ""));
                }
            }
            catch (OMException oMException) {
                // empty catch block
            }
        }

        private boolean getChildrenKeys(String keyPrefix, String startKey, List<OzoneKey> keysResultList) throws IOException {
            startKey = startKey == null ? "" : startKey;
            List<OzoneFileStatusLight> statuses = OzoneBucket.this.proxy.listStatusLight(OzoneBucket.this.volumeName, OzoneBucket.this.name, keyPrefix, false, startKey, OzoneBucket.this.listCacheSize, true);
            boolean reachedLimitCacheSize = statuses.size() == OzoneBucket.this.listCacheSize;
            this.addKeyPrefixInfoToResultList(keyPrefix, startKey, keysResultList);
            this.removeStartKeyIfExistsInStatusList(startKey, statuses);
            for (int indx = 0; indx < statuses.size(); ++indx) {
                OzoneFileStatusLight status = statuses.get(indx);
                BasicOmKeyInfo keyInfo = status.getKeyInfo();
                OzoneKey ozoneKey = OzoneBucket.toOzoneKey(status);
                keysResultList.add(ozoneKey);
                if (status.isDirectory()) {
                    this.stack.push(new ImmutablePair<String, String>(keyPrefix, keyInfo.getKeyName()));
                    this.stack.push(new ImmutablePair<String, String>(keyInfo.getKeyName(), ""));
                    return true;
                }
                if (!reachedLimitCacheSize || indx != statuses.size() - 1) continue;
                this.stack.push(new ImmutablePair<String, String>(keyPrefix, keyInfo.getKeyName()));
                return true;
            }
            return false;
        }

        private void removeStartKeyIfExistsInStatusList(String startKey, List<OzoneFileStatusLight> statuses) {
            if (!statuses.isEmpty()) {
                String firstElement = statuses.get(0).getKeyInfo().getKeyName();
                String startKeyPath = startKey;
                if (StringUtils.isNotBlank(startKey) && startKey.endsWith("/")) {
                    startKeyPath = OzoneFSUtils.removeTrailingSlashIfNeeded(startKey);
                }
                if (StringUtils.equals(firstElement, startKeyPath) || StringUtils.equals(firstElement, this.removeStartKey)) {
                    statuses.remove(0);
                }
            }
        }

        private void addKeyPrefixInfoToResultList(String keyPrefix, String startKey, List<OzoneKey> keysResultList) throws IOException {
            OzoneFileStatus status;
            block7: {
                if (this.addedKeyPrefix()) {
                    return;
                }
                this.setAddedKeyPrefix(true);
                if (StringUtils.isBlank(keyPrefix) || StringUtils.isNotBlank(startKey) || OmUtils.isBucketSnapshotIndicator(keyPrefix)) {
                    return;
                }
                status = null;
                try {
                    status = OzoneBucket.this.proxy.getOzoneFileStatus(OzoneBucket.this.volumeName, OzoneBucket.this.name, keyPrefix);
                }
                catch (OMException ome) {
                    if (ome.getResult() != OMException.ResultCodes.FILE_NOT_FOUND) break block7;
                    return;
                }
            }
            if (status != null) {
                if (!status.isDirectory()) {
                    return;
                }
                OmKeyInfo keyInfo = status.getKeyInfo();
                String keyName = OzoneFSUtils.addTrailingSlashIfNeeded(keyInfo.getKeyName());
                if (StringUtils.equals(keyName, this.removeStartKey)) {
                    return;
                }
                OzoneKey ozoneKey = new OzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyName, keyInfo.getDataSize(), keyInfo.getCreationTime(), keyInfo.getModificationTime(), keyInfo.getReplicationConfig(), keyInfo.isFile(), keyInfo.getOwnerName());
                keysResultList.add(ozoneKey);
            }
        }
    }

    private class KeyIterator
    implements Iterator<OzoneKey> {
        private String keyPrefix = null;
        private Iterator<OzoneKey> currentIterator;
        private OzoneKey currentValue;
        private final boolean shallow;
        private boolean addedKeyPrefix;
        private String delimiterKeyPrefix;

        boolean shallow() {
            return this.shallow;
        }

        String getKeyPrefix() {
            return this.keyPrefix;
        }

        void setKeyPrefix(String keyPrefixPath) {
            this.keyPrefix = keyPrefixPath;
        }

        boolean addedKeyPrefix() {
            return this.addedKeyPrefix;
        }

        void setAddedKeyPrefix(boolean addedKeyPrefix) {
            this.addedKeyPrefix = addedKeyPrefix;
        }

        String getDelimiterKeyPrefix() {
            return this.delimiterKeyPrefix;
        }

        void setDelimiterKeyPrefix(String delimiterKeyPrefix) {
            this.delimiterKeyPrefix = delimiterKeyPrefix;
        }

        KeyIterator(String keyPrefix, String prevKey, boolean shallow) throws IOException {
            this.setKeyPrefix(keyPrefix);
            this.currentValue = null;
            this.shallow = shallow;
            this.currentIterator = this.getNextListOfKeys(prevKey).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext() && this.currentValue != null) {
                try {
                    this.currentIterator = this.getNextListOfKeys(this.currentValue.getName()).iterator();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneKey next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        List<OzoneKey> getNextListOfKeys(String prevKey) throws IOException {
            if (this.shallow) {
                return this.getNextShallowListOfKeys(prevKey);
            }
            return OzoneBucket.this.proxy.listKeys(OzoneBucket.this.volumeName, OzoneBucket.this.name, this.keyPrefix, prevKey, OzoneBucket.this.listCacheSize);
        }

        List<OzoneKey> getNextShallowListOfKeys(String prevKey) throws IOException {
            ArrayList<OzoneKey> resultList = new ArrayList<OzoneKey>();
            String startKey = prevKey;
            if (!this.addedKeyPrefix) {
                this.initDelimiterKeyPrefix();
                List<OzoneKey> nextOneKeys = OzoneBucket.this.proxy.listKeys(OzoneBucket.this.volumeName, OzoneBucket.this.name, this.getKeyPrefix(), prevKey, 1);
                if (nextOneKeys.isEmpty()) {
                    return nextOneKeys;
                }
                startKey = nextOneKeys.get(0).getName();
                String string = startKey = startKey == null ? "" : startKey;
                if (this.getKeyPrefix().endsWith("/") && startKey.equals(this.getKeyPrefix())) {
                    resultList.add(nextOneKeys.get(0));
                }
            }
            List<OzoneFileStatusLight> statuses = OzoneBucket.this.proxy.listStatusLight(OzoneBucket.this.volumeName, OzoneBucket.this.name, this.delimiterKeyPrefix, false, startKey, OzoneBucket.this.listCacheSize, false);
            if (this.addedKeyPrefix && statuses.size() > 0) {
                statuses.remove(0);
            } else {
                this.setAddedKeyPrefix(true);
            }
            List<OzoneKey> ozoneKeys = this.buildKeysWithKeyPrefix(statuses);
            resultList.addAll(ozoneKeys);
            return resultList;
        }

        protected void initDelimiterKeyPrefix() {
            this.setDelimiterKeyPrefix(this.getKeyPrefix());
            if (!this.getKeyPrefix().endsWith("/")) {
                this.setDelimiterKeyPrefix(OzoneFSUtils.getParentDir(this.getKeyPrefix()));
            }
        }

        protected List<OzoneKey> buildKeysWithKeyPrefix(List<OzoneFileStatusLight> statuses) {
            return statuses.stream().map(x$0 -> OzoneBucket.toOzoneKey(x$0)).filter(key -> StringUtils.startsWith(key.getName(), this.getKeyPrefix())).collect(Collectors.toList());
        }
    }

    public static class Builder
    extends WithMetadata.Builder {
        private ConfigurationSource conf;
        private ClientProtocol proxy;
        private String volumeName;
        private String name;
        private DefaultReplicationConfig defaultReplicationConfig;
        private StorageType storageType;
        private Boolean versioning;
        private long usedBytes;
        private long usedNamespace;
        private long creationTime;
        private long modificationTime;
        private String encryptionKeyName;
        private String sourceVolume;
        private String sourceBucket;
        private long quotaInBytes;
        private long quotaInNamespace;
        private BucketLayout bucketLayout;
        private String owner;

        protected Builder() {
        }

        private Builder(ConfigurationSource conf, ClientProtocol proxy) {
            this.conf = conf;
            this.proxy = proxy;
        }

        @Override
        public Builder setMetadata(Map<String, String> metadata) {
            super.setMetadata(metadata);
            return this;
        }

        public Builder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDefaultReplicationConfig(DefaultReplicationConfig defaultReplicationConfig) {
            this.defaultReplicationConfig = defaultReplicationConfig;
            return this;
        }

        public Builder setStorageType(StorageType storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder setVersioning(Boolean versioning) {
            this.versioning = versioning;
            return this;
        }

        public Builder setUsedBytes(long usedBytes) {
            this.usedBytes = usedBytes;
            return this;
        }

        public Builder setUsedNamespace(long usedNamespace) {
            this.usedNamespace = usedNamespace;
            return this;
        }

        public Builder setCreationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder setModificationTime(long modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public Builder setEncryptionKeyName(String encryptionKeyName) {
            this.encryptionKeyName = encryptionKeyName;
            return this;
        }

        public Builder setSourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
            return this;
        }

        public Builder setSourceBucket(String sourceBucket) {
            this.sourceBucket = sourceBucket;
            return this;
        }

        public Builder setQuotaInBytes(long quotaInBytes) {
            this.quotaInBytes = quotaInBytes;
            return this;
        }

        public Builder setQuotaInNamespace(long quotaInNamespace) {
            this.quotaInNamespace = quotaInNamespace;
            return this;
        }

        public Builder setBucketLayout(BucketLayout bucketLayout) {
            this.bucketLayout = bucketLayout;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public OzoneBucket build() {
            return new OzoneBucket(this);
        }
    }
}

