/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneSnapshot;
import org.apache.hadoop.ozone.client.OzoneSnapshotDiff;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.TenantArgs;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.DeleteTenantState;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.S3VolumeContext;
import org.apache.hadoop.ozone.om.helpers.TenantStateList;
import org.apache.hadoop.ozone.om.helpers.TenantUserInfoValue;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Strings;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.snapshot.CancelSnapshotDiffResponse;
import org.apache.hadoop.ozone.snapshot.ListSnapshotResponse;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStore {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStore.class);
    private final ConfigurationSource conf;
    private final ClientProtocol proxy;
    private int listCacheSize;
    private final String defaultS3Volume;
    private BucketLayout s3BucketLayout;

    public ObjectStore(ConfigurationSource conf, ClientProtocol proxy) {
        this.conf = conf;
        this.proxy = TracingUtil.createProxy(proxy, ClientProtocol.class, conf);
        this.listCacheSize = HddsClientUtils.getListCacheSize(conf);
        this.defaultS3Volume = HddsClientUtils.getDefaultS3VolumeName(conf);
        this.s3BucketLayout = OmUtils.validateBucketLayout(conf.getTrimmed("ozone.s3g.default.bucket.layout", "OBJECT_STORE"));
    }

    @VisibleForTesting
    protected ObjectStore() {
        this.conf = new OzoneConfiguration();
        this.proxy = null;
        this.defaultS3Volume = HddsClientUtils.getDefaultS3VolumeName(this.conf);
    }

    @VisibleForTesting
    public ClientProtocol getClientProxy() {
        return this.proxy;
    }

    public void createVolume(String volumeName) throws IOException {
        this.proxy.createVolume(volumeName);
    }

    public void createVolume(String volumeName, VolumeArgs volumeArgs) throws IOException {
        this.proxy.createVolume(volumeName, volumeArgs);
    }

    public void createS3Bucket(String bucketName) throws IOException {
        OzoneVolume volume = this.getS3Volume();
        try {
            volume.createBucket(bucketName, BucketArgs.newBuilder().setBucketLayout(this.s3BucketLayout).build());
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION) {
                BucketLayout fallbackLayout = BucketLayout.LEGACY;
                LOG.info("Failed to create S3 bucket with layout {} since OM is pre-finalized for bucket layouts. Retrying creation with a {} bucket.", (Object)this.s3BucketLayout, (Object)fallbackLayout);
                volume.createBucket(bucketName, BucketArgs.newBuilder().setBucketLayout(fallbackLayout).build());
            }
            throw ex;
        }
    }

    public OzoneBucket getS3Bucket(String bucketName) throws IOException {
        return this.getS3Volume().getBucket(bucketName);
    }

    public void deleteS3Bucket(String bucketName) throws IOException {
        try {
            OzoneVolume volume = this.getS3Volume();
            volume.deleteBucket(bucketName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.VOLUME_NOT_FOUND) {
                throw new OMException(OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            throw ex;
        }
    }

    public OzoneVolume getVolume(String volumeName) throws IOException {
        return this.proxy.getVolumeDetails(volumeName);
    }

    public OzoneVolume getS3Volume() throws IOException {
        S3VolumeContext resp = this.proxy.getS3VolumeContext();
        OmVolumeArgs volume = resp.getOmVolumeArgs();
        return this.proxy.buildOzoneVolume(volume);
    }

    public S3VolumeContext getS3VolumeContext() throws IOException {
        return this.proxy.getS3VolumeContext();
    }

    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        return this.proxy.getS3Secret(kerberosID);
    }

    public S3SecretValue getS3Secret(String kerberosID, boolean createIfNotExist) throws IOException {
        return this.proxy.getS3Secret(kerberosID, createIfNotExist);
    }

    public S3SecretValue setS3Secret(String accessId, String secretKey) throws IOException {
        return this.proxy.setS3Secret(accessId, secretKey);
    }

    public void revokeS3Secret(String kerberosID) throws IOException {
        this.proxy.revokeS3Secret(kerberosID);
    }

    public void createTenant(String tenantId) throws IOException {
        this.proxy.createTenant(tenantId);
    }

    public void createTenant(String tenantId, TenantArgs tenantArgs) throws IOException {
        this.proxy.createTenant(tenantId, tenantArgs);
    }

    public DeleteTenantState deleteTenant(String tenantId) throws IOException {
        return this.proxy.deleteTenant(tenantId);
    }

    public S3SecretValue tenantAssignUserAccessId(String username, String tenantId, String accessId) throws IOException {
        return this.proxy.tenantAssignUserAccessId(username, tenantId, accessId);
    }

    public void tenantRevokeUserAccessId(String accessId) throws IOException {
        this.proxy.tenantRevokeUserAccessId(accessId);
    }

    public void tenantAssignAdmin(String accessId, String tenantId, boolean delegated) throws IOException {
        this.proxy.tenantAssignAdmin(accessId, tenantId, delegated);
    }

    public void tenantRevokeAdmin(String accessId, String tenantId) throws IOException {
        this.proxy.tenantRevokeAdmin(accessId, tenantId);
    }

    public TenantUserList listUsersInTenant(String tenantId, String userPrefix) throws IOException {
        return this.proxy.listUsersInTenant(tenantId, userPrefix);
    }

    public TenantUserInfoValue tenantGetUserInfo(String userPrincipal) throws IOException {
        return this.proxy.tenantGetUserInfo(userPrincipal);
    }

    public TenantStateList listTenant() throws IOException {
        return this.proxy.listTenant();
    }

    public Iterator<? extends OzoneVolume> listVolumes(String volumePrefix) throws IOException {
        return this.listVolumes(volumePrefix, null);
    }

    public Iterator<? extends OzoneVolume> listVolumes(String volumePrefix, String prevVolume) throws IOException {
        return new VolumeIterator(null, volumePrefix, prevVolume);
    }

    public Iterator<? extends OzoneVolume> listVolumesByUser(String user, String volumePrefix, String prevVolume) throws IOException {
        if (Strings.isNullOrEmpty(user)) {
            user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        return new VolumeIterator(user, volumePrefix, prevVolume);
    }

    public void deleteVolume(String volumeName) throws IOException {
        this.proxy.deleteVolume(volumeName);
    }

    public KeyProvider getKeyProvider() throws IOException {
        return this.proxy.getKeyProvider();
    }

    public URI getKeyProviderUri() throws IOException {
        return this.proxy.getKeyProviderUri();
    }

    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.proxy.getDelegationToken(renewer);
    }

    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        return this.proxy.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        this.proxy.cancelDelegationToken(token);
    }

    public String getCanonicalServiceName() {
        return this.proxy.getCanonicalServiceName();
    }

    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        return this.proxy.addAcl(obj, acl);
    }

    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        return this.proxy.removeAcl(obj, acl);
    }

    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        return this.proxy.setAcl(obj, acls);
    }

    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        return this.proxy.getAcl(obj);
    }

    public String createSnapshot(String volumeName, String bucketName, String snapshotName) throws IOException {
        return this.proxy.createSnapshot(volumeName, bucketName, snapshotName);
    }

    public void renameSnapshot(String volumeName, String bucketName, String snapshotOldName, String snapshotNewName) throws IOException {
        this.proxy.renameSnapshot(volumeName, bucketName, snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(String volumeName, String bucketName, String snapshotName) throws IOException {
        this.proxy.deleteSnapshot(volumeName, bucketName, snapshotName);
    }

    public OzoneSnapshot getSnapshotInfo(String volumeName, String bucketName, String snapshotName) throws IOException {
        return this.proxy.getSnapshotInfo(volumeName, bucketName, snapshotName);
    }

    public Iterator<OzoneSnapshot> listSnapshot(String volumeName, String bucketName, String snapshotPrefix, String prevSnapshot) throws IOException {
        return new SnapshotIterator(volumeName, bucketName, snapshotPrefix, prevSnapshot);
    }

    public String printCompactionLogDag(String fileNamePrefix, String graphType) throws IOException {
        return this.proxy.printCompactionLogDag(fileNamePrefix, graphType);
    }

    public SnapshotDiffResponse snapshotDiff(String volumeName, String bucketName, String fromSnapshot, String toSnapshot, String token, int pageSize, boolean forceFullDiff, boolean disableNativeDiff) throws IOException {
        return this.proxy.snapshotDiff(volumeName, bucketName, fromSnapshot, toSnapshot, token, pageSize, forceFullDiff, disableNativeDiff);
    }

    public CancelSnapshotDiffResponse cancelSnapshotDiff(String volumeName, String bucketName, String fromSnapshot, String toSnapshot) throws IOException {
        return this.proxy.cancelSnapshotDiff(volumeName, bucketName, fromSnapshot, toSnapshot);
    }

    public List<OzoneSnapshotDiff> listSnapshotDiffJobs(String volumeName, String bucketName, String jobStatus, boolean listAll) throws IOException {
        return this.proxy.listSnapshotDiffJobs(volumeName, bucketName, jobStatus, listAll);
    }

    private final class SnapshotIterator
    implements Iterator<OzoneSnapshot> {
        private final String volumeName;
        private final String bucketName;
        private final String snapshotPrefix;
        private String lastSnapshot = null;
        private Iterator<OzoneSnapshot> currentIterator;

        SnapshotIterator(String volumeName, String bucketName, String snapshotPrefix, String prevSnapshot) throws IOException {
            this.volumeName = volumeName;
            this.bucketName = bucketName;
            this.snapshotPrefix = snapshotPrefix;
            this.getNextListOfSnapshots(prevSnapshot);
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext() && StringUtils.isNotEmpty(this.lastSnapshot)) {
                try {
                    this.getNextListOfSnapshots(this.lastSnapshot);
                }
                catch (IOException e) {
                    LOG.error("Error retrieving next batch of list results", (Throwable)e);
                }
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneSnapshot next() {
            if (this.hasNext()) {
                return this.currentIterator.next();
            }
            throw new NoSuchElementException();
        }

        private void getNextListOfSnapshots(String startSnapshot) throws IOException {
            ListSnapshotResponse response = ObjectStore.this.proxy.listSnapshot(this.volumeName, this.bucketName, this.snapshotPrefix, startSnapshot, ObjectStore.this.listCacheSize);
            this.currentIterator = response.getSnapshotInfos().stream().map(OzoneSnapshot::fromSnapshotInfo).iterator();
            this.lastSnapshot = response.getLastSnapshot();
        }
    }

    private class VolumeIterator
    implements Iterator<OzoneVolume> {
        private String user = null;
        private String volPrefix = null;
        private Iterator<OzoneVolume> currentIterator;
        private OzoneVolume currentValue;

        VolumeIterator(String user, String volPrefix, String prevVolume) {
            this.user = user;
            this.volPrefix = volPrefix;
            this.currentValue = null;
            this.currentIterator = this.getNextListOfVolumes(prevVolume).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext() && this.currentValue != null) {
                this.currentIterator = this.getNextListOfVolumes(this.currentValue.getName()).iterator();
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneVolume next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        private List<OzoneVolume> getNextListOfVolumes(String prevVolume) {
            try {
                if (this.user != null) {
                    return ObjectStore.this.proxy.listVolumes(this.user, this.volPrefix, prevVolume, ObjectStore.this.listCacheSize);
                }
                return ObjectStore.this.proxy.listVolumes(this.volPrefix, prevVolume, ObjectStore.this.listCacheSize);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

