/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.ComponentVersion;

public enum OzoneManagerVersion implements ComponentVersion
{
    DEFAULT_VERSION(0, "Initial version"),
    S3G_PERSISTENT_CONNECTIONS(1, "New S3G persistent connection support is present in OM."),
    ERASURE_CODED_STORAGE_SUPPORT(2, "OzoneManager version that supportsECReplicationConfig"),
    OPTIMIZED_GET_KEY_INFO(3, "OzoneManager version that supports optimized key lookups using cached container locations."),
    LIGHTWEIGHT_LIST_KEYS(4, "OzoneManager version that supports lightweight listKeys API."),
    OBJECT_TAG(5, "OzoneManager version that supports object tags"),
    ATOMIC_REWRITE_KEY(6, "OzoneManager version that supports rewriting key as atomic operation"),
    HBASE_SUPPORT(7, "OzoneManager version that supports HBase integration"),
    LIGHTWEIGHT_LIST_STATUS(8, "OzoneManager version that supports lightweight listStatus API."),
    FUTURE_VERSION(-1, "Used internally in the client when the server side is  newer and an unknown server version has arrived to the client.");

    public static final OzoneManagerVersion CURRENT;
    private static final Map<Integer, OzoneManagerVersion> BY_PROTO_VALUE;
    private final int version;
    private final String description;

    private OzoneManagerVersion(int version, String description) {
        this.version = version;
        this.description = description;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public int toProtoValue() {
        return this.version;
    }

    public static OzoneManagerVersion fromProtoValue(int value) {
        return BY_PROTO_VALUE.getOrDefault(value, FUTURE_VERSION);
    }

    private static OzoneManagerVersion latest() {
        OzoneManagerVersion[] versions = OzoneManagerVersion.values();
        return versions[versions.length - 2];
    }

    static {
        CURRENT = OzoneManagerVersion.latest();
        BY_PROTO_VALUE = Arrays.stream(OzoneManagerVersion.values()).collect(Collectors.toMap(OzoneManagerVersion::toProtoValue, Function.identity()));
    }
}

