/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import java.io.File;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collection;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServerUtils.class);

    private ServerUtils() {
    }

    public static long sanitizeUserArgs(String key, long valueTocheck, String baseKey, long baseValue, long minFactor, long maxFactor) {
        long minLimit = baseValue * minFactor;
        long maxLimit = baseValue * maxFactor;
        if (valueTocheck < minLimit) {
            LOG.warn("{} value = {} is smaller than min = {} based on the key value of {}, reset to the min value {}.", new Object[]{key, valueTocheck, minLimit, baseKey, minLimit});
            valueTocheck = minLimit;
        } else if (valueTocheck > maxLimit) {
            LOG.warn("{} value = {} is larger than max = {} based on the key value of {}, reset to the max value {}.", new Object[]{key, valueTocheck, maxLimit, baseKey, maxLimit});
            valueTocheck = maxLimit;
        }
        return valueTocheck;
    }

    public static InetSocketAddress updateRPCListenAddress(OzoneConfiguration conf, String rpcAddressKey, InetSocketAddress addr, RPC.Server rpcServer) {
        return ServerUtils.updateListenAddress(conf, rpcAddressKey, addr, rpcServer.getListenerAddress());
    }

    public static InetSocketAddress updateListenAddress(OzoneConfiguration conf, String addressKey, InetSocketAddress addr, InetSocketAddress listenAddr) {
        InetSocketAddress updatedAddr = new InetSocketAddress(addr.getHostString(), listenAddr.getPort());
        conf.set(addressKey, addr.getHostString() + ":" + listenAddr.getPort());
        return updatedAddr;
    }

    public static File getScmDbDir(ConfigurationSource conf) {
        File metadataDir = ServerUtils.getDirectoryFromConfig(conf, "ozone.scm.db.dirs", "SCM");
        if (metadataDir != null) {
            return metadataDir;
        }
        LOG.warn("{} is not configured. We recommend adding this setting. Falling back to {} instead.", (Object)"ozone.scm.db.dirs", (Object)"ozone.metadata.dirs");
        return ServerUtils.getOzoneMetaDirPath(conf);
    }

    public static File getDirectoryFromConfig(ConfigurationSource conf, String key, String componentName) {
        Collection<String> metadirs = conf.getTrimmedStringCollection(key);
        if (metadirs.size() > 1) {
            throw new IllegalArgumentException("Bad config setting " + key + ". " + componentName + " does not support multiple metadata dirs currently");
        }
        if (metadirs.size() == 1) {
            File dbDirPath = new File(metadirs.iterator().next());
            if (!dbDirPath.mkdirs() && !dbDirPath.exists()) {
                throw new IllegalArgumentException("Unable to create directory " + dbDirPath + " specified in configuration setting " + key);
            }
            try {
                Path path = dbDirPath.toPath();
                String permissionValue = ServerUtils.getPermissions(key, conf);
                String symbolicPermission = ServerUtils.getSymbolicPermission(permissionValue);
                Files.setPosixFilePermissions(path, PosixFilePermissions.fromString(symbolicPermission));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set directory permissions for " + dbDirPath + ": " + e.getMessage(), e);
            }
            return dbDirPath;
        }
        return null;
    }

    private static String getSymbolicPermission(String permissionValue) {
        if (ServerUtils.isSymbolic(permissionValue)) {
            return permissionValue;
        }
        short octalPermission = Short.parseShort(permissionValue, 8);
        FsPermission fsPermission = new FsPermission(octalPermission);
        return fsPermission.toString();
    }

    private static boolean isSymbolic(String permissionValue) {
        return permissionValue.matches(".*[rwx].*");
    }

    public static String getPermissions(String key, ConfigurationSource conf) {
        String configName = "";
        configName = key.equals("ozone.recon.db.dir") ? "ozone.recon.db.dirs.permissions" : (key.equals("ozone.scm.db.dirs") ? "ozone.scm.db.dirs.permissions" : (key.equals("ozone.om.db.dirs") ? "ozone.om.db.dirs.permissions" : "ozone.metadata.dirs.permissions"));
        String configValue = conf.get(configName);
        if (configValue != null) {
            return configValue;
        }
        throw new IllegalArgumentException("Invalid configuration value for key: " + key);
    }

    public static File getOzoneMetaDirPath(ConfigurationSource conf) {
        File dirPath = ServerUtils.getDirectoryFromConfig(conf, "ozone.metadata.dirs", "Ozone");
        if (dirPath == null) {
            throw new IllegalArgumentException("ozone.metadata.dirs must be defined.");
        }
        return dirPath;
    }

    public static void setOzoneMetaDirPath(OzoneConfiguration conf, String path) {
        conf.set("ozone.metadata.dirs", path);
    }

    public static File getDBPath(ConfigurationSource conf, String key) {
        File dbDirPath = ServerUtils.getDirectoryFromConfig(conf, key, "OM");
        if (dbDirPath != null) {
            return dbDirPath;
        }
        LOG.warn("{} is not configured. We recommend adding this setting. Falling back to {} instead.", (Object)key, (Object)"ozone.metadata.dirs");
        return ServerUtils.getOzoneMetaDirPath(conf);
    }

    public static String getRemoteUserName() {
        UserGroupInformation remoteUser = Server.getRemoteUser();
        return remoteUser != null ? remoteUser.getUserName() : null;
    }

    public static String getDefaultRatisDirectory(ConfigurationSource conf) {
        LOG.warn("Storage directory for Ratis is not configured. It is a good idea to map this to an SSD disk. Falling back to {}", (Object)"ozone.metadata.dirs");
        File metaDirPath = ServerUtils.getOzoneMetaDirPath(conf);
        return new File(metaDirPath, "ratis").getPath();
    }
}

