/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.MappingIterator;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.SequenceWriter;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final ObjectMapper MAPPER;
    private static final ObjectWriter WRITER;
    private static final ObjectMapper INDENT_OUTPUT_MAPPER;
    public static final Logger LOG;

    private JsonUtils() {
    }

    public static String toJsonStringWithDefaultPrettyPrinter(Object obj) throws IOException {
        return WRITER.writeValueAsString(obj);
    }

    public static String toJsonString(Object obj) throws IOException {
        return MAPPER.writeValueAsString(obj);
    }

    public static String toJsonStringWIthIndent(Object obj) {
        try {
            return INDENT_OUTPUT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error in JSON serialization", (Throwable)e);
            return "{}";
        }
    }

    public static ArrayNode createArrayNode() {
        return MAPPER.createArrayNode();
    }

    public static ObjectNode createObjectNode(Object next) {
        if (next == null) {
            return MAPPER.createObjectNode();
        }
        return (ObjectNode)MAPPER.valueToTree(next);
    }

    public static JsonNode readTree(String content) throws IOException {
        return MAPPER.readTree(content);
    }

    public static <T> T readFromReader(Reader reader, Class<T> valueType) throws IOException {
        return MAPPER.readValue(reader, valueType);
    }

    public static <T> void writeToFile(Iterable<T> items, File file) throws IOException {
        ObjectWriter writer = MAPPER.writer();
        try (SequenceWriter sequenceWriter = writer.writeValues(file);){
            sequenceWriter.init(true);
            for (T item : items) {
                sequenceWriter.write(item);
            }
        }
    }

    public static <T> List<T> readFromFile(File file, Class<T> itemType) throws IOException {
        ObjectReader reader = MAPPER.readerFor(itemType);
        try (MappingIterator mappingIterator = reader.readValues(file);){
            List list = mappingIterator.readAll();
            return list;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(JsonUtils.class);
        MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule(new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        WRITER = MAPPER.writerWithDefaultPrettyPrinter();
        INDENT_OUTPUT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule(new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).enable(SerializationFeature.INDENT_OUTPUT);
    }
}

