/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.client;

import java.io.Closeable;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.hadoop.hdds.security.exception.OzoneSecurityException;
import org.apache.hadoop.hdds.security.ssl.ReloadingX509KeyManager;
import org.apache.hadoop.hdds.security.ssl.ReloadingX509TrustManager;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateNotification;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateSignRequest;
import org.apache.hadoop.hdds.security.x509.exception.CertificateException;

public interface CertificateClient
extends Closeable {
    public String getComponentName();

    public PrivateKey getPrivateKey();

    public PublicKey getPublicKey();

    public X509Certificate getCertificate();

    public X509Certificate getCertificate(String var1) throws CertificateException;

    public CertPath getCertPath();

    public X509Certificate getCACertificate();

    public List<X509Certificate> getTrustChain() throws IOException;

    public X509Certificate getRootCACertificate();

    public Set<X509Certificate> getAllRootCaCerts();

    public Set<X509Certificate> getAllCaCerts();

    public List<String> getCAList();

    public List<String> updateCAList() throws IOException;

    public boolean verifySignature(byte[] var1, byte[] var2, X509Certificate var3) throws CertificateException;

    public CertificateSignRequest.Builder getCSRBuilder() throws CertificateException;

    default public void assertValidKeysAndCertificate() throws OzoneSecurityException {
        try {
            Objects.requireNonNull(this.getPublicKey());
            Objects.requireNonNull(this.getPrivateKey());
            Objects.requireNonNull(this.getCertificate());
        }
        catch (Exception e) {
            throw new OzoneSecurityException("Error reading keypair & certificate", e, OzoneSecurityException.ResultCodes.OM_PUBLIC_PRIVATE_KEY_FILE_NOT_EXIST);
        }
    }

    public ReloadingX509KeyManager getKeyManager() throws CertificateException;

    public ReloadingX509TrustManager getTrustManager() throws CertificateException;

    public void registerNotificationReceiver(CertificateNotification var1);

    public void registerRootCARotationListener(Function<List<X509Certificate>, CompletableFuture<Void>> var1);

    public void initWithRecovery() throws IOException;

    public static enum InitResponse {
        SUCCESS,
        FAILURE,
        GETCERT;

    }
}

