/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hdds.scm.storage.ByteReaderStrategy;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class ByteArrayReader
implements ByteReaderStrategy {
    private final byte[] readBuf;
    private int offset;
    private int targetLen;

    public ByteArrayReader(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.readBuf = b;
        this.offset = off;
        this.targetLen = len;
    }

    @Override
    public int readFromBlock(InputStream is, int numBytesToRead) throws IOException {
        Preconditions.checkArgument(is != null);
        int numBytesRead = is.read(this.readBuf, this.offset, numBytesToRead);
        this.offset += numBytesRead;
        this.targetLen -= numBytesRead;
        return numBytesRead;
    }

    @Override
    public int getTargetLength() {
        return this.targetLen;
    }
}

