/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.net.InnerNode;
import org.apache.hadoop.hdds.scm.net.InnerNodeImpl;
import org.apache.hadoop.hdds.scm.net.NetUtils;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.net.NodeSchemaManager;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.ozone.shaded.org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTopologyImpl
implements NetworkTopology {
    public static final Logger LOG = LoggerFactory.getLogger(NetworkTopologyImpl.class);
    private final InnerNode.Factory factory;
    private final InnerNode clusterTree;
    private final int maxLevel;
    private final NodeSchemaManager schemaManager;
    private final Consumer<List<? extends Node>> shuffleOperation;
    private final ReadWriteLock netlock = new ReentrantReadWriteLock(true);

    public NetworkTopologyImpl(ConfigurationSource conf) {
        this.schemaManager = NodeSchemaManager.getInstance();
        this.schemaManager.init(conf);
        this.shuffleOperation = Collections::shuffle;
        this.maxLevel = this.schemaManager.getMaxLevel();
        this.factory = InnerNodeImpl.FACTORY;
        this.clusterTree = this.factory.newInnerNode("", null, null, 1, this.schemaManager.getCost(1));
    }

    public NetworkTopologyImpl(String schemaFile, InnerNode clusterTree) {
        this.schemaManager = NodeSchemaManager.getInstance();
        this.schemaManager.init(schemaFile);
        this.maxLevel = this.schemaManager.getMaxLevel();
        this.shuffleOperation = Collections::shuffle;
        this.factory = InnerNodeImpl.FACTORY;
        this.clusterTree = clusterTree;
    }

    @VisibleForTesting
    public NetworkTopologyImpl(NodeSchemaManager manager, Consumer<List<? extends Node>> shuffleOperation) {
        this.schemaManager = manager;
        this.shuffleOperation = shuffleOperation;
        this.maxLevel = this.schemaManager.getMaxLevel();
        this.factory = InnerNodeImpl.FACTORY;
        this.clusterTree = this.factory.newInnerNode("", null, null, 1, this.schemaManager.getCost(1));
    }

    @VisibleForTesting
    public NetworkTopologyImpl(NodeSchemaManager manager) {
        this(manager, Collections::shuffle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Node node) {
        boolean add;
        Preconditions.checkArgument(node != null, "node cannot be null");
        if (node instanceof InnerNode) {
            throw new IllegalArgumentException("Not allowed to add an inner node: " + node.getNetworkFullPath());
        }
        int newDepth = NetUtils.locationToDepth(node.getNetworkLocation()) + 1;
        if (this.maxLevel != newDepth) {
            throw new NetworkTopology.InvalidTopologyException("Failed to add " + node.getNetworkFullPath() + ": Its path depth is not " + this.maxLevel);
        }
        this.netlock.writeLock().lock();
        try {
            add = this.clusterTree.add(node);
        }
        finally {
            this.netlock.writeLock().unlock();
        }
        if (add) {
            LOG.info("Added a new node: {}", (Object)node.getNetworkFullPath());
            if (LOG.isDebugEnabled()) {
                LOG.debug("NetworkTopology became:\n{}", (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Node oldNode, Node newNode) {
        boolean add;
        Preconditions.checkArgument(newNode != null, "newNode cannot be null");
        if (oldNode instanceof InnerNode) {
            throw new IllegalArgumentException("Not allowed to update an inner node: " + oldNode.getNetworkFullPath());
        }
        if (newNode instanceof InnerNode) {
            throw new IllegalArgumentException("Not allowed to update a leaf node to an inner node: " + newNode.getNetworkFullPath());
        }
        int newDepth = NetUtils.locationToDepth(newNode.getNetworkLocation()) + 1;
        if (this.maxLevel != newDepth) {
            throw new NetworkTopology.InvalidTopologyException("Failed to update to " + newNode.getNetworkFullPath() + ": Its path depth is not " + this.maxLevel);
        }
        this.netlock.writeLock().lock();
        try {
            boolean exist = false;
            if (oldNode != null) {
                exist = this.containsNode(oldNode);
            }
            if (exist) {
                this.clusterTree.remove(oldNode);
            }
            add = this.clusterTree.add(newNode);
        }
        finally {
            this.netlock.writeLock().unlock();
        }
        if (add) {
            LOG.info("Updated to the new node: {}", (Object)newNode.getNetworkFullPath());
            if (LOG.isDebugEnabled()) {
                LOG.debug("NetworkTopology became:\n{}", (Object)this);
            }
        }
    }

    @Override
    public void remove(Node node) {
        Preconditions.checkArgument(node != null, "node cannot be null");
        if (node instanceof InnerNode) {
            throw new IllegalArgumentException("Not allowed to remove an inner node: " + node.getNetworkFullPath());
        }
        this.netlock.writeLock().lock();
        try {
            this.clusterTree.remove(node);
        }
        finally {
            this.netlock.writeLock().unlock();
        }
        LOG.info("Removed a node: {}", (Object)node.getNetworkFullPath());
        if (LOG.isDebugEnabled()) {
            LOG.debug("NetworkTopology became:\n{}", (Object)this);
        }
    }

    @Override
    public boolean contains(Node node) {
        Preconditions.checkArgument(node != null, "node cannot be null");
        this.netlock.readLock().lock();
        try {
            boolean bl = this.containsNode(node);
            return bl;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    private boolean containsNode(Node node) {
        InnerNode parent;
        for (parent = node.getParent(); parent != null && !Objects.equals(parent, this.clusterTree); parent = parent.getParent()) {
        }
        return Objects.equals(parent, this.clusterTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameAncestor(Node node1, Node node2, int ancestorGen) {
        if (node1 == null || node2 == null || ancestorGen <= 0) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            Node ancestor1 = node1.getAncestor(ancestorGen);
            Node ancestor2 = node2.getAncestor(ancestorGen);
            boolean bl = Objects.equals(ancestor1, ancestor2);
            return bl;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameParent(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            node1 = node1.getParent();
            node2 = node2.getParent();
            boolean bl = Objects.equals(node1, node2);
            return bl;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getAncestor(Node node, int ancestorGen) {
        if (node == null) {
            return null;
        }
        this.netlock.readLock().lock();
        try {
            Node node2 = node.getAncestor(ancestorGen);
            return node2;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    @Override
    public Node getNode(String loc) {
        loc = NetUtils.normalize(loc);
        this.netlock.readLock().lock();
        try {
            if (!"".equals(loc)) {
                Node node = this.clusterTree.getNode(loc);
                return node;
            }
            InnerNode innerNode = this.clusterTree;
            return innerNode;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumOfLeafNode(String loc) {
        this.netlock.readLock().lock();
        try {
            Node node = this.getNode(loc);
            if (node != null) {
                int n = node.getNumOfLeaves();
                return n;
            }
        }
        finally {
            this.netlock.readLock().unlock();
        }
        return 0;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public int getNumOfNodes(int level) {
        Preconditions.checkArgument(level > 0 && level <= this.maxLevel, "Invalid level");
        this.netlock.readLock().lock();
        try {
            int n = this.clusterTree.getNumOfNodes(level);
            return n;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    @Override
    public List<Node> getNodes(int level) {
        Preconditions.checkArgument(level > 0 && level <= this.maxLevel, "Invalid level");
        this.netlock.readLock().lock();
        try {
            List<Node> list = this.clusterTree.getNodes(level);
            return list;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    @Override
    public Node chooseRandom(String scope) {
        if (scope == null) {
            scope = "";
        }
        if (scope.startsWith("~")) {
            ArrayList<String> excludedScopes = new ArrayList<String>();
            excludedScopes.add(scope.substring(1));
            return this.chooseRandom("", excludedScopes, null, null, 0);
        }
        return this.chooseRandom(scope, null, null, null, 0);
    }

    @Override
    public Node chooseRandom(String scope, List<String> excludedScopes) {
        return this.chooseRandom(scope, excludedScopes, null, null, 0);
    }

    @Override
    public Node chooseRandom(String scope, Collection<Node> excludedNodes) {
        if (scope == null) {
            scope = "";
        }
        if (scope.startsWith("~")) {
            ArrayList<String> excludedScopes = new ArrayList<String>();
            excludedScopes.add(scope.substring(1));
            return this.chooseRandom("", excludedScopes, excludedNodes, null, 0);
        }
        return this.chooseRandom(scope, null, excludedNodes, null, 0);
    }

    @Override
    public Node chooseRandom(String scope, Collection<Node> excludedNodes, int ancestorGen) {
        if (scope == null) {
            scope = "";
        }
        if (scope.startsWith("~")) {
            ArrayList<String> excludedScopes = new ArrayList<String>();
            excludedScopes.add(scope.substring(1));
            return this.chooseRandom("", excludedScopes, excludedNodes, null, ancestorGen);
        }
        return this.chooseRandom(scope, null, excludedNodes, null, ancestorGen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node chooseRandom(String scope, List<String> excludedScopes, Collection<? extends Node> excludedNodes, Node affinityNode, int ancestorGen) {
        if (scope == null) {
            scope = "";
        }
        this.checkScope(scope);
        this.checkExcludedScopes(excludedScopes);
        this.checkAffinityNode(affinityNode);
        this.checkAncestorGen(ancestorGen);
        this.netlock.readLock().lock();
        try {
            Node node = this.chooseNodeInternal(scope, -1, excludedScopes, excludedNodes, affinityNode, ancestorGen);
            return node;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNode(int leafIndex, String scope, List<String> excludedScopes, Collection<Node> excludedNodes, Node affinityNode, int ancestorGen) {
        Preconditions.checkArgument(leafIndex >= 0);
        if (scope == null) {
            scope = "";
        }
        this.checkScope(scope);
        this.checkExcludedScopes(excludedScopes);
        this.checkAffinityNode(affinityNode);
        this.checkAncestorGen(ancestorGen);
        this.netlock.readLock().lock();
        try {
            Node node = this.chooseNodeInternal(scope, leafIndex, excludedScopes, excludedNodes, affinityNode, ancestorGen);
            return node;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    private Node chooseNodeInternal(String scope, int leafIndex, List<String> excludedScopes, Collection<? extends Node> excludedNodes, Node affinityNode, int ancestorGen) {
        Node ret;
        int nodeIndex;
        Node scopeNode;
        Preconditions.checkArgument(scope != null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start choosing node[scope = {}, index = {}, excludedScopes = {}, excludedNodes = {}, affinityNode = {}, ancestorGen = {}", new Object[]{scope, leafIndex, excludedScopes == null ? "" : excludedScopes, excludedNodes == null ? "" : excludedNodes, affinityNode == null ? "" : affinityNode, ancestorGen});
        }
        String finalScope = scope;
        if (affinityNode != null && ancestorGen > 0) {
            Node affinityAncestor = affinityNode.getAncestor(ancestorGen);
            if (affinityAncestor == null) {
                throw new IllegalArgumentException("affinityNode " + affinityNode.getNetworkFullPath() + " doesn't have ancestor on generation  " + ancestorGen);
            }
            if (affinityAncestor.isDescendant(scope)) {
                finalScope = affinityAncestor.getNetworkFullPath();
            } else if (!scope.startsWith(affinityAncestor.getNetworkFullPath())) {
                return null;
            }
            ancestorGen = 0;
        }
        if ((scopeNode = this.getNode(finalScope)) == null) {
            throw new IllegalArgumentException(String.format("No nodes with Scope: %s exists", finalScope));
        }
        ArrayList<String> mutableExcludedScopes = null;
        if (excludedScopes != null && !excludedScopes.isEmpty()) {
            mutableExcludedScopes = new ArrayList<String>();
            for (String s2 : excludedScopes) {
                Node node;
                if (scopeNode.isDescendant(s2)) {
                    return null;
                }
                if (!scopeNode.isAncestor(s2) || (node = this.getNode(s2)) == null) continue;
                if (!mutableExcludedScopes.stream().noneMatch(node::isDescendant)) continue;
                mutableExcludedScopes.add(s2);
            }
        }
        LinkedHashSet<Node> mutableExNodes = new LinkedHashSet<Node>();
        if (affinityNode != null) {
            mutableExNodes.add(affinityNode);
        }
        if (excludedNodes != null) {
            mutableExNodes.addAll(excludedNodes);
        }
        NetUtils.removeDuplicate(this, mutableExNodes, mutableExcludedScopes, ancestorGen);
        int availableNodes = this.getAvailableNodesCount(scopeNode.getNetworkFullPath(), mutableExcludedScopes, mutableExNodes, ancestorGen);
        if (availableNodes <= 0) {
            LOG.info("No available node in (scope=\"{}\" excludedScope=\"{}\" excludedNodes=\"{}\"  ancestorGen=\"{}\").", new Object[]{scopeNode.getNetworkFullPath(), excludedScopes, excludedNodes, ancestorGen});
            return null;
        }
        if (!(scopeNode instanceof InnerNode)) {
            return scopeNode;
        }
        if (leafIndex >= 0) {
            nodeIndex = leafIndex % availableNodes;
            ret = ((InnerNode)scopeNode).getLeaf(nodeIndex, mutableExcludedScopes, mutableExNodes, ancestorGen);
        } else {
            nodeIndex = ThreadLocalRandom.current().nextInt(availableNodes);
            ret = ((InnerNode)scopeNode).getLeaf(nodeIndex, mutableExcludedScopes, mutableExNodes, ancestorGen);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finish choosing node[index = {}, random = {}] from {} available nodes, scope = {}, excludedScope = {},excludeNodes = {}.", new Object[]{nodeIndex, leafIndex == -1 ? "true" : "false", availableNodes, scopeNode.getNetworkFullPath(), excludedScopes, excludedNodes});
            LOG.debug("Chosen node = {}", (Object)(ret == null ? "not found" : ret.toString()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDistanceCost(Node node1, Node node2) {
        if (Objects.equals(node1, node2)) {
            return 0;
        }
        if (node1 == null || node2 == null) {
            LOG.warn("One of the nodes is a null pointer");
            return Integer.MAX_VALUE;
        }
        int level1 = node1.getLevel();
        int level2 = node2.getLevel();
        if (level1 < 1 || level2 < 1) {
            return Integer.MAX_VALUE;
        }
        if (level1 > this.maxLevel || level2 > this.maxLevel) {
            return Integer.MAX_VALUE;
        }
        int cost = 0;
        this.netlock.readLock().lock();
        try {
            Node ancestor1 = node1.getAncestor(level1 - 1);
            Node ancestor2 = node2.getAncestor(level2 - 1);
            if (!Objects.equals(ancestor1, this.clusterTree) || !Objects.equals(ancestor2, this.clusterTree)) {
                LOG.debug("One of the nodes is outside of network topology");
                int n = Integer.MAX_VALUE;
                return n;
            }
            while (level1 > level2 && node1 != null) {
                node1 = node1.getParent();
                --level1;
                cost += node1 == null ? 0 : node1.getCost();
            }
            while (level2 > level1 && node2 != null) {
                node2 = node2.getParent();
                --level2;
                cost += node2 == null ? 0 : node2.getCost();
            }
            while (node1 != null && node2 != null && !Objects.equals(node1, node2)) {
                node1 = node1.getParent();
                node2 = node2.getParent();
                cost += node1 == null ? 0 : node1.getCost();
                cost += node2 == null ? 0 : node2.getCost();
            }
            int n = cost;
            return n;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    @Override
    public <N extends Node> List<N> sortByDistanceCost(Node reader, List<N> nodes, int activeLen) {
        if (reader == null) {
            ArrayList<N> shuffledNodes = new ArrayList<N>(nodes.subList(0, activeLen));
            this.shuffleOperation.accept(shuffledNodes);
            return shuffledNodes;
        }
        int[] costs = new int[activeLen];
        for (int i = 0; i < activeLen; ++i) {
            costs[i] = this.getDistanceCost(reader, (Node)nodes.get(i));
        }
        TreeMap<Integer, List> tree = new TreeMap<Integer, List>();
        for (int i = 0; i < activeLen; ++i) {
            int cost = costs[i];
            Node node = (Node)nodes.get(i);
            tree.computeIfAbsent(cost, k -> Lists.newArrayListWithExpectedSize(1)).add(node);
        }
        ArrayList ret = new ArrayList();
        for (List list : tree.values()) {
            if (list == null) continue;
            this.shuffleOperation.accept(list);
            ret.addAll(list);
        }
        Preconditions.checkState(ret.size() == activeLen, "Wrong number of nodes sorted!");
        return ret;
    }

    private int getAvailableNodesCount(String scope, List<String> excludedScopes, Collection<Node> mutableExcludedNodes, int ancestorGen) {
        int n;
        Preconditions.checkArgument(scope != null);
        Node scopeNode = this.getNode(scope);
        if (scopeNode == null) {
            return 0;
        }
        if (!CollectionUtils.isEmpty(mutableExcludedNodes)) {
            mutableExcludedNodes.removeIf(next -> !next.isDescendant(scope));
        }
        List<Node> excludedAncestorList = NetUtils.getAncestorList(this, mutableExcludedNodes, ancestorGen);
        for (Node node : excludedAncestorList) {
            if (!node.isAncestor(scope)) continue;
            return 0;
        }
        int excludedCount = 0;
        if (excludedScopes != null) {
            for (String excludedScope : excludedScopes) {
                Node excludedScopeNode = this.getNode(excludedScope);
                if (excludedScopeNode == null) continue;
                if (excludedScopeNode.isDescendant(scope)) {
                    excludedCount += excludedScopeNode.getNumOfLeaves();
                    continue;
                }
                if (!excludedScopeNode.isAncestor(scope)) continue;
                return 0;
            }
        }
        if (!CollectionUtils.isEmpty(mutableExcludedNodes)) {
            if (ancestorGen == 0) {
                for (Node node : mutableExcludedNodes) {
                    if (!this.contains(node)) continue;
                    ++excludedCount;
                }
            } else {
                for (Node ancestor : excludedAncestorList) {
                    if (!ancestor.isDescendant(scope)) continue;
                    excludedCount += ancestor.getNumOfLeaves();
                }
            }
        }
        Preconditions.checkState((n = scopeNode.getNumOfLeaves() - excludedCount) >= 0);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder tree = new StringBuilder();
        tree.append("Level: ");
        tree.append(this.maxLevel);
        tree.append("\n");
        this.netlock.readLock().lock();
        try {
            int numOfLeaves = this.clusterTree.getNumOfLeaves();
            tree.append("Number of leaves:");
            tree.append(numOfLeaves);
            tree.append("\n");
            for (int i = 0; i < numOfLeaves; ++i) {
                tree.append(this.clusterTree.getLeaf(i).getNetworkFullPath());
                tree.append("\n");
            }
        }
        finally {
            this.netlock.readLock().unlock();
        }
        return tree.toString();
    }

    private void checkScope(String scope) {
        if (scope != null && scope.startsWith("~")) {
            throw new IllegalArgumentException("scope " + scope + " should not start with " + "~");
        }
    }

    private void checkExcludedScopes(List<String> excludedScopes) {
        if (!CollectionUtils.isEmpty(excludedScopes)) {
            excludedScopes.forEach(scope -> {
                if (scope.startsWith("~")) {
                    throw new IllegalArgumentException("excludedScope " + scope + " cannot start with " + "~");
                }
            });
        }
    }

    private void checkAffinityNode(Node affinityNode) {
        if (affinityNode != null && !this.contains(affinityNode)) {
            throw new IllegalArgumentException("Affinity node " + affinityNode.getNetworkFullPath() + " is not a member of topology");
        }
    }

    private void checkAncestorGen(int ancestorGen) {
        if (ancestorGen > this.maxLevel - 1 || ancestorGen < 0) {
            throw new IllegalArgumentException("ancestorGen " + ancestorGen + " exceeds this network topology acceptable level [0, " + (this.maxLevel - 1) + "]");
        }
    }
}

