/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ContainerID
implements Comparable<ContainerID> {
    private static final Codec<ContainerID> CODEC = new DelegatedCodec<ContainerID, Long>(LongCodec.get(), ContainerID::valueOf, c -> c.id, ContainerID.class, DelegatedCodec.CopyType.SHALLOW);
    public static final ContainerID MIN = ContainerID.valueOf(0L);
    private final long id;

    public static Codec<ContainerID> getCodec() {
        return CODEC;
    }

    public ContainerID(long id) {
        Preconditions.checkState(id >= 0L, "Container ID should be positive. %s.", id);
        this.id = id;
    }

    public static ContainerID valueOf(long containerID) {
        return new ContainerID(containerID);
    }

    @Deprecated
    public long getId() {
        return this.id;
    }

    @Deprecated
    public byte[] getBytes() {
        return LongCodec.get().toPersistedFormat(this.id);
    }

    public HddsProtos.ContainerID getProtobuf() {
        return HddsProtos.ContainerID.newBuilder().setId(this.id).build();
    }

    public static ContainerID getFromProtobuf(HddsProtos.ContainerID proto) {
        return ContainerID.valueOf(proto.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerID that = (ContainerID)o;
        return new EqualsBuilder().append(this.id, that.id).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(61, 71).append(this.id).toHashCode();
    }

    @Override
    public int compareTo(ContainerID that) {
        Preconditions.checkNotNull(that);
        return new CompareToBuilder().append(this.id, that.id).build();
    }

    public String toString() {
        return "#" + this.id;
    }
}

