/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.client;

import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.hadoop.hdds.security.x509.certificate.client.CACertificateProvider;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTrustManager
extends X509ExtendedTrustManager {
    private static final Logger LOG = LoggerFactory.getLogger(ClientTrustManager.class);
    private final CACertificateProvider remoteProvider;
    private X509ExtendedTrustManager trustManager;

    public ClientTrustManager(CACertificateProvider remoteProvider, CACertificateProvider inMemoryProvider) throws IOException {
        Preconditions.checkArgument(remoteProvider != null || inMemoryProvider != null, "Client trust configuration error, no mechanism present to find the rootCA certificate of the cluster.");
        this.remoteProvider = remoteProvider;
        try {
            this.initialize(this.loadCerts(inMemoryProvider));
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
    }

    private void initialize(List<X509Certificate> caCerts) throws CertificateException {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            for (X509Certificate cert : caCerts) {
                String serial = cert.getSerialNumber().toString();
                ks.setCertificateEntry(serial, cert);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(ks);
            this.trustManager = Arrays.stream(trustManagerFactory.getTrustManagers()).filter(tm -> tm instanceof X509ExtendedTrustManager).map(tm -> (X509ExtendedTrustManager)tm).findFirst().orElse(null);
            if (this.trustManager == null) {
                throw new GeneralSecurityException("Could not load TrustManager.");
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new CertificateException(e);
        }
    }

    private List<X509Certificate> loadCerts(CACertificateProvider caCertsProvider) throws CertificateException {
        try {
            LOG.debug("Loading certificates for client.");
            if (caCertsProvider == null) {
                return this.remoteProvider.provideCACerts();
            }
            return caCertsProvider.provideCACerts();
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(chain, authType, socket);
        }
        catch (CertificateException e) {
            LOG.info("CheckServerTrusted call failed, trying to re-fetch rootCA certificate", (Throwable)e);
            this.initialize(this.loadCerts(this.remoteProvider));
            this.trustManager.checkServerTrusted(chain, authType, socket);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(chain, authType, engine);
        }
        catch (CertificateException e) {
            LOG.info("CheckServerTrusted call failed, trying to re-fetch rootCA certificate", (Throwable)e);
            this.initialize(this.loadCerts(this.remoteProvider));
            this.trustManager.checkServerTrusted(chain, authType, engine);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            LOG.info("CheckServerTrusted call failed, trying to re-fetch rootCA certificate", (Throwable)e);
            this.initialize(this.loadCerts(this.remoteProvider));
            this.trustManager.checkServerTrusted(chain, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        throw new CertificateException(new UnsupportedOperationException("ClientTrustManager should not be used as a trust manager of a server socket."));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        throw new CertificateException(new UnsupportedOperationException("ClientTrustManager should not be used as a trust manager of a server socket."));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new CertificateException(new UnsupportedOperationException("ClientTrustManager should not be used as a trust manager of a server socket."));
    }
}

