/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.IOException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.ECXceiverClientGrpc;
import org.apache.hadoop.hdds.scm.ErrorInjector;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.XceiverClientGrpc;
import org.apache.hadoop.hdds.scm.XceiverClientRatis;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.ClientTrustManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class XceiverClientCreator
implements XceiverClientFactory {
    private static ErrorInjector errorInjector;
    private final ConfigurationSource conf;
    private final boolean topologyAwareRead;
    private final ClientTrustManager trustManager;
    private final boolean securityEnabled;

    public static void enableErrorInjection(ErrorInjector injector) {
        errorInjector = injector;
    }

    public XceiverClientCreator(ConfigurationSource conf) {
        this(conf, null);
    }

    public XceiverClientCreator(ConfigurationSource conf, ClientTrustManager trustManager) {
        this.conf = conf;
        this.securityEnabled = OzoneSecurityUtil.isSecurityEnabled(conf);
        this.topologyAwareRead = conf.getBoolean("ozone.network.topology.aware.read", true);
        this.trustManager = trustManager;
        if (this.securityEnabled) {
            Preconditions.checkNotNull(trustManager);
        }
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    protected XceiverClientSpi newClient(Pipeline pipeline) throws IOException {
        XceiverClientSpi client;
        switch (pipeline.getType()) {
            case RATIS: {
                client = XceiverClientRatis.newXceiverClientRatis(pipeline, this.conf, this.trustManager, errorInjector);
                break;
            }
            case STAND_ALONE: {
                client = new XceiverClientGrpc(pipeline, this.conf, this.trustManager);
                break;
            }
            case EC: {
                client = new ECXceiverClientGrpc(pipeline, this.conf, this.trustManager);
                break;
            }
            default: {
                throw new IOException("not implemented " + (Object)((Object)pipeline.getType()));
            }
        }
        try {
            client.connect();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return client;
    }

    @Override
    public XceiverClientSpi acquireClient(Pipeline pipeline) throws IOException {
        return this.acquireClient(pipeline, false);
    }

    @Override
    public void releaseClient(XceiverClientSpi xceiverClient, boolean invalidateClient) {
        this.releaseClient(xceiverClient, invalidateClient, false);
    }

    @Override
    public XceiverClientSpi acquireClientForReadData(Pipeline pipeline) throws IOException {
        return this.acquireClient(pipeline);
    }

    @Override
    public void releaseClientForReadData(XceiverClientSpi xceiverClient, boolean invalidateClient) {
        this.releaseClient(xceiverClient, invalidateClient, this.topologyAwareRead);
    }

    @Override
    public XceiverClientSpi acquireClient(Pipeline pipeline, boolean topologyAware) throws IOException {
        return this.newClient(pipeline);
    }

    @Override
    public void releaseClient(XceiverClientSpi xceiverClient, boolean invalidateClient, boolean topologyAware) {
        IOUtils.closeQuietly(xceiverClient);
    }

    @Override
    public void close() throws Exception {
    }
}

