/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocol;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hdds.DatanodeVersion;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.net.NetConstants;
import org.apache.hadoop.hdds.scm.net.NetUtils;
import org.apache.hadoop.hdds.scm.net.NodeImpl;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Strings;
import org.apache.hadoop.ozone.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.ozone.util.StringWithByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeDetails
extends NodeImpl
implements Comparable<DatanodeDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeDetails.class);
    private static final Codec<DatanodeDetails> CODEC = new DelegatedCodec<DatanodeDetails, HddsProtos.ExtendedDatanodeDetailsProto>(Proto2Codec.get(HddsProtos.ExtendedDatanodeDetailsProto.getDefaultInstance()), DatanodeDetails::getFromProtoBuf, DatanodeDetails::getExtendedProtoBufMessage, DatanodeDetails.class);
    private final UUID uuid;
    private final StringWithByteString uuidString;
    private final String threadNamePrefix;
    private StringWithByteString ipAddress;
    private StringWithByteString hostName;
    private final List<Port> ports;
    private String certSerialId;
    private String version;
    private long setupTime;
    private String revision;
    private String buildDate;
    private volatile HddsProtos.NodeOperationalState persistedOpState;
    private volatile long persistedOpStateExpiryEpochSec;
    private int initialVersion;
    private int currentVersion;

    public static Codec<DatanodeDetails> getCodec() {
        return CODEC;
    }

    private DatanodeDetails(Builder b) {
        super(b.hostName, b.networkLocation, 0);
        this.uuid = b.id;
        this.uuidString = StringWithByteString.valueOf(this.uuid.toString());
        this.threadNamePrefix = HddsUtils.threadNamePrefix(this.uuidString);
        this.ipAddress = b.ipAddress;
        this.hostName = b.hostName;
        this.ports = b.ports;
        this.certSerialId = b.certSerialId;
        this.version = b.version;
        this.setupTime = b.setupTime;
        this.revision = b.revision;
        this.buildDate = b.buildDate;
        this.persistedOpState = b.persistedOpState;
        this.persistedOpStateExpiryEpochSec = b.persistedOpStateExpiryEpochSec;
        this.initialVersion = b.initialVersion;
        this.currentVersion = b.currentVersion;
        if (b.networkName != null) {
            this.setNetworkName(b.networkName);
        }
        if (b.level > 0) {
            this.setLevel(b.level);
        }
    }

    public DatanodeDetails(DatanodeDetails datanodeDetails) {
        super(datanodeDetails.getHostNameAsByteString(), datanodeDetails.getNetworkLocationAsByteString(), datanodeDetails.getParent(), datanodeDetails.getLevel(), datanodeDetails.getCost());
        this.uuid = datanodeDetails.uuid;
        this.uuidString = datanodeDetails.uuidString;
        this.threadNamePrefix = HddsUtils.threadNamePrefix(this.uuidString);
        this.ipAddress = datanodeDetails.ipAddress;
        this.hostName = datanodeDetails.hostName;
        this.ports = datanodeDetails.ports;
        this.certSerialId = datanodeDetails.certSerialId;
        this.setNetworkName(datanodeDetails.getNetworkNameAsByteString());
        this.setParent(datanodeDetails.getParent());
        this.version = datanodeDetails.version;
        this.setupTime = datanodeDetails.setupTime;
        this.revision = datanodeDetails.revision;
        this.buildDate = datanodeDetails.buildDate;
        this.persistedOpState = datanodeDetails.getPersistedOpState();
        this.persistedOpStateExpiryEpochSec = datanodeDetails.getPersistedOpStateExpiryEpochSec();
        this.initialVersion = datanodeDetails.getInitialVersion();
        this.currentVersion = datanodeDetails.getCurrentVersion();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getUuidString() {
        return this.uuidString.getString();
    }

    public void setIpAddress(String ip) {
        this.ipAddress = StringWithByteString.valueOf(ip);
    }

    public String getIpAddress() {
        return this.ipAddress.getString();
    }

    public StringWithByteString getIpAddressAsByteString() {
        return this.ipAddress;
    }

    public void setHostName(String host) {
        this.hostName = StringWithByteString.valueOf(host);
    }

    public String getHostName() {
        return this.hostName.getString();
    }

    public StringWithByteString getHostNameAsByteString() {
        return this.hostName;
    }

    public synchronized void setPort(Port port) {
        this.ports.remove(port);
        this.ports.add(port);
    }

    public synchronized void setPort(Port.Name name, int port) {
        this.setPort(new Port(name, port));
    }

    public synchronized List<Port> getPorts() {
        return new ArrayList<Port>(this.ports);
    }

    public synchronized boolean hasPort(int port) {
        for (Port p : this.ports) {
            if (p.getValue() != port) continue;
            return true;
        }
        return false;
    }

    public HddsProtos.NodeOperationalState getPersistedOpState() {
        if (this.persistedOpState == null) {
            return HddsProtos.NodeOperationalState.IN_SERVICE;
        }
        return this.persistedOpState;
    }

    public boolean isDecommissioned() {
        return DatanodeDetails.isDecommission(this.getPersistedOpState());
    }

    public static boolean isDecommission(HddsProtos.NodeOperationalState state) {
        return state == HddsProtos.NodeOperationalState.DECOMMISSIONED || state == HddsProtos.NodeOperationalState.DECOMMISSIONING;
    }

    public boolean isMaintenance() {
        return DatanodeDetails.isMaintenance(this.getPersistedOpState());
    }

    public static boolean isMaintenance(HddsProtos.NodeOperationalState state) {
        return state == HddsProtos.NodeOperationalState.IN_MAINTENANCE || state == HddsProtos.NodeOperationalState.ENTERING_MAINTENANCE;
    }

    public void setPersistedOpState(HddsProtos.NodeOperationalState state) {
        this.persistedOpState = state;
    }

    public long getPersistedOpStateExpiryEpochSec() {
        return this.persistedOpStateExpiryEpochSec;
    }

    public void setPersistedOpStateExpiryEpochSec(long expiry) {
        this.persistedOpStateExpiryEpochSec = expiry;
    }

    public synchronized Port getPort(Port.Name name) {
        for (Port port : this.ports) {
            if (!port.getName().equals((Object)name)) continue;
            return port;
        }
        if (name == Port.Name.RATIS_ADMIN || name == Port.Name.RATIS_SERVER || name == Port.Name.RATIS_DATASTREAM) {
            return this.getPort(Port.Name.RATIS);
        }
        return null;
    }

    public static Builder newBuilder(HddsProtos.DatanodeDetailsProto datanodeDetailsProto) {
        Builder builder = DatanodeDetails.newBuilder();
        if (datanodeDetailsProto.hasUuid128()) {
            HddsProtos.UUID uuid = datanodeDetailsProto.getUuid128();
            builder.setUuid(new UUID(uuid.getMostSigBits(), uuid.getLeastSigBits()));
        } else if (datanodeDetailsProto.hasUuid()) {
            builder.setUuid(UUID.fromString(datanodeDetailsProto.getUuid()));
        }
        if (datanodeDetailsProto.hasIpAddress()) {
            builder.setIpAddress(datanodeDetailsProto.getIpAddress(), datanodeDetailsProto.getIpAddressBytes());
        }
        if (datanodeDetailsProto.hasHostName()) {
            builder.setHostName(datanodeDetailsProto.getHostName(), datanodeDetailsProto.getHostNameBytes());
        }
        if (datanodeDetailsProto.hasCertSerialId()) {
            builder.setCertSerialId(datanodeDetailsProto.getCertSerialId());
        }
        for (HddsProtos.Port port : datanodeDetailsProto.getPortsList()) {
            try {
                builder.addPort(Port.fromProto(port));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (datanodeDetailsProto.hasNetworkName()) {
            builder.setNetworkName(datanodeDetailsProto.getNetworkName(), datanodeDetailsProto.getNetworkNameBytes());
        }
        if (datanodeDetailsProto.hasNetworkLocation()) {
            builder.setNetworkLocation(datanodeDetailsProto.getNetworkLocation(), datanodeDetailsProto.getNetworkLocationBytes());
        }
        if (datanodeDetailsProto.hasLevel()) {
            builder.setLevel(datanodeDetailsProto.getLevel());
        }
        if (datanodeDetailsProto.hasPersistedOpState()) {
            builder.setPersistedOpState(datanodeDetailsProto.getPersistedOpState());
        }
        if (datanodeDetailsProto.hasPersistedOpStateExpiry()) {
            builder.setPersistedOpStateExpiry(datanodeDetailsProto.getPersistedOpStateExpiry());
        }
        if (datanodeDetailsProto.hasCurrentVersion()) {
            builder.setCurrentVersion(datanodeDetailsProto.getCurrentVersion());
        } else {
            builder.setCurrentVersion(DatanodeVersion.SEPARATE_RATIS_PORTS_AVAILABLE.toProtoValue());
        }
        return builder;
    }

    public static DatanodeDetails getFromProtoBuf(HddsProtos.DatanodeDetailsProto datanodeDetailsProto) {
        return DatanodeDetails.newBuilder(datanodeDetailsProto).build();
    }

    public static DatanodeDetails getFromProtoBuf(HddsProtos.ExtendedDatanodeDetailsProto extendedDetailsProto) {
        Builder builder = extendedDetailsProto.hasDatanodeDetails() ? DatanodeDetails.newBuilder(extendedDetailsProto.getDatanodeDetails()) : DatanodeDetails.newBuilder();
        if (extendedDetailsProto.hasVersion()) {
            builder.setVersion(extendedDetailsProto.getVersion());
        }
        if (extendedDetailsProto.hasSetupTime()) {
            builder.setSetupTime(extendedDetailsProto.getSetupTime());
        }
        if (extendedDetailsProto.hasRevision()) {
            builder.setRevision(extendedDetailsProto.getRevision());
        }
        if (extendedDetailsProto.hasBuildDate()) {
            builder.setBuildDate(extendedDetailsProto.getBuildDate());
        }
        return builder.build();
    }

    @JsonIgnore
    public HddsProtos.DatanodeDetailsProto getProtoBufMessage() {
        return this.toProto(ClientVersion.CURRENT_VERSION);
    }

    public HddsProtos.DatanodeDetailsProto toProto(int clientVersion) {
        return this.toProtoBuilder(clientVersion).build();
    }

    public HddsProtos.DatanodeDetailsProto.Builder toProtoBuilder(int clientVersion) {
        HddsProtos.UUID uuid128 = HddsProtos.UUID.newBuilder().setMostSigBits(this.uuid.getMostSignificantBits()).setLeastSigBits(this.uuid.getLeastSignificantBits()).build();
        HddsProtos.DatanodeDetailsProto.Builder builder = HddsProtos.DatanodeDetailsProto.newBuilder().setUuid128(uuid128);
        builder.setUuidBytes(this.uuidString.getBytes());
        if (this.ipAddress != null) {
            builder.setIpAddressBytes(this.ipAddress.getBytes());
        }
        if (this.hostName != null) {
            builder.setHostNameBytes(this.hostName.getBytes());
        }
        if (this.certSerialId != null) {
            builder.setCertSerialId(this.certSerialId);
        }
        if (!Strings.isNullOrEmpty(this.getNetworkName())) {
            builder.setNetworkNameBytes(this.getNetworkNameAsByteString().getBytes());
        }
        if (!Strings.isNullOrEmpty(this.getNetworkLocation())) {
            builder.setNetworkLocationBytes(this.getNetworkLocationAsByteString().getBytes());
        }
        if (this.getLevel() > 0) {
            builder.setLevel(this.getLevel());
        }
        if (this.persistedOpState != null) {
            builder.setPersistedOpState(this.persistedOpState);
        }
        builder.setPersistedOpStateExpiry(this.persistedOpStateExpiryEpochSec);
        boolean handlesUnknownPorts = ClientVersion.fromProtoValue(clientVersion).compareTo(ClientVersion.VERSION_HANDLES_UNKNOWN_DN_PORTS) >= 0;
        for (Port port : this.ports) {
            if (handlesUnknownPorts || Port.Name.V0_PORTS.contains((Object)port.getName())) {
                builder.addPorts(port.toProto());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Skip adding {} port {} to proto message for client v{}", new Object[]{port.getName(), port.getValue(), clientVersion});
        }
        builder.setCurrentVersion(this.currentVersion);
        return builder;
    }

    @JsonIgnore
    public HddsProtos.ExtendedDatanodeDetailsProto getExtendedProtoBufMessage() {
        HddsProtos.ExtendedDatanodeDetailsProto.Builder extendedBuilder = HddsProtos.ExtendedDatanodeDetailsProto.newBuilder().setDatanodeDetails(this.getProtoBufMessage());
        if (!Strings.isNullOrEmpty(this.getVersion())) {
            extendedBuilder.setVersion(this.getVersion());
        }
        extendedBuilder.setSetupTime(this.getSetupTime());
        if (!Strings.isNullOrEmpty(this.getRevision())) {
            extendedBuilder.setRevision(this.getRevision());
        }
        if (!Strings.isNullOrEmpty(this.getBuildDate())) {
            extendedBuilder.setBuildDate(this.getBuildDate());
        }
        return extendedBuilder.build();
    }

    public int getInitialVersion() {
        return this.initialVersion;
    }

    public void setInitialVersion(int initialVersion) {
        this.initialVersion = initialVersion;
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(int currentVersion) {
        this.currentVersion = currentVersion;
    }

    @Override
    public String toString() {
        return this.uuidString + "(" + this.hostName + "/" + this.ipAddress + ")";
    }

    public String toDebugString() {
        return this.uuid.toString() + "{ip: " + this.ipAddress + ", host: " + this.hostName + ", ports: " + this.ports + ", networkLocation: " + this.getNetworkLocation() + ", certSerialId: " + this.certSerialId + ", persistedOpState: " + (Object)((Object)this.persistedOpState) + ", persistedOpStateExpiryEpochSec: " + this.persistedOpStateExpiryEpochSec + "}";
    }

    @Override
    public int compareTo(DatanodeDetails that) {
        return this.getUuid().compareTo(that.getUuid());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DatanodeDetails && this.uuid.equals(((DatanodeDetails)obj).uuid);
    }

    public boolean compareNodeValues(DatanodeDetails datanodeDetails) {
        if (this == datanodeDetails || super.equals(datanodeDetails)) {
            return true;
        }
        return Objects.equals(this.ipAddress, datanodeDetails.ipAddress) && Objects.equals(this.hostName, datanodeDetails.hostName) && Objects.equals(this.ports, datanodeDetails.ports);
    }

    @Override
    public int hashCode() {
        return this.uuid.hashCode();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonIgnore
    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public static Port newPort(Port.Name name, Integer value) {
        return new Port(name, value);
    }

    public String getCertSerialId() {
        return this.certSerialId;
    }

    public void setCertSerialId(String certSerialId) {
        this.certSerialId = certSerialId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getSetupTime() {
        return this.setupTime;
    }

    public void setSetupTime(long setupTime) {
        this.setupTime = setupTime;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String rev) {
        this.revision = rev;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(String date) {
        this.buildDate = date;
    }

    @Override
    public HddsProtos.NetworkNode toProtobuf(int clientVersion) {
        return HddsProtos.NetworkNode.newBuilder().setDatanodeDetails(this.toProtoBuilder(clientVersion).build()).build();
    }

    public static final class Port {
        private final Name name;
        private final Integer value;

        private Port(Name name, Integer value) {
            this.name = name;
            this.value = value;
        }

        public Name getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof Port) {
                return this.name.equals((Object)((Port)anObject).name);
            }
            return false;
        }

        public String toString() {
            return (Object)((Object)this.name) + "=" + this.value;
        }

        public HddsProtos.Port toProto() {
            return HddsProtos.Port.newBuilder().setName(this.name.name()).setValue(this.value).build();
        }

        public static Port fromProto(HddsProtos.Port proto) {
            Name name = Name.valueOf(proto.getName().toUpperCase());
            return new Port(name, proto.getValue());
        }

        public static enum Name {
            STANDALONE,
            RATIS,
            REST,
            REPLICATION,
            RATIS_ADMIN,
            RATIS_SERVER,
            RATIS_DATASTREAM,
            HTTP,
            HTTPS,
            CLIENT_RPC;

            public static final Set<Name> ALL_PORTS;
            public static final Set<Name> V0_PORTS;

            static {
                ALL_PORTS = ImmutableSet.copyOf(Name.values());
                V0_PORTS = ImmutableSet.copyOf(EnumSet.of(STANDALONE, RATIS, REST));
            }
        }
    }

    public static final class Builder {
        private UUID id;
        private StringWithByteString ipAddress;
        private StringWithByteString hostName;
        private StringWithByteString networkName;
        private StringWithByteString networkLocation;
        private int level;
        private List<Port> ports;
        private String certSerialId;
        private String version;
        private long setupTime;
        private String revision;
        private String buildDate;
        private HddsProtos.NodeOperationalState persistedOpState;
        private long persistedOpStateExpiryEpochSec = 0L;
        private int initialVersion;
        private int currentVersion = DatanodeVersion.CURRENT_VERSION;

        private Builder() {
            this.ports = new ArrayList<Port>();
        }

        public Builder setDatanodeDetails(DatanodeDetails details) {
            this.id = details.getUuid();
            this.ipAddress = details.getIpAddressAsByteString();
            this.hostName = details.getHostNameAsByteString();
            this.networkName = details.getHostNameAsByteString();
            this.networkLocation = details.getNetworkLocationAsByteString();
            this.level = details.getLevel();
            this.ports = details.getPorts();
            this.certSerialId = details.getCertSerialId();
            this.version = details.getVersion();
            this.setupTime = details.getSetupTime();
            this.revision = details.getRevision();
            this.buildDate = details.getBuildDate();
            this.persistedOpState = details.getPersistedOpState();
            this.persistedOpStateExpiryEpochSec = details.getPersistedOpStateExpiryEpochSec();
            return this;
        }

        public Builder setUuid(UUID uuid) {
            this.id = uuid;
            return this;
        }

        public Builder setIpAddress(String ip) {
            this.ipAddress = StringWithByteString.valueOf(ip);
            return this;
        }

        public Builder setIpAddress(String ip, ByteString ipBytes) {
            this.ipAddress = new StringWithByteString(ip, ipBytes);
            return this;
        }

        public Builder setHostName(String host) {
            this.hostName = StringWithByteString.valueOf(host);
            return this;
        }

        public Builder setHostName(String host, ByteString hostBytes) {
            this.hostName = new StringWithByteString(host, hostBytes);
            return this;
        }

        public Builder setNetworkName(String name, ByteString nameBytes) {
            this.networkName = new StringWithByteString(name, nameBytes);
            return this;
        }

        public Builder setNetworkLocation(String loc) {
            return this.setNetworkLocation(loc, null);
        }

        public Builder setNetworkLocation(String loc, ByteString locBytes) {
            String normalized = NetUtils.normalize(loc);
            this.networkLocation = normalized.equals(loc) && locBytes != null ? new StringWithByteString(normalized, locBytes) : StringWithByteString.valueOf(normalized);
            return this;
        }

        public Builder setLevel(int level) {
            this.level = level;
            return this;
        }

        public Builder addPort(Port port) {
            this.ports.add(port);
            return this;
        }

        public Builder setCertSerialId(String certId) {
            this.certSerialId = certId;
            return this;
        }

        public Builder setVersion(String ver) {
            this.version = ver;
            return this;
        }

        public Builder setRevision(String rev) {
            this.revision = rev;
            return this;
        }

        public Builder setBuildDate(String date) {
            this.buildDate = date;
            return this;
        }

        public Builder setSetupTime(long time) {
            this.setupTime = time;
            return this;
        }

        public Builder setPersistedOpState(HddsProtos.NodeOperationalState state) {
            this.persistedOpState = state;
            return this;
        }

        public Builder setPersistedOpStateExpiry(long expiry) {
            this.persistedOpStateExpiryEpochSec = expiry;
            return this;
        }

        public Builder setInitialVersion(int v) {
            this.initialVersion = v;
            return this;
        }

        public Builder setCurrentVersion(int v) {
            this.currentVersion = v;
            return this;
        }

        public DatanodeDetails build() {
            Preconditions.checkNotNull(this.id);
            if (this.networkLocation == null || this.networkLocation.getString().isEmpty()) {
                this.networkLocation = NetConstants.BYTE_STRING_DEFAULT_RACK;
            }
            return new DatanodeDetails(this);
        }
    }
}

