/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;

public final class DefaultConfigManager {
    private static final Map<String, Object> CONFIG_DEFAULT_MAP = new HashMap<String, Object>();

    private DefaultConfigManager() {
    }

    public static <T> void setConfigValue(String config, T value) {
        T prevValue = DefaultConfigManager.getValue(config, value);
        if (!value.equals(prevValue)) {
            throw new ConfigurationException(String.format("Setting conflicting Default Configs old default Value: %s New Default Value:%s", prevValue.toString(), value.toString()));
        }
        CONFIG_DEFAULT_MAP.putIfAbsent(config, value);
    }

    public static <T> T getValue(String config, T defaultValue) {
        return (T)CONFIG_DEFAULT_MAP.getOrDefault(config, defaultValue);
    }

    public static <T> void forceUpdateConfigValue(String config, T value) {
        CONFIG_DEFAULT_MAP.put(config, value);
    }

    @VisibleForTesting
    public static void clearDefaultConfigs() {
        CONFIG_DEFAULT_MAP.clear();
    }
}

