/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.cli;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.cli.MissingSubcommandException;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;

public class GenericCli
implements Callable<Void>,
GenericParentCommand {
    public static final int EXECUTION_ERROR_EXIT_CODE = -1;
    private final OzoneConfiguration config = new OzoneConfiguration();
    @CommandLine.Option(names={"--verbose"}, description={"More verbose output. Show the stack trace of the errors."})
    private boolean verbose;
    @CommandLine.Option(names={"-conf"})
    private String configurationPath;
    private final CommandLine cmd = new CommandLine(this);

    @CommandLine.Option(names={"-D", "--set"})
    public void setConfigurationOverrides(Map<String, String> configOverrides) {
        configOverrides.forEach((arg_0, arg_1) -> ((OzoneConfiguration)this.config).set(arg_0, arg_1));
    }

    public GenericCli() {
        this.cmd.setExecutionExceptionHandler((ex, commandLine, parseResult) -> {
            this.printError(ex);
            return -1;
        });
    }

    public GenericCli(Class<?> type) {
        this();
        this.addSubcommands(this.getCmd(), type);
    }

    private void addSubcommands(CommandLine cli, Class<?> type) {
        ServiceLoader<SubcommandWithParent> registeredSubcommands = ServiceLoader.load(SubcommandWithParent.class);
        for (SubcommandWithParent subcommand : registeredSubcommands) {
            if (!subcommand.getParentType().equals(type)) continue;
            CommandLine.Command commandAnnotation = subcommand.getClass().getAnnotation(CommandLine.Command.class);
            CommandLine subcommandCommandLine = new CommandLine(subcommand);
            this.addSubcommands(subcommandCommandLine, subcommand.getClass());
            cli.addSubcommand(commandAnnotation.name(), subcommandCommandLine);
        }
    }

    public static void missingSubcommand(CommandLine.Model.CommandSpec spec) {
        System.err.println("Incomplete command");
        spec.commandLine().usage(System.err);
        System.exit(-1);
    }

    public void run(String[] argv) {
        int exitCode = this.execute(argv);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    @VisibleForTesting
    public int execute(String[] argv) {
        return this.cmd.execute(argv);
    }

    protected void printError(Throwable error) {
        if (this.verbose || error.getMessage() == null || error.getMessage().length() == 0) {
            error.printStackTrace(System.err);
        } else {
            System.err.println(error.getMessage().split("\n")[0]);
        }
    }

    @Override
    public Void call() throws Exception {
        throw new MissingSubcommandException(this.cmd);
    }

    @Override
    public OzoneConfiguration createOzoneConfiguration() {
        if (this.configurationPath != null) {
            this.config.addResource(new Path(this.configurationPath));
        }
        return this.config;
    }

    @VisibleForTesting
    public CommandLine getCmd() {
        return this.cmd;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }
}

