/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathPermissionException;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.ozone.BasicKeyInfo;
import org.apache.hadoop.fs.ozone.BasicRootedOzoneFileSystem;
import org.apache.hadoop.fs.ozone.FileStatusAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientUtils;
import org.apache.hadoop.fs.ozone.OzoneFSDataStreamOutput;
import org.apache.hadoop.fs.ozone.OzoneFSOutputStream;
import org.apache.hadoop.fs.ozone.Statistic;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.client.ReplicatedReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OFSPath;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneSnapshot;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneDataStreamOutput;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.client.rpc.RpcClient;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BasicOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.LeaseKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatusLight;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffReportOzone;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRootedOzoneClientAdapterImpl
implements OzoneClientAdapter {
    static final Logger LOG = LoggerFactory.getLogger(BasicRootedOzoneClientAdapterImpl.class);
    private OzoneClient ozoneClient;
    private ObjectStore objectStore;
    private ClientProtocol proxy;
    private ReplicationConfig clientConfiguredReplicationConfig;
    private boolean securityEnabled;
    private int configuredDnPort;
    private BucketLayout defaultOFSBucketLayout;
    private OzoneConfiguration config;

    public BasicRootedOzoneClientAdapterImpl() throws IOException {
        this(BasicRootedOzoneClientAdapterImpl.createConf());
    }

    private static OzoneConfiguration createConf() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(null);
        try {
            OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
            return ozoneConfiguration;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public BasicRootedOzoneClientAdapterImpl(OzoneConfiguration conf) throws IOException {
        this(null, -1, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRootedOzoneClientAdapterImpl(String omHost, int omPort, ConfigurationSource hadoopConf) throws IOException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(null);
        try {
            SecurityConfig secConfig;
            OzoneConfiguration conf = OzoneConfiguration.of(hadoopConf);
            if (omHost == null && OmUtils.isServiceIdsDefined(conf)) {
                throw new IllegalArgumentException("Service ID or host name must not be omitted when ozone.om.service.ids is defined.");
            }
            if (omPort != -1) {
                if (OmUtils.isOmHAServiceId(conf, omHost)) {
                    throw new IllegalArgumentException("Port " + omPort + " specified in URI but host '" + omHost + "' is a logical (HA) OzoneManager and does not use port information.");
                }
            } else {
                omPort = OmUtils.getOmRpcPort(conf);
            }
            if ((secConfig = new SecurityConfig(conf)).isSecurityEnabled()) {
                this.securityEnabled = true;
            }
            this.clientConfiguredReplicationConfig = OzoneClientUtils.getClientConfiguredReplicationConfig(conf);
            this.ozoneClient = OmUtils.isOmHAServiceId(conf, omHost) ? OzoneClientFactory.getRpcClient(omHost, (ConfigurationSource)conf) : (StringUtils.isNotEmpty(omHost) && omPort != -1 ? OzoneClientFactory.getRpcClient(omHost, omPort, conf) : OzoneClientFactory.getRpcClient(conf));
            this.objectStore = this.ozoneClient.getObjectStore();
            this.proxy = this.objectStore.getClientProxy();
            this.configuredDnPort = conf.getInt("hdds.container.ipc.port", 9859);
            this.initDefaultFsBucketLayout(conf);
            this.config = conf;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void initDefaultFsBucketLayout(OzoneConfiguration conf) throws OMException {
        try {
            this.defaultOFSBucketLayout = BucketLayout.fromString(conf.get("ozone.client.fs.default.bucket.layout", "FILE_SYSTEM_OPTIMIZED"));
        }
        catch (IllegalArgumentException iae) {
            throw new OMException("Unsupported value provided for ozone.client.fs.default.bucket.layout. Supported values are " + (Object)((Object)BucketLayout.FILE_SYSTEM_OPTIMIZED) + " and " + (Object)((Object)BucketLayout.LEGACY) + ".", OMException.ResultCodes.INVALID_REQUEST);
        }
        if (this.defaultOFSBucketLayout.equals((Object)BucketLayout.OBJECT_STORE)) {
            throw new OMException("Buckets created with OBJECT_STORE layout do not support file system semantics. Supported values for config ozone.client.fs.default.bucket.layout include " + (Object)((Object)BucketLayout.FILE_SYSTEM_OPTIMIZED) + " and " + (Object)((Object)BucketLayout.LEGACY), OMException.ResultCodes.INVALID_REQUEST);
        }
    }

    OzoneBucket getBucket(OFSPath ofsPath, boolean createIfNotExist) throws IOException {
        return this.getBucket(ofsPath.getVolumeName(), ofsPath.getBucketName(), createIfNotExist);
    }

    /*
     * Unable to fully structure code
     */
    private OzoneBucket getBucket(String volumeStr, String bucketStr, boolean createIfNotExist) throws IOException {
        Preconditions.checkNotNull(volumeStr);
        Preconditions.checkNotNull(bucketStr);
        if (bucketStr.isEmpty()) {
            throw new FileNotFoundException("getBucket: Invalid argument: given bucket string is empty.");
        }
        try {
            bucket = this.proxy.getBucketDetails(volumeStr, bucketStr);
            resolvedBucketLayout = OzoneClientUtils.resolveLinkBucketLayout(bucket, this.objectStore, new HashSet<Pair<String, String>>());
            OzoneFSUtils.validateBucketLayout(bucket.getName(), resolvedBucketLayout);
        }
        catch (OMException ex) {
            block11: {
                if (!createIfNotExist) break block11;
                switch (1.$SwitchMap$org$apache$hadoop$ozone$om$exceptions$OMException$ResultCodes[ex.getResult().ordinal()]) {
                    case 1: {
                        try {
                            this.objectStore.createVolume(volumeStr);
                        }
                        catch (OMException newVolEx) {
                            if (newVolEx.getResult().equals((Object)OMException.ResultCodes.VOLUME_ALREADY_EXISTS)) ** GOTO lbl22
                            throw newVolEx;
                        }
                    }
lbl22:
                    // 3 sources

                    case 2: {
                        volume = this.proxy.getVolumeDetails(volumeStr);
                        try {
                            volume.createBucket(bucketStr, BucketArgs.newBuilder().setBucketLayout(this.defaultOFSBucketLayout).build());
                            break;
                        }
                        catch (OMException newBucEx) {
                            if (newBucEx.getResult().equals((Object)OMException.ResultCodes.BUCKET_ALREADY_EXISTS)) break;
                            throw newBucEx;
                        }
                    }
                    default: {
                        throw ex;
                    }
                }
                bucket = this.proxy.getBucketDetails(volumeStr, bucketStr);
            }
            throw ex;
        }
        return bucket;
    }

    @Override
    public short getDefaultReplication() {
        if (this.clientConfiguredReplicationConfig == null) {
            return (short)ReplicationFactor.THREE.getValue();
        }
        return (short)this.clientConfiguredReplicationConfig.getRequiredNodes();
    }

    @Override
    public void close() throws IOException {
        this.ozoneClient.close();
    }

    @Override
    public InputStream readFile(String pathStr) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_READ, 1L);
        OFSPath ofsPath = new OFSPath(pathStr, this.config);
        String key = ofsPath.getKeyName();
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, false);
            return bucket.readFile(key).getInputStream();
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.FILE_NOT_FOUND || ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND || ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileNotFoundException(ex.getResult().name() + ": " + ex.getMessage());
            }
            throw ex;
        }
    }

    protected void incrementCounter(Statistic objectsRead, long count) {
    }

    @Override
    public OzoneFSOutputStream createFile(String pathStr, short replication, boolean overWrite, boolean recursive) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_CREATED, 1L);
        OFSPath ofsPath = new OFSPath(pathStr, this.config);
        if (ofsPath.isRoot() || ofsPath.isVolume() || ofsPath.isBucket()) {
            throw new IOException("Cannot create file under root or volume.");
        }
        String key = ofsPath.getKeyName();
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, recursive);
            OzoneOutputStream ozoneOutputStream = bucket.createFile(key, 0L, OzoneClientUtils.resolveClientSideReplicationConfig(replication, this.clientConfiguredReplicationConfig, bucket.getReplicationConfig(), this.config), overWrite, recursive);
            return new OzoneFSOutputStream(ozoneOutputStream);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.FILE_ALREADY_EXISTS || ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileAlreadyExistsException(ex.getResult().name() + ": " + ex.getMessage());
            }
            throw ex;
        }
    }

    @Override
    public OzoneFSDataStreamOutput createStreamFile(String pathStr, short replication, boolean overWrite, boolean recursive) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_CREATED, 1L);
        OFSPath ofsPath = new OFSPath(pathStr, this.config);
        if (ofsPath.isRoot() || ofsPath.isVolume() || ofsPath.isBucket()) {
            throw new IOException("Cannot create file under root or volume.");
        }
        String key = ofsPath.getKeyName();
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, recursive);
            ReplicationConfig replicationConfig = OzoneClientUtils.resolveClientSideReplicationConfig(replication, this.clientConfiguredReplicationConfig, bucket.getReplicationConfig(), this.config);
            OzoneDataStreamOutput out = bucket.createStreamFile(key, 0L, replicationConfig, overWrite, recursive);
            return new OzoneFSDataStreamOutput(out.getByteBufStreamOutput());
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.FILE_ALREADY_EXISTS || ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileAlreadyExistsException(ex.getResult().name() + ": " + ex.getMessage());
            }
            throw ex;
        }
    }

    @Override
    public void renameKey(String key, String newKeyName) throws IOException {
        throw new IOException("OFS doesn't support renameKey, use rename instead.");
    }

    @Override
    public void rename(String path, String newPath) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_RENAMED, 1L);
        OFSPath ofsPath = new OFSPath(path, this.config);
        OFSPath ofsNewPath = new OFSPath(newPath, this.config);
        if (!ofsPath.isInSameBucketAs(ofsNewPath)) {
            throw new IOException("Can't rename a key to a different bucket.");
        }
        OzoneBucket bucket = this.getBucket(ofsPath, false);
        String key = ofsPath.getKeyName();
        String newKey = ofsNewPath.getKeyName();
        bucket.renameKey(key, newKey);
    }

    void rename(OzoneBucket bucket, String path, String newPath) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_RENAMED, 1L);
        OFSPath ofsPath = new OFSPath(path, this.config);
        OFSPath ofsNewPath = new OFSPath(newPath, this.config);
        String key = ofsPath.getKeyName();
        String newKey = ofsNewPath.getKeyName();
        bucket.renameKey(key, newKey);
    }

    @Override
    public boolean createDirectory(String pathStr) throws IOException {
        LOG.trace("creating dir for path: {}", (Object)pathStr);
        this.incrementCounter(Statistic.OBJECTS_CREATED, 1L);
        OFSPath ofsPath = new OFSPath(pathStr, this.config);
        if (ofsPath.getVolumeName().isEmpty()) {
            return false;
        }
        if (ofsPath.getBucketName().isEmpty()) {
            this.objectStore.createVolume(ofsPath.getVolumeName());
            return true;
        }
        String keyStr = ofsPath.getKeyName();
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, true);
            if (keyStr != null && keyStr.length() > 0) {
                bucket.createDirectory(keyStr);
            }
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_ALREADY_EXISTS) {
                throw new FileAlreadyExistsException(e.getMessage());
            }
            throw e;
        }
        return true;
    }

    @Override
    public boolean deleteObject(String path, boolean recursive) throws IOException {
        LOG.trace("issuing delete for path to key: {}", (Object)path);
        this.incrementCounter(Statistic.OBJECTS_DELETED, 1L);
        OFSPath ofsPath = new OFSPath(path, this.config);
        String keyName = ofsPath.getKeyName();
        if (keyName.length() == 0) {
            return false;
        }
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, false);
            bucket.deleteDirectory(keyName, recursive);
            return true;
        }
        catch (OMException ome) {
            LOG.error("Delete key failed. {}", (Object)ome.getMessage());
            if (OMException.ResultCodes.DIRECTORY_NOT_EMPTY == ome.getResult()) {
                throw new PathIsNotEmptyDirectoryException(ome.getMessage());
            }
            if (OMException.ResultCodes.INVALID_KEY_NAME == ome.getResult()) {
                throw new PathPermissionException(ome.getMessage());
            }
            return false;
        }
        catch (IOException ioe) {
            LOG.error("Delete key failed. {}", (Object)ioe.getMessage());
            return false;
        }
    }

    @Override
    public boolean deleteObject(String path) throws IOException {
        return this.deleteObject(path, false);
    }

    private boolean areInSameBucket(List<String> keyNameList) {
        if (keyNameList.isEmpty()) {
            return true;
        }
        String firstKeyPath = keyNameList.get(0);
        String volAndBucket = new OFSPath(firstKeyPath, this.config).getNonKeyPath();
        return keyNameList.stream().skip(1L).allMatch(p -> new OFSPath((String)p, this.config).getNonKeyPath().equals(volAndBucket));
    }

    @Override
    public boolean deleteObjects(List<String> keyNameList) {
        if (keyNameList.size() == 0) {
            return true;
        }
        if (!this.areInSameBucket(keyNameList)) {
            LOG.error("Deleting keys from different buckets in a single batch is not supported.");
            return false;
        }
        try {
            OFSPath firstKeyPath = new OFSPath(keyNameList.get(0), this.config);
            OzoneBucket bucket = this.getBucket(firstKeyPath, false);
            return this.deleteObjects(bucket, keyNameList);
        }
        catch (IOException ioe) {
            LOG.error("delete key failed: {}", (Object)ioe.getMessage());
            return false;
        }
    }

    boolean deleteObjects(OzoneBucket bucket, List<String> keyNameList) {
        List<String> keyList = keyNameList.stream().map(p -> new OFSPath((String)p, this.config).getKeyName()).collect(Collectors.toList());
        try {
            this.incrementCounter(Statistic.OBJECTS_DELETED, keyNameList.size());
            bucket.deleteKeys(keyList);
            return true;
        }
        catch (IOException ioe) {
            LOG.error("delete key failed: {}", (Object)ioe.getMessage());
            return false;
        }
    }

    @Override
    public FileStatusAdapter getFileStatus(String path, URI uri, Path qualifiedPath, String userName) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_QUERY, 1L);
        OFSPath ofsPath = new OFSPath(path, this.config);
        if (ofsPath.isRoot()) {
            return BasicRootedOzoneClientAdapterImpl.getFileStatusAdapterForRoot(uri);
        }
        if (ofsPath.isVolume()) {
            OzoneVolume volume = this.objectStore.getVolume(ofsPath.getVolumeName());
            return BasicRootedOzoneClientAdapterImpl.getFileStatusAdapterForVolume(volume, uri);
        }
        return this.getFileStatusForKeyOrSnapshot(ofsPath, uri, qualifiedPath, userName);
    }

    private FileStatusAdapter getFileStatusForKeyOrSnapshot(OFSPath ofsPath, URI uri, Path qualifiedPath, String userName) throws IOException {
        String volumeName = ofsPath.getVolumeName();
        String bucketName = ofsPath.getBucketName();
        String key = ofsPath.getKeyName();
        try {
            if (ofsPath.isSnapshotPath()) {
                OzoneVolume volume = this.objectStore.getVolume(volumeName);
                OzoneBucket bucket = this.getBucket(volumeName, bucketName, false);
                return BasicRootedOzoneClientAdapterImpl.getFileStatusAdapterWithSnapshotIndicator(volume, bucket, uri);
            }
            OzoneFileStatus status = this.proxy.getOzoneFileStatus(volumeName, bucketName, key);
            return this.toFileStatusAdapter(status, userName, uri, qualifiedPath, ofsPath.getNonKeyPath());
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                throw new FileNotFoundException(key + ": No such file or directory!");
            }
            if (e.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw new FileNotFoundException(key + ": Bucket doesn't exist!");
            }
            throw e;
        }
    }

    public Collection<FileStatus> getTrashRoots(boolean allUsers, BasicRootedOzoneFileSystem fs) {
        ArrayList<FileStatus> ret = new ArrayList<FileStatus>();
        try {
            String username = UserGroupInformation.getCurrentUser().getShortUserName();
            Iterator<? extends OzoneVolume> iterVol = allUsers ? this.objectStore.listVolumes("") : this.objectStore.listVolumesByUser(username, "", "");
            while (iterVol.hasNext()) {
                OzoneVolume volume = iterVol.next();
                Path volumePath = new Path("/", volume.getName());
                Iterator<? extends OzoneBucket> bucketIter = volume.listBuckets("");
                while (bucketIter.hasNext()) {
                    OzoneBucket bucket = bucketIter.next();
                    Path bucketPath = new Path(volumePath, bucket.getName());
                    Path trashRoot = new Path(bucketPath, ".Trash");
                    if (allUsers) {
                        if (!fs.exists(trashRoot)) continue;
                        for (FileStatus candidate : fs.listStatus(trashRoot)) {
                            if (!fs.exists(candidate.getPath()) || !candidate.isDirectory()) continue;
                            ret.add(candidate);
                        }
                        continue;
                    }
                    Path userTrash = new Path(trashRoot, username);
                    if (!fs.exists(userTrash) || !fs.getFileStatus(userTrash).isDirectory()) continue;
                    ret.add(fs.getFileStatus(userTrash));
                }
            }
        }
        catch (IOException ex) {
            LOG.warn("Can't get all trash roots", (Throwable)ex);
            return Collections.emptyList();
        }
        return ret;
    }

    @Override
    public Iterator<BasicKeyInfo> listKeys(String pathStr) throws IOException {
        OzoneBucket bucket;
        this.incrementCounter(Statistic.OBJECTS_LIST, 1L);
        OFSPath ofsPath = new OFSPath(pathStr, this.config);
        String key = ofsPath.getKeyName();
        try {
            bucket = this.getBucket(ofsPath, false);
        }
        catch (IOException ex) {
            return new IteratorAdapter(Collections.emptyIterator());
        }
        return new IteratorAdapter(bucket.listKeys(key));
    }

    private List<FileStatusAdapter> listStatusRoot(boolean recursive, String startPath, long numEntries, URI uri, Path workingDir, String username, boolean lite) throws IOException {
        OFSPath ofsStartPath = new OFSPath(startPath, this.config);
        Iterator<? extends OzoneVolume> iter = this.objectStore.listVolumesByUser(username, null, ofsStartPath.getVolumeName());
        ArrayList<FileStatusAdapter> res = new ArrayList<FileStatusAdapter>();
        while (iter.hasNext() && (long)res.size() < numEntries) {
            OzoneVolume volume = iter.next();
            res.add(BasicRootedOzoneClientAdapterImpl.getFileStatusAdapterForVolume(volume, uri));
            if (!recursive) continue;
            String pathStrNextVolume = volume.getName();
            res.addAll(this.listStatus(pathStrNextVolume, recursive, startPath, numEntries - (long)res.size(), uri, workingDir, username, lite));
        }
        return res;
    }

    private List<FileStatusAdapter> listStatusVolume(String volumeStr, boolean recursive, String startPath, long numEntries, URI uri, Path workingDir, String username, boolean lite) throws IOException {
        OFSPath ofsStartPath = new OFSPath(startPath, this.config);
        OzoneVolume volume = this.objectStore.getVolume(volumeStr);
        Iterator<? extends OzoneBucket> iter = volume.listBuckets(null, ofsStartPath.getBucketName());
        ArrayList<FileStatusAdapter> res = new ArrayList<FileStatusAdapter>();
        while (iter.hasNext() && (long)res.size() < numEntries) {
            OzoneBucket bucket = iter.next();
            res.add(BasicRootedOzoneClientAdapterImpl.getFileStatusAdapterForBucket(bucket, uri));
            if (!recursive) continue;
            String pathStrNext = volumeStr + "/" + bucket.getName();
            res.addAll(this.listStatus(pathStrNext, recursive, startPath, numEntries - (long)res.size(), uri, workingDir, username, lite));
        }
        return res;
    }

    private List<FileStatusAdapter> listStatusBucketSnapshot(String volumeName, String bucketName, URI uri) throws IOException {
        OzoneBucket ozoneBucket = this.getBucket(volumeName, bucketName, false);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)ozoneBucket.getOwner());
        String owner = ugi.getShortUserName();
        String group = BasicRootedOzoneClientAdapterImpl.getGroupName(ugi);
        ArrayList<FileStatusAdapter> res = new ArrayList<FileStatusAdapter>();
        Iterator<OzoneSnapshot> snapshotIter = this.objectStore.listSnapshot(volumeName, bucketName, null, null);
        while (snapshotIter.hasNext()) {
            OzoneSnapshot ozoneSnapshot = snapshotIter.next();
            if (!SnapshotInfo.SnapshotStatus.SNAPSHOT_ACTIVE.name().equals(ozoneSnapshot.getSnapshotStatus())) continue;
            res.add(BasicRootedOzoneClientAdapterImpl.getFileStatusAdapterForBucketSnapshot(ozoneBucket, ozoneSnapshot, uri, owner, group));
        }
        return res;
    }

    @Override
    public List<FileStatusAdapter> listStatus(String pathStr, boolean recursive, String startPath, long numEntries, URI uri, Path workingDir, String username, boolean lite) throws IOException {
        OFSPath ofsPath;
        this.incrementCounter(Statistic.OBJECTS_LIST, 1L);
        if (startPath.startsWith(uri.toString())) {
            try {
                startPath = new URI(startPath).getPath();
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
        if ((ofsPath = new OFSPath(pathStr, this.config)).isRoot()) {
            return this.listStatusRoot(recursive, startPath, numEntries, uri, workingDir, username, lite);
        }
        OFSPath ofsStartPath = new OFSPath(startPath, this.config);
        if (ofsPath.isVolume()) {
            String startBucketPath = ofsStartPath.getNonKeyPath();
            return this.listStatusVolume(ofsPath.getVolumeName(), recursive, startBucketPath, numEntries, uri, workingDir, username, lite);
        }
        if (ofsPath.isSnapshotPath()) {
            return this.listStatusBucketSnapshot(ofsPath.getVolumeName(), ofsPath.getBucketName(), uri);
        }
        ArrayList<FileStatusAdapter> result = new ArrayList<FileStatusAdapter>();
        String keyName = ofsPath.getKeyName();
        String startKey = ofsStartPath.getKeyName();
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, false);
            List<Object> statuses = Collections.emptyList();
            List<Object> lightStatuses = Collections.emptyList();
            if (bucket.isSourcePathExist()) {
                if (lite) {
                    lightStatuses = bucket.listStatusLight(keyName, recursive, startKey, numEntries);
                } else {
                    statuses = bucket.listStatus(keyName, recursive, startKey, numEntries);
                }
            } else {
                LOG.warn("Source Bucket does not exist, link bucket {} is orphan and returning empty list of files inside it", (Object)bucket.getName());
            }
            String ofsPathPrefix = ofsPath.getNonKeyPath();
            if (lite) {
                for (OzoneFileStatusLight ozoneFileStatusLight : lightStatuses) {
                    result.add(this.toFileStatusAdapter(ozoneFileStatusLight, username, uri, workingDir, ofsPathPrefix));
                }
            } else {
                for (OzoneFileStatus ozoneFileStatus : statuses) {
                    result.add(this.toFileStatusAdapter(ozoneFileStatus, username, uri, workingDir, ofsPathPrefix));
                }
            }
            return result;
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                throw new FileNotFoundException(e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public Token<OzoneTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        if (!this.securityEnabled) {
            return null;
        }
        Token<OzoneTokenIdentifier> token = this.ozoneClient.getObjectStore().getDelegationToken(renewer == null ? null : new Text(renewer));
        token.setKind(OzoneTokenIdentifier.KIND_NAME);
        return token;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    @Override
    public KeyProvider getKeyProvider() throws IOException {
        return this.objectStore.getKeyProvider();
    }

    @Override
    public URI getKeyProviderUri() throws IOException {
        return this.objectStore.getKeyProviderUri();
    }

    @Override
    public String getCanonicalServiceName() {
        return this.objectStore.getCanonicalServiceName();
    }

    private FileStatusAdapter toFileStatusAdapter(OzoneFileStatus status, String owner, URI defaultUri, Path workingDir, String ofsPathPrefix) {
        OmKeyInfo keyInfo = status.getKeyInfo();
        short replication = (short)keyInfo.getReplicationConfig().getRequiredNodes();
        return new FileStatusAdapter(keyInfo.getDataSize(), keyInfo.getReplicatedSize(), new Path(ofsPathPrefix + "/" + keyInfo.getKeyName()).makeQualified(defaultUri, workingDir), status.isDirectory(), replication, status.getBlockSize(), keyInfo.getModificationTime(), keyInfo.getModificationTime(), status.isDirectory() ? (short)511 : 438, StringUtils.defaultIfEmpty(keyInfo.getOwnerName(), owner), owner, null, this.getBlockLocations(status), OzoneClientUtils.isKeyEncrypted(keyInfo), OzoneClientUtils.isKeyErasureCode(keyInfo));
    }

    private FileStatusAdapter toFileStatusAdapter(OzoneFileStatusLight status, String owner, URI defaultUri, Path workingDir, String ofsPathPrefix) {
        BasicOmKeyInfo keyInfo = status.getKeyInfo();
        short replication = (short)keyInfo.getReplicationConfig().getRequiredNodes();
        return new FileStatusAdapter(keyInfo.getDataSize(), keyInfo.getReplicatedSize(), new Path(ofsPathPrefix + "/" + keyInfo.getKeyName()).makeQualified(defaultUri, workingDir), status.isDirectory(), replication, status.getBlockSize(), keyInfo.getModificationTime(), keyInfo.getModificationTime(), status.isDirectory() ? (short)511 : 438, StringUtils.defaultIfEmpty(keyInfo.getOwnerName(), owner), owner, null, this.getBlockLocations(null), false, OzoneClientUtils.isKeyErasureCode(keyInfo));
    }

    private BlockLocation[] getBlockLocations(OzoneFileStatus fileStatus) {
        if (fileStatus == null) {
            return new BlockLocation[0];
        }
        OmKeyInfo keyInfo = fileStatus.getKeyInfo();
        if (keyInfo == null || CollectionUtils.isEmpty(keyInfo.getKeyLocationVersions())) {
            return new BlockLocation[0];
        }
        List<OmKeyLocationInfoGroup> omKeyLocationInfoGroups = keyInfo.getKeyLocationVersions();
        if (CollectionUtils.isEmpty(omKeyLocationInfoGroups)) {
            return new BlockLocation[0];
        }
        OmKeyLocationInfoGroup omKeyLocationInfoGroup = keyInfo.getLatestVersionLocations();
        BlockLocation[] blockLocations = new BlockLocation[omKeyLocationInfoGroup.getBlocksLatestVersionOnly().size()];
        int i = 0;
        long offsetOfBlockInFile = 0L;
        for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoGroup.getBlocksLatestVersionOnly()) {
            ArrayList hostList = new ArrayList();
            ArrayList nameList = new ArrayList();
            omKeyLocationInfo.getPipeline().getNodes().forEach(dn -> {
                hostList.add(dn.getHostName());
                int port = dn.getPort(DatanodeDetails.Port.Name.STANDALONE).getValue();
                if (port == 0) {
                    port = this.configuredDnPort;
                }
                nameList.add(dn.getHostName() + ":" + port);
            });
            String[] hosts = hostList.toArray(new String[hostList.size()]);
            String[] names = nameList.toArray(new String[nameList.size()]);
            BlockLocation blockLocation = new BlockLocation(names, hosts, offsetOfBlockInFile, omKeyLocationInfo.getLength());
            offsetOfBlockInFile += omKeyLocationInfo.getLength();
            blockLocations[i++] = blockLocation;
        }
        return blockLocations;
    }

    private static String getGroupName(UserGroupInformation ugi) {
        try {
            return ugi.getPrimaryGroupName();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    private static FileStatusAdapter getFileStatusAdapterForVolume(OzoneVolume ozoneVolume, URI uri) {
        String pathStr = uri.toString() + "/" + ozoneVolume.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatusAdapterForVolume: ozoneVolume={}, pathStr={}", (Object)ozoneVolume.getName(), (Object)pathStr);
        }
        Path path = new Path(pathStr);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)ozoneVolume.getOwner());
        String owner = ugi.getShortUserName();
        String group = BasicRootedOzoneClientAdapterImpl.getGroupName(ugi);
        return new FileStatusAdapter(0L, 0L, path, true, 0, 0L, ozoneVolume.getCreationTime().getEpochSecond() * 1000L, 0L, FsPermission.getDirDefault().toShort(), owner, group, null, new BlockLocation[0], false, false);
    }

    private static FileStatusAdapter getFileStatusAdapterForBucket(OzoneBucket ozoneBucket, URI uri) {
        String pathStr = uri.toString() + "/" + ozoneBucket.getVolumeName() + "/" + ozoneBucket.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatusAdapterForBucket: ozoneBucket={}, pathStr={}", (Object)(ozoneBucket.getVolumeName() + "/" + ozoneBucket.getName()), (Object)pathStr);
        }
        Path path = new Path(pathStr);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)ozoneBucket.getOwner());
        String owner = ugi.getShortUserName();
        String group = BasicRootedOzoneClientAdapterImpl.getGroupName(ugi);
        return new FileStatusAdapter(0L, 0L, path, true, 0, 0L, ozoneBucket.getCreationTime().getEpochSecond() * 1000L, 0L, FsPermission.getDirDefault().toShort(), owner, group, null, new BlockLocation[]{}, !StringUtils.isEmpty(ozoneBucket.getEncryptionKeyName()), ozoneBucket.getReplicationConfig() != null && ozoneBucket.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC);
    }

    private static FileStatusAdapter getFileStatusAdapterForBucketSnapshot(OzoneBucket ozoneBucket, OzoneSnapshot ozoneSnapshot, URI uri, String owner, String group) {
        String pathStr = uri.toString() + "/" + ozoneSnapshot.getVolumeName() + "/" + ozoneSnapshot.getBucketName() + "/" + ".snapshot" + "/" + ozoneSnapshot.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatusAdapterForBucketSnapshot: ozoneSnapshot={}, pathStr={}", (Object)ozoneSnapshot.getName(), (Object)pathStr);
        }
        Path path = new Path(pathStr);
        return new FileStatusAdapter(ozoneSnapshot.getReferencedSize(), ozoneSnapshot.getReferencedReplicatedSize(), path, true, 0, 0L, ozoneSnapshot.getCreationTime(), 0L, FsPermission.getDirDefault().toShort(), owner, group, null, new BlockLocation[]{}, !StringUtils.isEmpty(ozoneBucket.getEncryptionKeyName()), ozoneBucket.getReplicationConfig() != null && ozoneBucket.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC);
    }

    private static FileStatusAdapter getFileStatusAdapterWithSnapshotIndicator(OzoneVolume ozoneVolume, OzoneBucket ozoneBucket, URI uri) {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)ozoneVolume.getOwner());
        String owner = ugi.getShortUserName();
        String group = BasicRootedOzoneClientAdapterImpl.getGroupName(ugi);
        String pathStr = uri.toString() + "/" + ozoneBucket.getVolumeName() + "/" + ozoneBucket.getName() + "/" + ".snapshot";
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatusAdapterWithSnapshotIndicator: ozoneBucket={}, pathStr={}", (Object)(ozoneBucket.getVolumeName() + "/" + ozoneBucket.getName()), (Object)pathStr);
        }
        Path path = new Path(pathStr);
        return new FileStatusAdapter(0L, 0L, path, true, 0, 0L, ozoneBucket.getCreationTime().getEpochSecond() * 1000L, 0L, FsPermission.getDirDefault().toShort(), owner, group, null, new BlockLocation[]{}, !StringUtils.isEmpty(ozoneBucket.getEncryptionKeyName()), ozoneBucket.getReplicationConfig() != null && ozoneBucket.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC);
    }

    private static FileStatusAdapter getFileStatusAdapterForRoot(URI uri) {
        Path path = new Path(uri.toString() + "/");
        return new FileStatusAdapter(0L, 0L, path, true, 0, 0L, System.currentTimeMillis(), 0L, FsPermission.getDirDefault().toShort(), null, null, null, new BlockLocation[0], false, false);
    }

    @Override
    public boolean isFSOptimizedBucket() {
        return false;
    }

    @Override
    public FileChecksum getFileChecksum(String keyName, long length) throws IOException {
        OzoneClientConfig.ChecksumCombineMode combineMode = ((OzoneClientConfig)this.config.getObject(OzoneClientConfig.class)).getChecksumCombineMode();
        OFSPath ofsPath = new OFSPath(keyName, this.config);
        OzoneVolume volume = this.objectStore.getVolume(ofsPath.getVolumeName());
        OzoneBucket bucket = this.getBucket(ofsPath, false);
        return OzoneClientUtils.getFileChecksumWithCombineMode(volume, bucket, ofsPath.getKeyName(), length, combineMode, this.ozoneClient.getObjectStore().getClientProxy());
    }

    @Override
    public String createSnapshot(String pathStr, String snapshotName) throws IOException {
        OFSPath ofsPath = new OFSPath(pathStr, this.config);
        return this.proxy.createSnapshot(ofsPath.getVolumeName(), ofsPath.getBucketName(), snapshotName);
    }

    @Override
    public void renameSnapshot(String pathStr, String snapshotOldName, String snapshotNewName) throws IOException {
        OFSPath ofsPath = new OFSPath(pathStr, this.config);
        this.proxy.renameSnapshot(ofsPath.getVolumeName(), ofsPath.getBucketName(), snapshotOldName, snapshotNewName);
    }

    @Override
    public void deleteSnapshot(String pathStr, String snapshotName) throws IOException {
        OFSPath ofsPath = new OFSPath(pathStr, this.config);
        this.proxy.deleteSnapshot(ofsPath.getVolumeName(), ofsPath.getBucketName(), snapshotName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnapshotDiffReport getSnapshotDiffReport(Path snapshotDir, String fromSnapshot, String toSnapshot) throws IOException, InterruptedException {
        boolean takeTemporaryToSnapshot = false;
        boolean takeTemporaryFromSnapshot = false;
        if (toSnapshot.isEmpty()) {
            takeTemporaryToSnapshot = true;
            toSnapshot = this.createSnapshot(snapshotDir.toString(), OzoneFSUtils.generateUniqueTempSnapshotName());
        }
        if (fromSnapshot.isEmpty()) {
            takeTemporaryFromSnapshot = true;
            fromSnapshot = this.createSnapshot(snapshotDir.toString(), OzoneFSUtils.generateUniqueTempSnapshotName());
        }
        OFSPath ofsPath = new OFSPath(snapshotDir, this.config);
        String volume = ofsPath.getVolumeName();
        String bucket = ofsPath.getBucketName();
        try {
            SnapshotDiffReportOzone report;
            SnapshotDiffReportOzone aggregated = report = this.getSnapshotDiffReportOnceComplete(fromSnapshot, toSnapshot, volume, bucket, "");
            while (!report.getToken().isEmpty()) {
                LOG.info("Total Snapshot Diff length between snapshot {} and {} exceeds max page size, Performing another snapdiff with index at {}", new Object[]{fromSnapshot, toSnapshot, report.getToken()});
                report = this.getSnapshotDiffReportOnceComplete(fromSnapshot, toSnapshot, volume, bucket, report.getToken());
                aggregated.aggregate(report);
            }
            SnapshotDiffReportOzone snapshotDiffReportOzone = aggregated;
            return snapshotDiffReportOzone;
        }
        finally {
            if (takeTemporaryToSnapshot) {
                OzoneClientUtils.deleteSnapshot(this.objectStore, toSnapshot, volume, bucket);
            }
            if (takeTemporaryFromSnapshot) {
                OzoneClientUtils.deleteSnapshot(this.objectStore, fromSnapshot, volume, bucket);
            }
        }
    }

    private SnapshotDiffReportOzone getSnapshotDiffReportOnceComplete(String fromSnapshot, String toSnapshot, String volume, String bucket, String token) throws IOException, InterruptedException {
        SnapshotDiffResponse snapshotDiffResponse;
        while ((snapshotDiffResponse = this.objectStore.snapshotDiff(volume, bucket, fromSnapshot, toSnapshot, token, -1, false, false)).getJobStatus() != SnapshotDiffResponse.JobStatus.DONE) {
            Thread.sleep(snapshotDiffResponse.getWaitTimeInMs());
        }
        return snapshotDiffResponse.getSnapshotDiffReport();
    }

    @Override
    public boolean isFileClosed(String pathStr) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_IS_FILE_CLOSED, 1L);
        OFSPath ofsPath = new OFSPath(pathStr, this.config);
        String key = ofsPath.getKeyName();
        if (ofsPath.isRoot() || ofsPath.isVolume()) {
            throw new FileNotFoundException("Path is not a file.");
        }
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, false);
            if (ofsPath.isSnapshotPath()) {
                throw new IOException("file is in a snapshot.");
            }
            OzoneFileStatus status = bucket.getFileStatus(key);
            if (!status.isFile()) {
                throw new FileNotFoundException("Path is not a file.");
            }
            return !status.getKeyInfo().isHsync();
        }
        catch (OMException ome) {
            if (ome.getResult() == OMException.ResultCodes.FILE_NOT_FOUND || ome.getResult() == OMException.ResultCodes.VOLUME_NOT_FOUND || ome.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw new FileNotFoundException("File does not exist. " + ome.getMessage());
            }
            throw ome;
        }
    }

    @Override
    public LeaseKeyInfo recoverFilePrepare(String pathStr, boolean force) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_RECOVER_FILE_PREPARE, 1L);
        OFSPath ofsPath = new OFSPath(pathStr, this.config);
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, false);
            ClientProtocol clientProtocol = this.ozoneClient.getProxy();
            return clientProtocol.recoverLease(bucket.getVolumeName(), bucket.getName(), ofsPath.getKeyName(), force);
        }
        catch (OMException ome) {
            if (ome.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileNotFoundException("Path is not a file. " + ome.getMessage());
            }
            if (ome.getResult() == OMException.ResultCodes.KEY_NOT_FOUND || ome.getResult() == OMException.ResultCodes.DIRECTORY_NOT_FOUND || ome.getResult() == OMException.ResultCodes.VOLUME_NOT_FOUND || ome.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw new FileNotFoundException("File does not exist. " + ome.getMessage());
            }
            throw ome;
        }
    }

    @Override
    public void recoverFile(OmKeyArgs keyArgs) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_RECOVER_FILE, 1L);
        ClientProtocol clientProtocol = this.ozoneClient.getProxy();
        clientProtocol.recoverKey(keyArgs, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long finalizeBlock(OmKeyLocationInfo block) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_FINALIZE_BLOCK, 1L);
        RpcClient rpcClient = (RpcClient)this.ozoneClient.getProxy();
        XceiverClientFactory xceiverClientFactory = rpcClient.getXceiverClientManager();
        Pipeline pipeline = block.getPipeline();
        XceiverClientSpi client = null;
        try {
            if (pipeline.isOpen()) {
                client = xceiverClientFactory.acquireClient(pipeline);
                ContainerProtos.FinalizeBlockResponseProto finalizeBlockResponseProto = ContainerProtocolCalls.finalizeBlock(client, block.getBlockID().getDatanodeBlockIDProtobuf(), block.getToken());
                long l = BlockData.getFromProtoBuf(finalizeBlockResponseProto.getBlockData()).getSize();
                return l;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to execute finalizeBlock command", (Throwable)e);
        }
        finally {
            if (client != null) {
                xceiverClientFactory.releaseClient(client, false);
            }
        }
        ReplicationConfig replicationConfig = pipeline.getReplicationConfig();
        if (!(replicationConfig instanceof ReplicatedReplicationConfig)) {
            throw new IOException("ReplicationConfig type " + replicationConfig.getClass().getSimpleName() + " is not supported in finalizeBlock");
        }
        StandaloneReplicationConfig newConfig = StandaloneReplicationConfig.getInstance(((ReplicatedReplicationConfig)replicationConfig).getReplicationFactor());
        Pipeline.Builder builder = Pipeline.newBuilder().setReplicationConfig(newConfig).setId(PipelineID.randomId()).setNodes(block.getPipeline().getNodes()).setState(Pipeline.PipelineState.OPEN);
        try {
            client = xceiverClientFactory.acquireClientForReadData(builder.build());
            ContainerProtos.GetCommittedBlockLengthResponseProto responseProto = ContainerProtocolCalls.getCommittedBlockLength(client, block.getBlockID(), block.getToken());
            long l = responseProto.getBlockLength();
            return l;
        }
        finally {
            if (client != null) {
                xceiverClientFactory.releaseClient(client, false);
            }
        }
    }

    @Override
    public void setTimes(String key, long mtime, long atime) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_SET_TIMES, 1L);
        OFSPath ofsPath = new OFSPath(key, this.config);
        OzoneBucket bucket = this.getBucket(ofsPath, false);
        bucket.setTimes(ofsPath.getKeyName(), mtime, atime);
    }

    @Override
    public boolean setSafeMode(SafeModeAction action, boolean isChecked) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_SET_SAFE_MODE, 1L);
        return this.ozoneClient.getProxy().getOzoneManagerClient().setSafeMode(action, isChecked);
    }

    public static class IteratorAdapter
    implements Iterator<BasicKeyInfo> {
        private Iterator<? extends OzoneKey> original;

        public IteratorAdapter(Iterator<? extends OzoneKey> listKeys) {
            this.original = listKeys;
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public BasicKeyInfo next() {
            OzoneKey next = this.original.next();
            if (next == null) {
                return null;
            }
            return new BasicKeyInfo(next.getName(), next.getModificationTime().toEpochMilli(), next.getDataSize());
        }
    }
}

