/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithParentObjectId;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OmDirectoryInfo
extends WithParentObjectId {
    private String name;
    private long creationTime;
    private long modificationTime;
    private List<OzoneAcl> acls;

    public OmDirectoryInfo(Builder builder) {
        this.name = builder.name;
        this.acls = builder.acls;
        this.metadata = builder.metadata;
        this.objectID = builder.objectID;
        this.updateID = builder.updateID;
        this.parentObjectID = builder.parentObjectID;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return this.getPath() + ":" + this.getObjectID();
    }

    @Override
    public long getParentObjectID() {
        return this.parentObjectID;
    }

    public String getPath() {
        return this.getParentObjectID() + "/" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public OzoneManagerProtocolProtos.DirectoryInfo getProtobuf() {
        OzoneManagerProtocolProtos.DirectoryInfo.Builder pib = OzoneManagerProtocolProtos.DirectoryInfo.newBuilder().setName(this.name).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).addAllMetadata(KeyValueUtil.toProtobuf(this.metadata)).setObjectID(this.objectID).setUpdateID(this.updateID).setParentID(this.parentObjectID);
        if (this.acls != null) {
            pib.addAllAcls(OzoneAclUtil.toProtobuf(this.acls));
        }
        return pib.build();
    }

    public static OmDirectoryInfo getFromProtobuf(OzoneManagerProtocolProtos.DirectoryInfo dirInfo) {
        Builder opib = OmDirectoryInfo.newBuilder().setName(dirInfo.getName()).setCreationTime(dirInfo.getCreationTime()).setModificationTime(dirInfo.getModificationTime()).setAcls(OzoneAclUtil.fromProtobuf(dirInfo.getAclsList()));
        if (dirInfo.getMetadataList() != null) {
            opib.addAllMetadata(KeyValueUtil.getFromProtobuf(dirInfo.getMetadataList()));
        }
        if (dirInfo.hasObjectID()) {
            opib.setObjectID(dirInfo.getObjectID());
        }
        if (dirInfo.hasParentID()) {
            opib.setParentObjectID(dirInfo.getParentID());
        }
        if (dirInfo.hasUpdateID()) {
            opib.setUpdateID(dirInfo.getUpdateID());
        }
        return opib.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OmDirectoryInfo omDirInfo = (OmDirectoryInfo)o;
        return this.creationTime == omDirInfo.creationTime && this.modificationTime == omDirInfo.modificationTime && this.name.equals(omDirInfo.name) && Objects.equals(this.metadata, omDirInfo.metadata) && Objects.equals(this.acls, omDirInfo.acls) && this.objectID == omDirInfo.objectID && this.updateID == omDirInfo.updateID && this.parentObjectID == omDirInfo.parentObjectID;
    }

    public int hashCode() {
        return Objects.hash(this.objectID, this.parentObjectID, this.name);
    }

    public OmDirectoryInfo copyObject() {
        Builder builder = new Builder().setName(this.name).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).setParentObjectID(this.parentObjectID).setObjectID(this.objectID).setUpdateID(this.updateID);
        this.acls.forEach(acl -> builder.addAcl(new OzoneAcl(acl.getType(), acl.getName(), (BitSet)acl.getAclBitSet().clone(), acl.getAclScope())));
        if (this.metadata != null) {
            this.metadata.forEach((k, v) -> builder.addMetadata((String)k, (String)v));
        }
        return builder.build();
    }

    public static class Builder {
        private long parentObjectID;
        private long objectID;
        private long updateID;
        private String name;
        private long creationTime;
        private long modificationTime;
        private List<OzoneAcl> acls = new LinkedList<OzoneAcl>();
        private Map<String, String> metadata = new HashMap<String, String>();

        public Builder setParentObjectID(long parentObjectId) {
            this.parentObjectID = parentObjectId;
            return this;
        }

        public Builder setObjectID(long objectId) {
            this.objectID = objectId;
            return this;
        }

        public Builder setUpdateID(long updateId) {
            this.updateID = updateId;
            return this;
        }

        public Builder setName(String dirName) {
            this.name = dirName;
            return this;
        }

        public Builder setCreationTime(long newCreationTime) {
            this.creationTime = newCreationTime;
            return this;
        }

        public Builder setModificationTime(long newModificationTime) {
            this.modificationTime = newModificationTime;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            if (listOfAcls != null) {
                this.acls.addAll(listOfAcls);
            }
            return this;
        }

        public Builder addAcl(OzoneAcl ozoneAcl) {
            if (ozoneAcl != null) {
                this.acls.add(ozoneAcl);
            }
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> additionalMetadata) {
            if (additionalMetadata != null) {
                this.metadata.putAll(additionalMetadata);
            }
            return this;
        }

        public OmDirectoryInfo build() {
            return new OmDirectoryInfo(this);
        }
    }
}

