/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.Objects;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class OmDBTenantState
implements Comparable<OmDBTenantState> {
    private final String tenantId;
    private final String bucketNamespaceName;
    private final String userRoleName;
    private final String adminRoleName;
    private final String bucketNamespacePolicyName;
    private final String bucketPolicyName;

    public OmDBTenantState(String tenantId, String bucketNamespaceName, String userRoleName, String adminRoleName, String bucketNamespacePolicyName, String bucketPolicyName) {
        this.tenantId = tenantId;
        this.bucketNamespaceName = bucketNamespaceName;
        this.userRoleName = userRoleName;
        this.adminRoleName = adminRoleName;
        this.bucketNamespacePolicyName = bucketNamespacePolicyName;
        this.bucketPolicyName = bucketPolicyName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OmDBTenantState that = (OmDBTenantState)o;
        return Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.bucketNamespaceName, that.bucketNamespaceName) && Objects.equals(this.userRoleName, that.userRoleName) && Objects.equals(this.adminRoleName, that.adminRoleName) && Objects.equals(this.bucketNamespacePolicyName, that.bucketNamespacePolicyName) && Objects.equals(this.bucketPolicyName, that.bucketPolicyName);
    }

    public int hashCode() {
        return Objects.hash(this.tenantId, this.bucketNamespaceName, this.userRoleName, this.adminRoleName, this.bucketNamespacePolicyName, this.bucketPolicyName);
    }

    @Override
    public int compareTo(OmDBTenantState o) {
        return this.getTenantId().compareTo(o.getTenantId());
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getBucketNamespaceName() {
        return this.bucketNamespaceName;
    }

    public String getUserRoleName() {
        return this.userRoleName;
    }

    public String getAdminRoleName() {
        return this.adminRoleName;
    }

    public String getBucketNamespacePolicyName() {
        return this.bucketNamespacePolicyName;
    }

    public String getBucketPolicyName() {
        return this.bucketPolicyName;
    }

    public OzoneManagerProtocolProtos.TenantState getProtobuf() {
        return OzoneManagerProtocolProtos.TenantState.newBuilder().setTenantId(this.tenantId).setBucketNamespaceName(this.bucketNamespaceName).setUserRoleName(this.userRoleName).setAdminRoleName(this.adminRoleName).setBucketNamespacePolicyName(this.bucketNamespacePolicyName).setBucketPolicyName(this.bucketPolicyName).build();
    }

    public static OmDBTenantState getFromProtobuf(OzoneManagerProtocolProtos.TenantState proto) {
        return new Builder().setTenantId(proto.getTenantId()).setBucketNamespaceName(proto.getBucketNamespaceName()).setUserRoleName(proto.getUserRoleName()).setAdminRoleName(proto.getAdminRoleName()).setBucketNamespacePolicyName(proto.getBucketNamespacePolicyName()).setBucketPolicyName(proto.getBucketPolicyName()).build();
    }

    public static final class Builder {
        private String tenantId;
        private String bucketNamespaceName;
        private String userRoleName;
        private String adminRoleName;
        private String bucketNamespacePolicyName;
        private String bucketPolicyName;

        private Builder() {
        }

        public Builder setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder setBucketNamespaceName(String bucketNamespaceName) {
            this.bucketNamespaceName = bucketNamespaceName;
            return this;
        }

        public Builder setUserRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
            return this;
        }

        public Builder setAdminRoleName(String adminRoleName) {
            this.adminRoleName = adminRoleName;
            return this;
        }

        public Builder setBucketNamespacePolicyName(String bucketNamespacePolicyName) {
            this.bucketNamespacePolicyName = bucketNamespacePolicyName;
            return this;
        }

        public Builder setBucketPolicyName(String bucketPolicyName) {
            this.bucketPolicyName = bucketPolicyName;
            return this;
        }

        public OmDBTenantState build() {
            return new OmDBTenantState(this.tenantId, this.bucketNamespaceName, this.userRoleName, this.adminRoleName, this.bucketNamespacePolicyName, this.bucketPolicyName);
        }
    }
}

